/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.AbstractChainCollection;
import org.eclipse.serializer.collections.AbstractChainEntryLinked;
import org.eclipse.serializer.collections.AbstractChainStorage;
import org.eclipse.serializer.collections.ChainEntryLinkedHashedStrong;
import org.eclipse.serializer.collections.ChainStorageStrong;
import org.eclipse.serializer.collections.EnumView;
import org.eclipse.serializer.collections.EqConstHashEnum;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.interfaces.CapacityExtendable;
import org.eclipse.serializer.collections.interfaces.ChainStorage;
import org.eclipse.serializer.collections.interfaces.HashCollection;
import org.eclipse.serializer.collections.old.AbstractBridgeXSet;
import org.eclipse.serializer.collections.types.XEnum;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.Copyable;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;

public final class EqHashEnum<E>
extends AbstractChainCollection<E, E, E, ChainEntryLinkedHashedStrong<E>>
implements XEnum<E>,
HashCollection<E>,
Composition {
    private final AbstractChainStorage<E, E, E, ChainEntryLinkedHashedStrong<E>> chain;
    ChainEntryLinkedHashedStrong<E>[] slots;
    final HashEqualator<? super E> hashEqualator;
    float hashDensity;
    transient int capacity;
    transient int range;
    int size;

    public static final <E> EqHashEnum<E> New() {
        return new EqHashEnum(1, 1.0f, XHashing.hashEqualityValue());
    }

    public static final <E> EqHashEnum<E> NewCustom(int initialCapacity) {
        return new EqHashEnum(XHashing.padHashLength(initialCapacity), 1.0f, XHashing.hashEqualityValue());
    }

    public static final <E> EqHashEnum<E> NewCustom(int initialCapacity, float hashDensity) {
        return new EqHashEnum(XHashing.padHashLength(initialCapacity), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
    }

    public static final <E> EqHashEnum<E> New(HashEqualator<? super E> hashEqualator) {
        return new EqHashEnum<E>(1, 1.0f, hashEqualator);
    }

    public static final <E> EqHashEnum<E> NewCustom(HashEqualator<? super E> hashEqualator, int initialCapacity) {
        return new EqHashEnum<E>(XHashing.padHashLength(initialCapacity), 1.0f, hashEqualator);
    }

    public static final <E> EqHashEnum<E> NewCustom(HashEqualator<? super E> hashEqualator, float hashDensity) {
        return new EqHashEnum<E>(1, hashDensity, hashEqualator);
    }

    public static final <E> EqHashEnum<E> NewCustom(HashEqualator<? super E> hashEqualator, int initialCapacity, float hashDensity) {
        return new EqHashEnum<E>(XHashing.padHashLength(initialCapacity), XHashing.validateHashDensity(hashDensity), hashEqualator);
    }

    @SafeVarargs
    public static final <E> EqHashEnum<E> New(E ... entries) {
        return EqHashEnum.NewCustom(XHashing.hashEqualityValue(), 1.0f, entries);
    }

    public static final <E> EqHashEnum<E> New(XGettingCollection<? extends E> entries) {
        return EqHashEnum.New().addAll((XGettingCollection)entries);
    }

    @SafeVarargs
    public static final <E> EqHashEnum<E> NewCustom(float hashDensity, E ... entries) {
        return EqHashEnum.NewCustom(XHashing.hashEqualityValue(), hashDensity, entries);
    }

    @SafeVarargs
    public static final <E> EqHashEnum<E> New(HashEqualator<? super E> hashEqualator, E ... entries) {
        return EqHashEnum.NewCustom(hashEqualator, 1.0f, entries);
    }

    @SafeVarargs
    public static final <E> EqHashEnum<E> NewCustom(HashEqualator<? super E> hashEqualator, float hashDensity, E ... entries) {
        return new EqHashEnum<E>(XHashing.padHashLength(entries.length), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator)).addAll((Object[])entries);
    }

    private EqHashEnum(EqHashEnum<E> original) {
        this.hashDensity = original.hashDensity;
        this.hashEqualator = original.hashEqualator;
        this.range = original.range;
        this.slots = ChainEntryLinkedHashedStrong.array(original.slots.length);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedHashedStrong<Object>>(this, new ChainEntryLinkedHashedStrong<Object>(-1, null, null));
        this.capacity = original.capacity;
    }

    private EqHashEnum(int pow2InitialHashLength, float positiveHashDensity, HashEqualator<? super E> hashEqualator) {
        this.hashDensity = positiveHashDensity;
        this.hashEqualator = hashEqualator;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainEntryLinkedHashedStrong.array(pow2InitialHashLength);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedHashedStrong<Object>>(this, new ChainEntryLinkedHashedStrong<Object>(-1, null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    private ChainEntryLinkedHashedStrong<E> createNewEntry(int hash, E element) {
        if (this.size >= this.capacity) {
            EqHashEnum.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainEntryLinkedHashedStrong<E> e = new ChainEntryLinkedHashedStrong<E>(hash, element, this.slots[hash & this.range]);
        this.slots[hash & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainEntryLinkedHashedStrong<E>[] newSlots = ChainEntryLinkedHashedStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainEntryLinkedHashedStrong element = this.chain.head();
        while ((element = (ChainEntryLinkedHashedStrong)element.next) != null) {
            element.link = newSlots[element.hash & modulo];
            newSlots[element.hash & modulo] = element;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    final void internalCollectUnhashed(E element) {
        this.chain.appendEntry(new ChainEntryLinkedHashedStrong<E>(0, element, null));
    }

    @Override
    public boolean nullAllowed() {
        throw new NotImplementedYetError();
    }

    @Override
    protected ChainStorage<E, E, E, ChainEntryLinkedHashedStrong<E>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    protected int internalRemoveNullEntries() {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected void internalRemoveEntry(ChainEntryLinkedHashedStrong<E> entry) {
        this.internalUnhashByEntry(entry);
        --this.size;
        this.chain.disjoinEntry(entry);
    }

    @Override
    protected int internalClear() {
        int size = this.size;
        this.clear();
        return size;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final void clear() {
        this.chain.clear();
        ChainEntryLinkedHashedStrong<E>[] slots = this.slots;
        int i = 0;
        int length = slots.length;
        while (i < length) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public final void truncate() {
        this.chain.clear();
        this.slots = ChainEntryLinkedHashedStrong.array(1);
        this.size = 0;
        this.capacity = (int)(1.0f * this.hashDensity);
    }

    @Override
    public final long consolidate() {
        return this.chain.consolidate();
    }

    @Override
    public final CapacityExtendable ensureCapacity(long minimalCapacity) {
        if ((long)this.capacity >= minimalCapacity) {
            return this;
        }
        int requiredSlotLength = (int)((float)minimalCapacity / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final CapacityExtendable ensureFreeCapacity(long requiredFreeCapacity) {
        if ((long)(this.capacity - this.size) >= requiredFreeCapacity) {
            return this;
        }
        if ((long)(Integer.MAX_VALUE - this.size) < requiredFreeCapacity) {
            throw new ArrayCapacityException(requiredFreeCapacity + (long)this.size);
        }
        int requiredSlotLength = (int)((float)((long)this.size + requiredFreeCapacity) / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final long optimize() {
        int requiredCapacity = (int)((float)this.size / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredCapacity)) {
            if (this.slots.length != Integer.MAX_VALUE) {
                this.rebuildStorage(Integer.MAX_VALUE);
            }
            return this.capacity;
        }
        int newCapacity = XHashing.padHashLength(requiredCapacity);
        if (this.slots.length != newCapacity) {
            this.rebuildStorage(newCapacity);
        }
        return this.capacity;
    }

    @Override
    public final int rehash() {
        int reqCapacity = XHashing.padHashLength((int)((float)this.size / this.hashDensity));
        ChainEntryLinkedHashedStrong<E>[] slots = ChainEntryLinkedHashedStrong.array(reqCapacity);
        int range = reqCapacity >= Integer.MAX_VALUE ? Integer.MAX_VALUE : reqCapacity - 1;
        HashEqualator<E> hashEqualator = this.hashEqualator;
        AbstractChainStorage<E, E, E, ChainEntryLinkedHashedStrong<E>> chain = this.chain;
        ChainEntryLinkedHashedStrong element = (ChainEntryLinkedHashedStrong)chain.head().next;
        chain.clear();
        int size = 0;
        while (element != null) {
            block3: {
                int hash = hashEqualator.hash(element.element);
                ChainEntryLinkedHashedStrong e = slots[hash & range];
                while (e != null) {
                    if (e.hash != hash || !hashEqualator.equal(e.element, element.element)) {
                        e = (ChainEntryLinkedHashedStrong)e.link;
                        continue;
                    }
                    break block3;
                }
                ChainEntryLinkedHashedStrong chainEntryLinkedHashedStrong = new ChainEntryLinkedHashedStrong(hash, element.element, slots[hash & range]);
                slots[hash & range] = chainEntryLinkedHashedStrong;
                chain.appendEntry(chainEntryLinkedHashedStrong);
                ++size;
            }
            element = (ChainEntryLinkedHashedStrong)element.next;
        }
        this.slots = slots;
        this.range = range;
        this.size = size;
        return size;
    }

    @Override
    public final EqHashEnum<E> copy() {
        final EqHashEnum<E> newVarMap = new EqHashEnum<E>(this);
        this.chain.iterate(new Consumer<E>(){

            @Override
            public void accept(E element) {
                newVarMap.put(element);
            }
        });
        return newVarMap;
    }

    @Override
    public final EqConstHashEnum<E> immure() {
        this.consolidate();
        return EqConstHashEnum.New(this.hashEqualator, this.hashDensity, this);
    }

    @Override
    public final XGettingEnum<E> view() {
        return new EnumView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
        this.hashDensity = XHashing.validateHashDensity(hashDensity);
        this.capacity = (int)((float)this.slots.length * this.hashDensity);
        this.optimize();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final OldVarSet<E> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public final long currentCapacity() {
        return this.capacity;
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final E addGet(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return e.element;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, element));
        return null;
    }

    @Override
    public final E deduplicate(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return e.element;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, element));
        return element;
    }

    @Override
    public final E putGet(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return e.setElement(element);
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, element));
        return null;
    }

    @Override
    public final E replace(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return e.setElement(element);
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean add(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return false;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, element));
        return true;
    }

    @Override
    public final boolean put(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                e.setElement0(element);
                return false;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, element));
        return true;
    }

    @Override
    public final HashCollection.Analysis<EqHashEnum<E>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<? super E> hashEquality() {
        return this.hashEqualator;
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('['), ",").append(']').toString();
    }

    @Override
    public final EqHashEnum<E> sort(Comparator<? super E> comparator) {
        this.chain.sort(comparator);
        return this;
    }

    @Override
    public final XEnum<E> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final E[] toArray(Class<E> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(E element) {
        return this.chain.count((E)element, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (hash == e.hash && element == e.element) {
                return true;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return true;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return false;
    }

    @Override
    public final E seek(E sample) {
        if (sample == null) {
            return null;
        }
        int hash = this.hashEqualator.hash(sample);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, sample)) {
                return e.element;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        return elements.applies(this::contains);
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof EqHashEnum)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        this.consolidate();
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        if (target == this) {
            return target;
        }
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        return this.distinct(target, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final boolean nullAdd() {
        return this.add(null);
    }

    @Override
    @SafeVarargs
    public final EqHashEnum<E> addAll(E ... elements) {
        int i = 0;
        int len = elements.length;
        while (i < len) {
            this.add(elements[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final EqHashEnum<E> addAll(E[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        int i = srcIndex;
        while (i != bound) {
            this.add(elements[i]);
            i += d;
        }
        return this;
    }

    @Override
    public final EqHashEnum<E> addAll(XGettingCollection<? extends E> elements) {
        elements.iterate(this::add);
        return this;
    }

    @Override
    public final boolean nullPut() {
        return this.put(null);
    }

    @Override
    public final void accept(E element) {
        this.put(element);
    }

    @Override
    @SafeVarargs
    public final EqHashEnum<E> putAll(E ... elements) {
        int i = 0;
        int len = elements.length;
        while (i < len) {
            this.put(elements[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final EqHashEnum<E> putAll(E[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        int i = srcIndex;
        while (i != bound) {
            this.put(elements[i]);
            i += d;
        }
        return this;
    }

    @Override
    public final EqHashEnum<E> putAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public final long remove(E element) {
        ChainEntryLinkedHashedStrong<E> e = this.internalUnhashByElement(element);
        if (e == null) {
            return 0L;
        }
        --this.size;
        this.chain.disjoinEntry(e);
        return 1L;
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        return this.chain.substitute(mapper, this::replace);
    }

    final void replace(ChainEntryLinkedHashedStrong<E> oldEntry, E newElement) {
        int newHash = this.hashEqualator.hash(newElement);
        ChainEntryLinkedHashedStrong e = this.slots[newHash & this.range];
        while (e != null) {
            if (e.hash == newHash && this.hashEqualator.equal(e.element, newElement) && e == oldEntry) {
                e.element = newElement;
                return;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        throw new UnsupportedOperationException("Hash-changing replacement not supported, yet.");
    }

    /*
     * Unable to fully structure code
     */
    private ChainEntryLinkedHashedStrong<E> internalUnhashByElement(E element) {
        e = this.slots[this.hashEqualator.hash(element) & this.range];
        if (e.element != element) ** GOTO lbl8
        this.slots[this.hashEqualator.hash(element) & this.range] = (ChainEntryLinkedHashedStrong)e.link;
        return e;
lbl-1000:
        // 1 sources

        {
            if (e.element == element) {
                last.link = (ChainEntryLinkedHashedStrong)e.link;
                return e;
            }
lbl8:
            // 3 sources

            last = e;
            ** while ((e = (ChainEntryLinkedHashedStrong)last.link) != null)
        }
lbl10:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void internalUnhashByEntry(ChainEntryLinkedHashedStrong<E> entry) {
        e = this.slots[entry.hash & this.range];
        if (e != entry) ** GOTO lbl8
        this.slots[entry.hash & this.range] = (ChainEntryLinkedHashedStrong)entry.link;
        return;
lbl-1000:
        // 1 sources

        {
            if (e == entry) {
                last.link = (ChainEntryLinkedHashedStrong)entry.link;
                return;
            }
lbl8:
            // 3 sources

            last = e;
            ** while ((e = (ChainEntryLinkedHashedStrong)last.link) != null)
        }
lbl10:
        // 1 sources

        throw new IllegalArgumentException("Set element inconsistency detected");
    }

    @Override
    public final long nullRemove() {
        return this.remove(null);
    }

    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        return this.chain.reduce(predicate);
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> elements) {
        return this.chain.retainAll(elements, this.hashEqualator);
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        this.chain.process(procedure);
        return procedure;
    }

    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        this.chain.moveTo(target, predicate);
        return target;
    }

    @Override
    public final long removeAll(XGettingCollection<? extends E> elements) {
        int oldSize = this.size;
        elements.iterate(this::remove);
        return oldSize - this.size;
    }

    @Override
    public final long removeDuplicates() {
        return 0L;
    }

    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        return this.chain.removeDuplicates(equalator);
    }

    @Override
    public final EqHashEnum<E> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((EqHashEnum)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final E at(long index) {
        return this.chain.get(index);
    }

    @Override
    public final E get() {
        return this.chain.first();
    }

    @Override
    public final E first() {
        return this.chain.first();
    }

    @Override
    public final E last() {
        return this.chain.last();
    }

    @Override
    public final E poll() {
        return this.size == 0 ? null : (E)this.chain.first();
    }

    @Override
    public final E peek() {
        return this.size == 0 ? null : (E)this.chain.last();
    }

    @Override
    public final long indexOf(E element) {
        return this.chain.indexOf((E)element, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(E element) {
        return this.chain.lastIndexOf((E)element, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        this.chain.moveSelection(target, indices);
        return target;
    }

    @Override
    public final E removeAt(long index) {
        return this.chain.remove(index);
    }

    @Override
    public final E fetch() {
        return this.chain.remove(0L);
    }

    @Override
    public final E pop() {
        return this.chain.remove(this.size - 1);
    }

    @Override
    public final E pinch() {
        return this.size == 0 ? null : (E)this.chain.remove(0L);
    }

    @Override
    public final E pick() {
        return this.size == 0 ? null : (E)this.chain.remove(this.size - 1);
    }

    @Override
    public final E retrieve(E element) {
        return this.chain.retrieve((E)element, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        return this.chain.retrieve(predicate);
    }

    @Override
    public final boolean removeOne(E element) {
        return this.chain.removeOne((E)element, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final EqHashEnum<E> removeRange(long startIndex, long length) {
        this.chain.removeRange(startIndex, length);
        return this;
    }

    @Override
    public final EqHashEnum<E> retainRange(long startIndex, long length) {
        this.chain.retainRange(startIndex, length);
        return this;
    }

    @Override
    public final long removeSelection(long[] indices) {
        return this.chain.removeSelection(indices);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final EqHashEnum<E> reverse() {
        this.chain.reverse();
        return this;
    }

    @Override
    public final EqHashEnum<E> shiftTo(long sourceIndex, long targetIndex) {
        this.chain.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final EqHashEnum<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.chain.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final EqHashEnum<E> shiftBy(long sourceIndex, long distance) {
        this.chain.shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public final EqHashEnum<E> shiftBy(long sourceIndex, long distance, long length) {
        this.chain.shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public final EqHashEnum<E> swap(long indexA, long indexB) {
        this.chain.swap(indexA, indexB);
        return this;
    }

    @Override
    public final EqHashEnum<E> swap(long indexA, long indexB, long length) {
        this.chain.swap(indexA, indexB, length);
        return this;
    }

    @Override
    public final HashEqualator<? super E> equality() {
        return this.hashEqualator;
    }

    @Override
    public final boolean input(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long inputAll(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long inputAll(long index, XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean insert(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long insertAll(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long insertAll(long index, XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean prepend(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean preput(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final EqHashEnum<E> prependAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EqHashEnum<E> prependAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EqHashEnum<E> prependAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final EqHashEnum<E> preputAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EqHashEnum<E> preputAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EqHashEnum<E> preputAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean set(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final E setGet(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setFirst(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setLast(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final EqHashEnum<E> setAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EqHashEnum<E> set(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EqHashEnum<E> set(long index, XGettingSequence<? extends E> elements, long offset, long length) {
        throw new NotImplementedYetError();
    }

    public static final class OldVarSet<E>
    extends AbstractBridgeXSet<E> {
        OldVarSet(EqHashEnum<E> set) {
            super(set);
        }

        @Override
        public EqHashEnum<E> parent() {
            return (EqHashEnum)super.parent();
        }
    }
}

