/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.X2DMap;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public final class EqHash2DMap<K1, K2, V>
implements X2DMap<K1, K2, V>,
Composition {
    final HashEqualator<K1> k1HashEqualator;
    final HashEqualator<K2> k2HashEqualator;
    final EqHashTable<K1, EqHashTable<K2, V>> tree1;

    public static final <K1, K2, V> EqHash2DMap<K1, K2, V> New() {
        return new EqHash2DMap(XHashing.hashEqualityValue(), XHashing.hashEqualityValue());
    }

    public static final <K1, K2, V> EqHash2DMap<K1, K2, V> New(HashEqualator<K1> k1HashEqualator, HashEqualator<K2> k2HashEqualator) {
        return new EqHash2DMap<K1, K2, V>(k1HashEqualator, k2HashEqualator);
    }

    private EqHash2DMap(HashEqualator<K1> k1HashEqualator, HashEqualator<K2> k2HashEqualator) {
        this.k1HashEqualator = X.coalesce(k1HashEqualator, XHashing.hashEqualityValue());
        this.k2HashEqualator = X.coalesce(k2HashEqualator, XHashing.hashEqualityValue());
        this.tree1 = EqHashTable.New(this.k1HashEqualator);
    }

    final EqHashTable<K2, V> createTree2() {
        return EqHashTable.New(this.k2HashEqualator);
    }

    final EqHashTable<K2, V> ensureTree2(K1 key1) {
        EqHashTable<K2, V> tree2 = this.tree1.get(key1);
        if (tree2 == null) {
            tree2 = this.createTree2();
            this.tree1.add(key1, tree2);
        }
        return tree2;
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K1, ? extends XGettingMap<K2, V>>>> P iterate(P procedure) {
        return this.tree1.iterate(procedure);
    }

    @Override
    public final EqHashTable<K1, EqHashTable<K2, V>> get() {
        return this.tree1;
    }

    @Override
    public final EqHashTable<K2, V> get(K1 key1) {
        return this.tree1.get(key1);
    }

    @Override
    public final V get(K1 key1, K2 key2) {
        EqHashTable<K2, V> tree2 = this.tree1.get(key1);
        if (tree2 == null) {
            return null;
        }
        return tree2.get(key2);
    }

    @Override
    public final boolean add(K1 key1, K2 key2, V value) {
        return this.ensureTree2(key1).add(key2, value);
    }

    @Override
    public final boolean put(K1 key1, K2 key2, V value) {
        return this.ensureTree2(key1).put(key2, value);
    }

    @Override
    public final V ensure(K1 key1, K2 key2, Function<? super K2, V> valueSupplier) {
        return this.ensureTree2(key1).ensure(key2, valueSupplier);
    }

    @Override
    public final <PK1 extends Consumer<? super K1>> PK1 iterateKeys1(PK1 procedure) {
        return this.tree1.keys().iterate(procedure);
    }

    @Override
    public final <PK2 extends Consumer<? super K2>> PK2 iterateKeys2(final PK2 procedure) {
        this.tree1.values().iterate(new Consumer<EqHashTable<K2, V>>(){

            @Override
            public void accept(EqHashTable<K2, V> tree2) {
                tree2.keys().iterate(procedure);
            }
        });
        return procedure;
    }

    @Override
    public final <PV extends Consumer<? super V>> PV iterateValues(final PV procedure) {
        this.tree1.values().iterate(new Consumer<EqHashTable<K2, V>>(){

            @Override
            public void accept(EqHashTable<K2, V> tree2) {
                tree2.values().iterate(procedure);
            }
        });
        return procedure;
    }

    @Override
    public <PIE extends Consumer<? super KeyValue<K2, V>>> PIE iterateInnerEntries(final PIE procedure) {
        this.tree1.values().iterate(new Consumer<EqHashTable<K2, V>>(){

            @Override
            public void accept(EqHashTable<K2, V> tree2) {
                tree2.iterate(procedure);
            }
        });
        return procedure;
    }
}

