/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import org.eclipse.serializer.collections.MiniMap;
import org.eclipse.serializer.equality.IdentityEqualityLogic;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.KeyValue;

public final class ConstMiniMap<K, V>
implements IdentityEqualityLogic {
    private final Entry<K, V>[] slots;
    private final int modulo;
    private final int size;

    ConstMiniMap(int size, MiniMap.Entry<K, V>[] source) {
        int modulo;
        this.size = size;
        Entry[] slots = new Entry[XMath.pow2BoundMaxed(this.size)];
        this.slots = slots;
        this.modulo = modulo = slots.length - 1;
        int i = 0;
        while (i < source.length) {
            MiniMap.Entry<K, V> entry = source[i];
            while (entry != null) {
                slots[System.identityHashCode(entry.key) & modulo] = new Entry(entry.key, entry.value, slots[System.identityHashCode(entry.key) & modulo]);
                entry = entry.link;
            }
            ++i;
        }
    }

    ConstMiniMap(int size, Entry<K, V>[] source) {
        int modulo;
        this.size = size;
        Entry[] slots = new Entry[XMath.pow2BoundMaxed(this.size)];
        this.slots = slots;
        this.modulo = modulo = slots.length - 1;
        int i = 0;
        while (i < source.length) {
            Entry<K, V> entry = source[i];
            while (entry != null) {
                slots[System.identityHashCode(entry.key) & modulo] = new Entry(entry.key, entry.value, slots[System.identityHashCode(entry.key) & modulo]);
                entry = entry.link;
            }
            ++i;
        }
    }

    public ConstMiniMap() {
        this.size = 0;
        this.modulo = 0;
        this.slots = new Entry[0];
    }

    public ConstMiniMap(KeyValue<K, V> ... data) {
        int modulo;
        Entry[] slots = new Entry[XMath.pow2BoundMaxed(data.length)];
        this.slots = slots;
        this.modulo = modulo = slots.length - 1;
        int size = 0;
        int i = 0;
        while (i < data.length) {
            K key = data[i].key();
            if (key != null) {
                slots[System.identityHashCode(key) & modulo] = new Entry<K, V>(key, data[i].value(), slots[System.identityHashCode(key) & modulo]);
                ++size;
            }
            ++i;
        }
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public ConstMiniMap<K, V> copy() {
        return new ConstMiniMap<K, V>(this.size, this.slots);
    }

    public MiniMap<K, V> toMiniMap() {
        return new MiniMap<K, V>(this.size, this.slots);
    }

    public V get(K key) {
        Entry<K, V> e = this.slots[System.identityHashCode(key) & this.modulo];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.link;
        }
        return null;
    }

    public boolean containsKey(K key) {
        Entry<K, V> e = this.slots[System.identityHashCode(key) & this.modulo];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.link;
        }
        return false;
    }

    public KeyValue<K, V>[] toArray() {
        Entry<K, V>[] slots = this.slots;
        int slotsLength = slots.length;
        KeyValue[] array = new KeyValue[this.size];
        int a = 0;
        int i = 0;
        while (i < slotsLength) {
            Entry<K, V> e = slots[i];
            while (e != null) {
                array[a++] = KeyValue.New(e.key, e.value);
                e = e.link;
            }
            ++i;
        }
        return array;
    }

    static final class Entry<K, V> {
        K key;
        V value;
        Entry<K, V> link;

        Entry(K key, V value, Entry<K, V> link) {
            this.key = key;
            this.value = value;
            this.link = link;
        }
    }
}

