/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.old.AbstractOldGettingSet;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XImmutableEnum;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.equality.IdentityEqualityLogic;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.ReadOnlyListIterator;

public final class ConstLinearEnum<E>
extends AbstractSimpleArrayCollection<E>
implements XImmutableEnum<E>,
IdentityEqualityLogic {
    private static final Object[] EMPTY_DATA = new Object[0];
    private final Object[] data;

    public ConstLinearEnum() {
        this.data = EMPTY_DATA;
    }

    public ConstLinearEnum(int initialCapacity) {
        this.data = new Object[initialCapacity];
    }

    public ConstLinearEnum(ConstLinearEnum<? extends E> original) throws NullPointerException {
        this.data = (Object[])original.data.clone();
    }

    public ConstLinearEnum(XGettingCollection<? extends E> elements) throws NullPointerException {
        this.data = elements.toArray();
    }

    @SafeVarargs
    public ConstLinearEnum(E ... elements) throws NullPointerException {
        this.data = (Object[])elements.clone();
    }

    public ConstLinearEnum(E[] src, int srcStart, int srcLength) {
        this.data = new Object[srcLength];
        System.arraycopy(src, srcStart, this.data, 0, srcLength);
    }

    ConstLinearEnum(Object[] internalData, int size) {
        this.data = internalData;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.data.length;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.data.length;
        return nArray;
    }

    @Override
    public Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConstLinearEnum<E> copy() {
        return new ConstLinearEnum<E>(this);
    }

    @Override
    public ConstLinearEnum<E> immure() {
        return this;
    }

    @Override
    public ConstLinearEnum<E> toReversed() {
        Object[] data = this.data;
        Object[] rData = new Object[data.length];
        int i = data.length;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new ConstLinearEnum<E>(rData, data.length);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.data.length);
        System.arraycopy(this.data, 0, array, 0, this.data.length);
        return array;
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.data.length, procedure);
        return procedure;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.data.length, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.data.length, joiner, aggregate);
        return aggregate;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardCount(this.data, 0, this.data.length, element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.data.length, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardIndexOf(this.data, 0, this.data.length, element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.data.length, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.rangedIndexOF(this.data, this.data.length, this.data.length - 1, -this.data.length, element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.data.length, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.data.length, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.data.length, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.data.length, predicate);
    }

    @Override
    public E get() {
        return (E)this.data[0];
    }

    @Override
    public E first() {
        return (E)this.data[0];
    }

    @Override
    public E last() {
        return (E)this.data[this.data.length - 1];
    }

    @Override
    public E poll() {
        return (E)(this.data.length == 0 ? null : this.data[0]);
    }

    @Override
    public E peek() {
        return (E)(this.data.length == 0 ? null : this.data[this.data.length - 1]);
    }

    @Override
    public E seek(E sample) {
        return (E)(AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, sample) ? sample : null);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.data.length, predicate, null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.data.length, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.data.length, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.data.length, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.data.length, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.data.length, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.data.length);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, element);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.data.length, elements);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == this) {
            return true;
        }
        if (samples == null || !(samples instanceof ConstLinearEnum) || XTypes.to_int(samples.size()) != this.data.length) {
            return false;
        }
        return XArrays.equals(this.data, 0, ((ConstLinearEnum)samples).data, 0, this.data.length, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.data.length) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.data.length, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.data.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.data.length, target, predicate);
    }

    public <T> T[] rngCopyTo(int startIndex, int length, T[] target, int offset) {
        return AbstractArrayStorage.rangedCopyTo(this.data, this.data.length, startIndex, length, target, offset);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.data.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.data.length, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.data.length, indices, target);
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public long maximumCapacity() {
        return this.data.length;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public long remainingCapacity() {
        return 0L;
    }

    @Override
    public ConstLinearEnum<E> view() {
        return this;
    }

    @Override
    public ConstLinearEnum<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public ConstLinearEnum<E> range(long fromIndex, long toIndex) {
        throw new NotImplementedYetError();
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.data.length);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, index);
        }
        return (E)this.data[(int)index];
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.data.length != list.size()) {
            return false;
        }
        Object[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            Object e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.data.length);
    }

    @Override
    public OldConstEnum<E> old() {
        return new OldConstEnum(this);
    }

    public static final class OldConstEnum<E>
    extends AbstractOldGettingSet<E> {
        OldConstEnum(ConstLinearEnum<E> list) {
            super(list);
        }

        @Override
        public ConstLinearEnum<E> parent() {
            return (ConstLinearEnum)super.parent();
        }
    }
}

