/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XPuttingCollection;
import org.eclipse.serializer.typing.XTypes;

public final class Collector<E>
implements XPuttingCollection<E> {
    private final XPuttingCollection<E> subject;

    public Collector(XPuttingCollection<E> collection) {
        this.subject = collection;
    }

    @Override
    public boolean nullAdd() {
        return this.subject.nullAdd();
    }

    @Override
    public boolean add(E e) {
        return this.subject.add(e);
    }

    @Override
    public Collector<E> addAll(E ... elements) {
        this.subject.addAll(elements);
        return this;
    }

    @Override
    public Collector<E> addAll(E[] elements, int offset, int length) {
        this.subject.addAll(elements, offset, length);
        return this;
    }

    @Override
    public Collector<E> addAll(XGettingCollection<? extends E> elements) {
        this.subject.addAll(elements);
        return this;
    }

    @Override
    public boolean nullPut() {
        return this.subject.nullAdd();
    }

    @Override
    public void accept(E e) {
        this.subject.add(e);
    }

    @Override
    public boolean put(E element) {
        return this.subject.add(element);
    }

    @Override
    public Collector<E> putAll(E ... elements) {
        this.subject.addAll(elements);
        return this;
    }

    @Override
    public Collector<E> putAll(E[] elements, int offset, int length) {
        this.subject.addAll(elements, offset, length);
        return this;
    }

    @Override
    public Collector<E> putAll(XGettingCollection<? extends E> elements) {
        this.subject.addAll(elements);
        return this;
    }

    @Override
    public Collector<E> ensureCapacity(long minimalCapacity) {
        this.subject.ensureCapacity(minimalCapacity);
        return this;
    }

    @Override
    public long currentCapacity() {
        return this.subject.currentCapacity();
    }

    @Override
    public long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public boolean isFull() {
        return (long)XTypes.to_int(this.subject.size()) >= this.subject.maximumCapacity();
    }

    @Override
    public long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public Collector<E> ensureFreeCapacity(long minimalFreeCapacity) {
        this.subject.ensureFreeCapacity(minimalFreeCapacity);
        return this;
    }

    @Override
    public long optimize() {
        return this.subject.optimize();
    }

    @Override
    public boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public boolean nullAllowed() {
        return this.subject.nullAllowed();
    }

    @Override
    public boolean isEmpty() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

