/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.IndexExceededException;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.SubList;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.old.AbstractBridgeXList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.GenericListIterator;

public final class ArrayCollector<E>
extends AbstractSimpleArrayCollection<E>
implements XList<E> {
    private static final Object MARKER = new Object();
    private static final Object[] DUMMY = new Object[0];
    private E[] data;
    private int size;

    private static String exceptionStringRange(long size, long startIndex, long length) {
        return "Range [" + (length < 0L ? String.valueOf(startIndex + length + 1L) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1L)) + "] not in [0;" + (size - 1L) + "]";
    }

    public ArrayCollector() {
        this.data = DUMMY;
        this.size = 0;
    }

    public ArrayCollector(ArrayCollector<? extends E> original) throws NullPointerException {
        this.data = original.data;
        this.size = original.size;
    }

    @SafeVarargs
    public ArrayCollector(E ... elements) throws NullPointerException {
        this.data = elements;
        this.size = elements.length;
    }

    public ArrayCollector(E[] elements, int size) {
        this.setArray(elements, size);
    }

    public E[] getArray() {
        return this.data == DUMMY ? null : this.data;
    }

    @Override
    public Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
            return length;
        }
        int bound = offset + length;
        if (bound < -1) {
            throw new ArrayIndexOutOfBoundsException(bound + 1);
        }
        this.ensureFreeCapacity(-length);
        E[] data = this.data;
        int size = this.size;
        int i = offset;
        while (i > bound) {
            data[size++] = elements[i];
            --i;
        }
        this.size = size;
        return -length;
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.internalCountingAddAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        int oldSize = this.size;
        elements.iterate(this);
        return this.size - oldSize;
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
            return length;
        }
        int bound = offset + length;
        if (bound < -1) {
            throw new ArrayIndexOutOfBoundsException(bound + 1);
        }
        this.ensureFreeCapacity(-length);
        E[] data = this.data;
        int size = this.size;
        int i = offset;
        while (i > bound) {
            data[size++] = elements[i];
            --i;
        }
        this.size = size;
        return -length;
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.internalCountingAddAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        int oldSize = this.size;
        elements.iterate(this);
        return this.size - oldSize;
    }

    public ArrayCollector<E> setArray(E[] array, int size) {
        if (array == null) {
            this.data = DUMMY;
            this.size = 0;
            return this;
        }
        if (size < 0 || size > array.length) {
            throw new ArrayIndexOutOfBoundsException(size);
        }
        this.data = array;
        this.size = size;
        return this;
    }

    private int internalInsertArray(int index, Object[] elements, int elementsSize) {
        if (this.data.length - this.size < elementsSize) {
            throw new ArrayCapacityException((long)elementsSize + (long)this.size);
        }
        System.arraycopy(this.data, index, this.data, index + elementsSize, this.size - index);
        System.arraycopy(elements, 0, this.data, index, elementsSize);
        this.size += elementsSize;
        return elementsSize;
    }

    private int internalInsertArray(int index, Object[] elements, int offset, int length) {
        if (length < 0) {
            if (this.data.length - this.size < -length) {
                throw new ArrayCapacityException((long)(-length) + (long)this.size);
            }
            System.arraycopy(this.data, index, this.data, index - length, this.size - index);
            XArrays.reverseArraycopy(elements, offset, elements, index, -length);
            this.size -= length;
            return -length;
        }
        if (this.data.length - this.size < length) {
            throw new ArrayCapacityException((long)length + (long)this.size);
        }
        System.arraycopy(this.data, index, this.data, index + length, this.size - index);
        System.arraycopy(elements, 0, this.data, index, length);
        this.size += length;
        return length;
    }

    private int internalInputArray(int index, Object[] elements, int elementsSize) {
        if (this.data.length - this.size < elementsSize) {
            throw new ArrayCapacityException((long)elementsSize + (long)this.size);
        }
        System.arraycopy(this.data, index, this.data, index + elementsSize, this.size - index);
        System.arraycopy(elements, 0, this.data, index, elementsSize);
        this.size += elementsSize;
        return elementsSize;
    }

    private int internalInputArray(int index, Object[] elements, int offset, int length) {
        if (length < 0) {
            if (this.data.length - this.size < -length) {
                throw new ArrayCapacityException((long)(-length) + (long)this.size);
            }
            System.arraycopy(this.data, index, this.data, index - length, this.size - index);
            XArrays.reverseArraycopy(elements, offset, elements, index, -length);
            this.size -= length;
            return -length;
        }
        if (this.data.length - this.size < length) {
            throw new ArrayCapacityException((long)length + (long)this.size);
        }
        System.arraycopy(this.data, index, this.data, index + length, this.size - index);
        System.arraycopy(elements, 0, this.data, index, length);
        this.size += length;
        return length;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.size;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.size;
        return nArray;
    }

    @Override
    public ArrayCollector<E> copy() {
        return new ArrayCollector<E>(this);
    }

    @Override
    public XImmutableList<E> immure() {
        return ConstList.New(this);
    }

    @Override
    public ArrayCollector<E> toReversed() {
        E[] rData = X.ArrayOfSameType(this.data, this.data.length);
        E[] data = this.data;
        int i = this.size;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new ArrayCollector<E>(rData, this.size);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.size);
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.size, joiner, aggregate);
        return aggregate;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardCount(this.data, 0, this.size, element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.size, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardIndexOf(this.data, 0, this.size, element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.size, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.rangedIndexOF(this.data, this.size, this.size - 1, -this.size, element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.size, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.size, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.size, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.size, predicate);
    }

    @Override
    public E get() {
        return this.data[0];
    }

    @Override
    public E first() {
        return this.data[0];
    }

    @Override
    public E last() {
        return this.data[this.size - 1];
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.data[0];
    }

    @Override
    public E peek() {
        return this.size == 0 ? null : (E)this.data[this.size - 1];
    }

    @Override
    public E seek(E sample) {
        return (E)(AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, sample) ? sample : null);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.size, predicate, null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.size, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.size, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.size, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.size);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.size, elements);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof ArrayCollector) || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((ArrayCollector)samples).data, 0, this.size, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.size, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target, predicate);
    }

    public <T> T[] rngCopyTo(int startIndex, int length, T[] target, int offset) {
        return AbstractArrayStorage.rangedCopyTo(this.data, this.size, startIndex, length, target, offset);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.size, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.size, indices, target);
    }

    @Override
    public ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public ArrayCollector<E> shiftTo(long sourceIndex, long targetIndex) {
        if (sourceIndex >= (long)this.size) {
            throw new IndexExceededException(this.size, sourceIndex);
        }
        if (targetIndex >= (long)this.size) {
            throw new IndexExceededException(this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.size, sourceIndex);
            }
            return this;
        }
        E shiftling = this.data[(int)sourceIndex];
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)sourceIndex + 1, this.data, (int)sourceIndex, (int)targetIndex - (int)sourceIndex);
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)targetIndex + 1, (int)sourceIndex - (int)targetIndex);
        }
        this.data[(int)targetIndex] = shiftling;
        return this;
    }

    @Override
    public ArrayCollector<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        if (sourceIndex + length >= (long)this.size) {
            throw new IndexExceededException(this.size, sourceIndex);
        }
        if (targetIndex + length >= (long)this.size) {
            throw new IndexExceededException(this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.size, sourceIndex);
            }
            return this;
        }
        E[] shiftlings = ArrayCollector.newArray((int)length);
        System.arraycopy(this.data, (int)sourceIndex, shiftlings, 0, (int)length);
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)(sourceIndex + length), this.data, (int)sourceIndex, (int)(targetIndex - sourceIndex));
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)(targetIndex + length), (int)(sourceIndex - targetIndex));
        }
        System.arraycopy(shiftlings, 0, this.data, (int)targetIndex, (int)length);
        return this;
    }

    @Override
    public ArrayCollector<E> shiftBy(long sourceIndex, long distance) {
        return this.shiftTo(sourceIndex, sourceIndex + distance);
    }

    @Override
    public ArrayCollector<E> shiftBy(long sourceIndex, long distance, long length) {
        return this.shiftTo(sourceIndex, sourceIndex + distance, length);
    }

    @Override
    public ArrayCollector<E> swap(long indexA, long indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexA);
        }
        if (indexB >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexB);
        }
        E t = this.data[(int)indexA];
        this.data[(int)indexA] = this.data[(int)indexB];
        this.data[(int)indexB] = t;
        return this;
    }

    @Override
    public ArrayCollector<E> swap(long indexA, long indexB, long length) {
        AbstractArrayStorage.swap(this.data, this.size, X.checkArrayRange(indexA), X.checkArrayRange(indexB), X.checkArrayRange(length));
        return this;
    }

    @Override
    public ArrayCollector<E> reverse() {
        AbstractArrayStorage.reverse(this.data, this.size);
        return this;
    }

    @Override
    public void setFirst(E element) {
        this.data[0] = element;
    }

    @Override
    public void setLast(E element) {
        this.data[this.size - 1] = element;
    }

    @Override
    @SafeVarargs
    public final ArrayCollector<E> setAll(long offset, E ... elements) {
        if (offset < 0L || offset + (long)elements.length > (long)this.size) {
            throw new IndexOutOfBoundsException(ArrayCollector.exceptionStringRange(this.size, offset, offset + (long)elements.length - 1L));
        }
        System.arraycopy(elements, 0, this.data, X.checkArrayRange(offset), elements.length);
        return this;
    }

    @Override
    public ArrayCollector<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), src, srcIndex, srcLength);
        return this;
    }

    @Override
    public ArrayCollector<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public ArrayCollector<E> fill(long offset, long length, E element) {
        AbstractArrayStorage.fill(this.data, this.size, X.checkArrayRange(offset), X.checkArrayRange(length), element);
        return this;
    }

    @Override
    public ArrayCollector<E> sort(Comparator<? super E> comparator) {
        XSort.mergesort(this.data, 0, this.size, comparator);
        return this;
    }

    @Override
    public boolean replaceOne(E element, E replacement) {
        return AbstractArrayStorage.replaceOne(this.data, this.size, element, replacement);
    }

    @Override
    public boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substituteOne(this.data, this.size, predicate, substitute);
    }

    @Override
    public long replace(E element, E replacement) {
        return AbstractArrayStorage.replace(this.data, this.size, element, replacement);
    }

    @Override
    public long replace(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, substitute);
    }

    @Override
    public long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return AbstractArrayStorage.replaceAll(this.data, this.size, elements, replacement, MARKER);
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, mapper);
    }

    @Override
    public long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, mapper);
    }

    @Override
    public long currentCapacity() {
        return this.data.length;
    }

    @Override
    public long maximumCapacity() {
        return this.data.length;
    }

    @Override
    public boolean isFull() {
        return this.size >= this.data.length;
    }

    @Override
    public long remainingCapacity() {
        return this.data.length - this.size;
    }

    @Override
    public long optimize() {
        return this.data.length;
    }

    @Override
    public ArrayCollector<E> ensureFreeCapacity(long requiredFreeCapacity) {
        if ((long)(this.data.length - this.size) >= requiredFreeCapacity) {
            return this;
        }
        throw new IndexBoundsException((long)this.data.length);
    }

    @Override
    public ArrayCollector<E> ensureCapacity(long minCapacity) {
        if (minCapacity > (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length);
        }
        return this;
    }

    @Override
    public void accept(E element) {
        this.add(element);
    }

    @Override
    public boolean add(E element) {
        if (this.size >= this.data.length) {
            throw new IndexOutOfBoundsException("Reached maximum capacity");
        }
        this.data[this.size++] = element;
        return true;
    }

    @Override
    @SafeVarargs
    public final ArrayCollector<E> addAll(E ... elements) {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return this;
    }

    @Override
    public ArrayCollector<E> addAll(E[] elements, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (length > 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
        } else {
            int bound = offset + length;
            if (bound < -1) {
                throw new ArrayIndexOutOfBoundsException(bound + 1);
            }
            this.ensureFreeCapacity(-length);
            E[] data = this.data;
            int size = this.size;
            int i = offset;
            while (i > bound) {
                data[size++] = elements[i];
                --i;
            }
            this.size = size;
        }
        return this;
    }

    @Override
    public ArrayCollector<E> addAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public boolean nullAdd() {
        if (this.size >= this.data.length) {
            throw new IndexBoundsException((long)this.data.length);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean put(E element) {
        return this.add(element);
    }

    @Override
    @SafeVarargs
    public final ArrayCollector<E> putAll(E ... elements) {
        return this.addAll((Object[])elements);
    }

    @Override
    public ArrayCollector<E> putAll(E[] elements, int offset, int length) {
        return this.addAll((Object[])elements, offset, length);
    }

    @Override
    public ArrayCollector<E> putAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public boolean nullPut() {
        return this.nullAdd();
    }

    @Override
    public boolean prepend(E element) {
        if (this.size >= this.data.length) {
            throw new IndexBoundsException((long)this.data.length);
        }
        System.arraycopy(this.data, 0, this.data, 1, this.size);
        this.data[0] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final ArrayCollector<E> prependAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public ArrayCollector<E> prependAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public ArrayCollector<E> prependAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean preput(E element) {
        if (this.size >= this.data.length) {
            throw new IndexBoundsException((long)this.data.length);
        }
        System.arraycopy(this.data, 0, this.data, 1, this.size);
        this.data[0] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final ArrayCollector<E> preputAll(E ... elements) {
        if (this.data.length - elements.length < this.size) {
            throw new IndexBoundsException((long)this.data.length);
        }
        System.arraycopy(this.data, 0, this.data, elements.length, this.size);
        System.arraycopy(elements, 0, this.data, 0, elements.length);
        this.size += elements.length;
        return this;
    }

    @Override
    public ArrayCollector<E> preputAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public ArrayCollector<E> preputAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean insert(long index, E element) {
        if (this.size >= this.data.length) {
            throw new IndexBoundsException((long)this.data.length);
        }
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        System.arraycopy(this.data, (int)index, this.data, (int)index + 1, this.size - (int)index);
        this.data[(int)index] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) throws IndexOutOfBoundsException {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInsertArray((int)index, elements, elements.length);
    }

    @Override
    public long insertAll(long index, E[] elements, int offset, int length) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInsertArray((int)index, elements, offset, length);
    }

    @Override
    public long insertAll(long index, XGettingCollection<? extends E> elements) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        Object[] elementsToAdd = elements instanceof AbstractSimpleArrayCollection ? ((AbstractSimpleArrayCollection)((Object)elements)).internalGetStorageArray() : elements.toArray();
        return this.internalInsertArray((int)index, elementsToAdd, elementsToAdd.length);
    }

    @Override
    public boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean input(long index, E element) {
        if (this.size >= this.data.length) {
            throw new IndexBoundsException((long)this.data.length);
        }
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        System.arraycopy(this.data, (int)index, this.data, (int)index + 1, this.size - (int)index);
        this.data[(int)index] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) throws IndexOutOfBoundsException {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, elements.length);
    }

    @Override
    public long inputAll(long index, E[] elements, int offset, int length) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, offset, length);
    }

    @Override
    public long inputAll(long index, XGettingCollection<? extends E> elements) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        Object[] elementsToAdd = elements instanceof AbstractSimpleArrayCollection ? ((AbstractSimpleArrayCollection)((Object)elements)).internalGetStorageArray() : elements.toArray();
        return this.internalInputArray((int)index, elementsToAdd, elementsToAdd.length);
    }

    @Override
    public boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public void truncate() {
        this.data = DUMMY;
        this.size = 0;
    }

    @Override
    public long consolidate() {
        return 0L;
    }

    @Override
    public E retrieve(E element) {
        Object removedElement = AbstractArrayStorage.retrieve(this.data, this.size, element, MARKER);
        if (removedElement != MARKER) {
            --this.size;
            return (E)removedElement;
        }
        return null;
    }

    @Override
    public E retrieveBy(Predicate<? super E> predicate) {
        Object e = AbstractArrayStorage.retrieve(this.data, this.size, predicate, MARKER);
        if (e != MARKER) {
            --this.size;
            return (E)e;
        }
        return null;
    }

    @Override
    public boolean removeOne(E element) {
        if (AbstractArrayStorage.removeOne(this.data, this.size, element)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public long remove(E element) {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, element);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long nullRemove() {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, null);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long removeBy(Predicate<? super E> predicate) {
        int removeCount = AbstractArrayStorage.reduce(this.data, this.size, predicate, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long retainAll(XGettingCollection<? extends E> elements) {
        int removeCount = AbstractArrayStorage.retainAll(this.data, this.size, elements, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        this.size -= AbstractArrayStorage.process(this.data, this.size, procedure, MARKER);
        return procedure;
    }

    @Override
    public <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        this.size -= AbstractArrayStorage.moveTo(this.data, this.size, target, predicate, MARKER);
        return target;
    }

    @Override
    public <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        this.size -= AbstractArrayStorage.moveSelection(this.data, this.size, indices, target, MARKER);
        return target;
    }

    @Override
    public long removeAll(XGettingCollection<? extends E> elements) {
        int removed = XArrays.removeAllFromArray(elements, this.data, 0, this.size);
        this.size -= removed;
        return removed;
    }

    @Override
    public long removeDuplicates(Equalator<? super E> equalator) {
        int removeCount = AbstractArrayStorage.removeDuplicates(this.data, this.size, equalator, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long removeDuplicates() {
        int removeCount = AbstractArrayStorage.removeDuplicates(this.data, this.size, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public E fetch() {
        E element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = null;
        return element;
    }

    @Override
    public E pop() {
        E element = this.data[this.size - 1];
        this.data[--this.size] = null;
        return element;
    }

    @Override
    public E pinch() {
        if (this.size == 0) {
            return null;
        }
        E element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = null;
        return element;
    }

    @Override
    public E pick() {
        if (this.size == 0) {
            return null;
        }
        E element = this.data[--this.size];
        this.data[this.size] = null;
        return element;
    }

    @Override
    public long removeSelection(long[] indices) {
        int removeCount = AbstractArrayStorage.removeSelection(this.data, this.size, indices, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public ArrayCollector<E> removeRange(long startIndex, long length) {
        this.size -= AbstractArrayStorage.removeRange(this.data, this.size, X.checkArrayRange(startIndex), X.checkArrayRange(length));
        return this;
    }

    @Override
    public ArrayCollector<E> retainRange(long startIndex, long length) {
        AbstractArrayStorage.retainRange(this.data, this.size, X.checkArrayRange(startIndex), X.checkArrayRange(length));
        this.size = (int)length;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new GenericListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new GenericListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        ArrayCollector.validateIndex(this.size, index);
        return new GenericListIterator(this, (int)index);
    }

    @Override
    public boolean set(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        this.data[(int)index] = element;
        return false;
    }

    @Override
    public E setGet(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E old = this.data[(int)index];
        this.data[(int)index] = element;
        return old;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SubList<E> range(long fromIndex, long toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.data[(int)index];
    }

    @Override
    public void clear() {
        E[] data = this.data;
        int i = this.size;
        while (i-- > 0) {
            data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public E removeAt(long index) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E oldValue = this.data[(int)index];
        int moveCount = this.size - 1 - (int)index;
        if (moveCount > 0) {
            System.arraycopy(this.data, (int)index + 1, this.data, (int)index, moveCount);
        }
        this.data[--this.size] = null;
        return oldValue;
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.size != list.size()) {
            return false;
        }
        E[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            E e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.size);
    }

    @Override
    public OldArrayCollector<E> old() {
        return new OldArrayCollector(this);
    }

    public static final class OldArrayCollector<E>
    extends AbstractBridgeXList<E> {
        OldArrayCollector(ArrayCollector<E> list) {
            super(list);
        }

        @Override
        public ArrayCollector<E> parent() {
            return (ArrayCollector)super.parent();
        }
    }
}

