/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import org.eclipse.serializer.collections.interfaces.ExtendedCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.exceptions.IndexBoundsException;

public abstract class AbstractExtendedCollection<E>
implements ExtendedCollection<E> {
    public static void validateIndex(long bound, long index) throws IndexBoundsException {
        if (index < 0L) {
            throw new IndexBoundsException(bound, index);
        }
        if (index >= bound) {
            throw new IndexBoundsException(bound, index);
        }
    }

    public static void ensureFreeArrayCapacity(int size) {
        if (size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException((long)size);
        }
    }

    protected abstract int internalCountingAddAll(E[] var1) throws UnsupportedOperationException;

    protected abstract int internalCountingAddAll(E[] var1, int var2, int var3) throws UnsupportedOperationException;

    protected abstract int internalCountingAddAll(XGettingCollection<? extends E> var1) throws UnsupportedOperationException;

    protected abstract int internalCountingPutAll(E[] var1) throws UnsupportedOperationException;

    protected abstract int internalCountingPutAll(E[] var1, int var2, int var3) throws UnsupportedOperationException;

    protected abstract int internalCountingPutAll(XGettingCollection<? extends E> var1) throws UnsupportedOperationException;
}

