/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.serializer.collections.AbstractChainEntry;
import org.eclipse.serializer.collections.LimitList;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.interfaces.HashCollection;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;

public abstract class AbstractChainEntryLinked<E, K, V, EN extends AbstractChainEntryLinked<E, K, V, EN>>
extends AbstractChainEntry<E, K, V, EN> {
    EN link;

    public static <E, K, V, C extends HashCollection<K>, EN extends AbstractChainEntryLinked<E, K, V, EN>> HashCollection.Analysis<C> analyzeSlots(C hashCollection, EN[] slots) {
        HashMap<Integer, int[]> distribution = new HashMap<Integer, int[]>();
        int emptySlotCount = 0;
        EN[] ENArray = slots;
        int n = slots.length;
        int n2 = 0;
        while (n2 < n) {
            EN entry = ENArray[n2];
            if (entry == null) {
                ++emptySlotCount;
            } else {
                int chainLength = 1;
                entry = ((AbstractChainEntryLinked)entry).link;
                while (entry != null) {
                    ++chainLength;
                    entry = ((AbstractChainEntryLinked)entry).link;
                }
                int[] count = (int[])distribution.get(chainLength);
                if (count == null) {
                    distribution.put(chainLength, X.ints(1));
                } else {
                    count[0] = count[0] + 1;
                }
            }
            ++n2;
        }
        distribution.put(0, X.ints(emptySlotCount));
        int distRange = distribution.size();
        LimitList<KeyValue<Integer, Integer>> result = new LimitList<KeyValue<Integer, Integer>>(distRange);
        int shortestEntryChainLength = Integer.MAX_VALUE;
        int longestEntryChainLength = 0;
        for (Map.Entry e : distribution.entrySet()) {
            int chainLength = (Integer)e.getKey();
            if (chainLength > 0) {
                if (chainLength < shortestEntryChainLength) {
                    shortestEntryChainLength = chainLength;
                } else if (chainLength > longestEntryChainLength) {
                    longestEntryChainLength = chainLength;
                }
            }
            result.add(X.KeyValue((Integer)e.getKey(), ((int[])e.getValue())[0]));
        }
        XSort.valueSort((KeyValue[])result.internalGetStorageArray(), (kv1, kv2) -> (Integer)kv1.key() - (Integer)kv2.key());
        return new HashCollection.Analysis<C>(hashCollection, XTypes.to_int(hashCollection.size()), hashCollection.hashDensity(), slots.length, shortestEntryChainLength, longestEntryChainLength, distRange, (XGettingList<KeyValue<Integer, Integer>>)((Object)result.immure()));
    }

    protected AbstractChainEntryLinked(EN link) {
        this.link = link;
    }
}

