/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.XArrays;

public interface _charArrayRange {
    public char[] array();

    public int start();

    public int bound();

    public static Default New(String value) {
        return _charArrayRange.New(XChars.readChars(value));
    }

    public static Default New(char[] array) {
        return new Default(array, 0, array.length);
    }

    public static Default New(char[] array, int offset) {
        return new Default(array, XArrays.validateArrayIndex(array.length, offset), array.length);
    }

    public static Default New(char[] array, int offset, int bound) {
        return new Default(array, XArrays.validateArrayIndex(array.length, offset), XArrays.validateArrayIndex(array.length, bound - 1) + 1);
    }

    public static final class Default
    implements _charArrayRange {
        final char[] array;
        final int start;
        final int bound;

        Default(char[] array, int start, int bound) {
            this.array = array;
            this.start = start;
            this.bound = bound;
        }

        @Override
        public final char[] array() {
            return this.array;
        }

        @Override
        public final int start() {
            return this.start;
        }

        @Override
        public final int bound() {
            return this.bound;
        }
    }

    public static final class Mutable
    implements _charArrayRange {
        final char[] array;
        int start;
        int bound;

        public static final Mutable New(char[] array) {
            return new Mutable(array, 0, array.length);
        }

        public static final Mutable New(char[] array, int offset) {
            return new Mutable(array, XArrays.validateArrayIndex(array.length, offset), array.length);
        }

        public static final Mutable New(char[] array, int offset, int bound) {
            return new Mutable(array, XArrays.validateArrayIndex(array.length, offset), XArrays.validateArrayIndex(array.length, bound));
        }

        private Mutable(char[] array, int start, int bound) {
            this.array = array;
            this.start = start;
            this.bound = bound;
        }

        protected final void internalSetStart(int start) {
            this.start = XArrays.validateArrayIndex(this.array.length, start);
        }

        protected final void internalSetBound(int bound) {
            this.bound = XArrays.validateArrayIndex(this.array.length, bound);
        }

        public Mutable setStart(int start) {
            this.internalSetStart(start);
            return this;
        }

        public Mutable setBound(int bound) {
            this.internalSetBound(bound);
            return this;
        }

        public Mutable set(int start, int bound) {
            this.internalSetStart(start);
            this.internalSetBound(bound);
            return this;
        }

        @Override
        public final char[] array() {
            return this.array;
        }

        @Override
        public final int start() {
            return this.start;
        }

        @Override
        public final int bound() {
            return this.bound;
        }
    }
}

