/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import java.util.function.Consumer;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.exceptions.ParsingException;
import org.eclipse.serializer.exceptions.ParsingExceptionUnexpectedCharacterInArray;

public final class XParsing {
    public static int skipWhiteSpaces(char[] input, int iStart, int iBound) {
        int i = iStart;
        while (i < iBound && input[i] <= ' ') {
            ++i;
        }
        return i;
    }

    public static int skipWhiteSpacesReversed(char[] input, int iStart, int iBound) {
        int i = iBound - 1;
        while (i >= iStart && input[i] <= ' ') {
            --i;
        }
        return i;
    }

    public static int skipSimpleQuote(char[] input, int iStart, int iBound) {
        return XParsing.skipToSimpleTerminator(input, iStart + 1, iBound, input[iStart]);
    }

    public static int skipToSimpleTerminator(char[] input, int iStart, int iBound, char terminator) {
        int i = iStart;
        while (i < iBound) {
            if (input[i++] != terminator) continue;
            return i;
        }
        return iStart;
    }

    public static String parseSimpleQuote(char[] input, int iStart, int iBound) {
        int iQuoteEnd = XParsing.skipSimpleQuote(input, iStart, iBound);
        if (iQuoteEnd == iStart) {
            throw new IllegalArgumentException("No simple quote character found at index " + iStart + ".");
        }
        return new String(input, iStart + 1, iQuoteEnd - iStart - 2);
    }

    public static int parseSimpleQuote(char[] input, int iStart, int iBound, Consumer<? super String> receiver) {
        int iQuoteEnd = XParsing.skipSimpleQuote(input, iStart, iBound);
        if (iQuoteEnd == iStart) {
            throw new IllegalArgumentException("No simple quote character found at index " + iStart + ".");
        }
        receiver.accept(new String(input, iStart + 1, iQuoteEnd - iStart - 2));
        return iQuoteEnd;
    }

    public static int parseToSimpleTerminator(char[] input, int iStart, int iBound, char terminator, Consumer<? super String> receiver) {
        int iEnd = XParsing.skipToSimpleTerminator(input, iStart, iBound, terminator);
        if (iEnd == iStart) {
            throw new ParsingException("No terminator found in index range [" + iStart + "," + iBound + "]");
        }
        receiver.accept(new String(input, iStart, iEnd - iStart - 1));
        return iEnd;
    }

    public static int checkStartsWith(char[] input, int iStart, int iBound, String subject) {
        return XParsing.checkStartsWith(input, iStart, iBound, subject, null);
    }

    public static int checkStartsWith(char[] input, int iStart, int iBound, String subject, String contextHint) {
        if (XParsing.startsWith(input, iStart, iBound, subject)) {
            return iStart + subject.length();
        }
        throw new ParsingException("String \"" + subject + "\" not found at index " + iStart + (contextHint == null ? "." : "(" + contextHint + ")."));
    }

    public static boolean startsWith(char[] input, int iStart, int iBound, String subject) {
        return XParsing.startsWith(input, iStart, iBound, XChars.readChars(subject));
    }

    public static boolean startsWith(char[] input, int iStart, int iBound, char[] subject) {
        if (iBound - iStart < subject.length) {
            return false;
        }
        int i = 0;
        while (i < subject.length) {
            if (subject[i] != input[iStart + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int checkCharacter(char[] input, int i, char c) throws ParsingExceptionUnexpectedCharacterInArray {
        return XParsing.checkCharacter(input, i, c, null);
    }

    public static int checkCharacter(char[] input, int i, char c, String contextHint) throws ParsingExceptionUnexpectedCharacterInArray {
        if (input[i] != c) {
            throw new ParsingExceptionUnexpectedCharacterInArray(input, i, c, input[i], contextHint);
        }
        return i + 1;
    }

    public static void checkIncompleteInput(int i, int iBound) {
        XParsing.checkIncompleteInput(i, iBound, null);
    }

    public static void checkIncompleteInput(int i, int iBound, String contextHint) {
        if (i < iBound) {
            return;
        }
        throw new ParsingException("Incomplete input: reached end of characters at index " + i + (contextHint == null ? "." : " (" + contextHint + ")."));
    }

    private XParsing() {
        throw new UnsupportedOperationException();
    }
}

