/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import org.eclipse.serializer.chars.EscapeHandler;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.chars._charArrayRange;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.types.XReference;
import org.eclipse.serializer.exceptions.XCsvException;
import org.eclipse.serializer.functional._charRangeProcedure;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Stateless;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.xcsv.XCSV;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;
import org.eclipse.serializer.util.xcsv.XCsvDataType;
import org.eclipse.serializer.util.xcsv.XCsvParser;
import org.eclipse.serializer.util.xcsv.XCsvRecordParserCharArray;
import org.eclipse.serializer.util.xcsv.XCsvRowCollector;
import org.eclipse.serializer.util.xcsv.XCsvSegmentsParser;

public final class XCsvParserCharArray
implements XCsvParser<_charArrayRange>,
Stateless {
    private static final int META_INDEX_LITERAL_DELIMITER = 0;
    private static final int META_INDEX_VALUE_SEPARATOR = 1;
    private static final int META_INDEX_LINE_SEPARATOR = 2;
    private static final int META_INDEX_SEGMENT_STARTER = 3;
    private static final int META_INDEX_SEGMENT_TERMINATOR = 4;
    private static final int META_INDEX_COLUMN_DEFINITION_STARTER = 5;
    private static final int META_INDEX_COLUMN_DEFINITION_TERMINATOR = 6;
    private static final int META_INDEX_COMMENT_SIGNAL = 7;
    private static final int META_INDEX_SIMPLE_COMMENT_STARTER = 8;
    private static final int META_INDEX_FULL_COMMENT_STARTER = 9;
    private static final int META_INDEX_FULL_COMMENT_TERMINATOR = 10;
    private static final int META_COUNT = 11;
    private static final int META_INDEX_COMPLETE_BASIC = 2;
    private static final int META_INDEX_COMPLETE_ENHANCED = 6;
    private static final int META_INDEX_COMPLETE_FULL = 10;

    private static final void noOp(char[] data, int offset, int length) {
    }

    /*
     * Unable to fully structure code
     */
    private static int skipLines(char[] input, int iStart, int iBound, char lineSeparator, int lineCount) {
        i = iStart;
        c = 0;
        ** GOTO lbl10
        {
            if (++i == iBound) {
                return i;
            }
            do {
                if (input[i] != lineSeparator) continue block0;
                ++i;
                ++c;
lbl10:
                // 2 sources

            } while (c < lineCount);
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    private static int skipLinesBackwards(char[] input, int iLowBound, int iHighBound, char lineSeparator, int lineCount) {
        i = iHighBound;
        c = 0;
        ** GOTO lbl10
        {
            if (i == iLowBound) {
                return i;
            }
            do {
                if (input[--i] != lineSeparator) continue block0;
                --i;
                ++c;
lbl10:
                // 2 sources

            } while (c < lineCount);
        }
        return i;
    }

    private static int skipValueSeparator(char[] input, int iStart, int iBound, char valueSeparator, char lineSeparator, char terminator) {
        int i = iStart;
        while (i < iBound) {
            if (input[i] == valueSeparator) {
                return i + 1;
            }
            if (XChars.isNonWhitespace(input[i]) || input[i] == lineSeparator || input[i] == terminator) {
                return i;
            }
            ++i;
        }
        return iBound;
    }

    private static int parseLiteralSimple(char[] input, int iStart, int iBound, char lineSeparator, char valueSeparator, char terminator, _charRangeProcedure valueCollector) {
        int i = iStart;
        while (i < iBound && input[i] != valueSeparator && input[i] != lineSeparator && input[i] != terminator) {
            ++i;
        }
        int lastLiteralIndex = i - 1;
        while (XChars.isWhitespace(input[lastLiteralIndex])) {
            --lastLiteralIndex;
        }
        if (valueCollector != null) {
            valueCollector.accept(input, iStart, lastLiteralIndex + 1 - iStart);
        }
        return XCsvParserCharArray.skipValueSeparator(input, i, iBound, valueSeparator, lineSeparator, terminator);
    }

    private static int parseLiteralDelimited(char[] input, int iStart, int iBound, char delimiter, char escaper, VarString literalBuilder, EscapeHandler escapeHandler, _charRangeProcedure valueCollector) {
        int i = iStart;
        literalBuilder.clear();
        while (++i < iBound) {
            if (input[i] == escaper) {
                if (i + 1 == iBound) break;
                escapeHandler.handleEscapedChar(input[++i], literalBuilder);
                continue;
            }
            if (input[i] == delimiter) {
                ++i;
                break;
            }
            literalBuilder.add(input[i]);
        }
        if (valueCollector != null) {
            valueCollector.accept(literalBuilder.data, 0, literalBuilder.size);
        }
        return i;
    }

    static final int parseRecord(char[] input, int iStart, int iBound, char valueSeparator, char delimiter, char escaper, char lineSeparator, char terminator, XCsvConfiguration config, VarString literalBuilder, EscapeHandler escapeHandler, _charRangeProcedure valueCollector) {
        int i = iStart;
        while (true) {
            if (i == iBound || input[i] == lineSeparator || input[i] == terminator) {
                if (XCsvRecordParserCharArray.Static.isTrailingSeparator(input, iStart, i, valueSeparator)) {
                    valueCollector.accept(null, 0, 0);
                }
                return i;
            }
            if (input[i] == valueSeparator) {
                valueCollector.accept(null, 0, 0);
                ++i;
                continue;
            }
            if (XChars.isWhitespace(input[i])) {
                ++i;
                continue;
            }
            if (input[i] == delimiter) {
                i = XCsvParserCharArray.parseLiteralDelimited(input, i, iBound, delimiter, escaper, literalBuilder, escapeHandler, valueCollector);
                i = XCsvParserCharArray.skipValueSeparator(input, i, iBound, valueSeparator, lineSeparator, terminator);
                continue;
            }
            i = XCsvParserCharArray.parseLiteralSimple(input, i, iBound, lineSeparator, valueSeparator, terminator, valueCollector);
        }
    }

    private static int parseSimpleColumnLine(char[] input, int iStart, int iBound, char lineSeparator, char terminator, XCsvConfiguration config, VarString literalBuilder, ColumnHeaderCollector columnNameCollector) {
        return XCsvParserCharArray.parseRecord(input, iStart, iBound, config.valueSeparator(), config.literalDelimiter(), config.escaper(), lineSeparator, terminator, config, literalBuilder, config.escapeHandler(), columnNameCollector);
    }

    private static int parseMetaCharacter(char[] input, int iStart, int iBound, char metaSeparator, char metaEscaper, String[] metaCharacters, int currentMetaIndex, EscapeHandler escapeHandler) {
        int i = iStart;
        if (i == iBound || input[i] != metaSeparator || ++i == iBound) {
            return iStart;
        }
        if (input[i] == metaEscaper) {
            if (++i == iBound || input[i] == metaSeparator || input[i] == metaEscaper) {
                return iStart;
            }
            metaCharacters[currentMetaIndex] = String.valueOf(escapeHandler.unescape(input[i]));
        } else {
            metaCharacters[currentMetaIndex] = String.valueOf(input[i]);
        }
        return ++i;
    }

    private static int parseFullCommentTerminator(char[] input, int iStart, int iBound, char metaSeparator, String[] metaCharacters, int currentMetaIndex) {
        int i = iStart;
        if (i == iBound || input[i] != metaSeparator) {
            return iStart;
        }
        do {
            if (++i != iBound) continue;
            return iStart;
        } while (!XChars.isWhitespace(input[i]));
        metaCharacters[currentMetaIndex] = String.valueOf(input, iStart + 1, i - iStart - 1);
        return i;
    }

    private static void updateConfig(XReference<XCsvConfiguration> refConfig, int symbolIndex, String[] symbols) {
        XCsvConfiguration effectiveConfig = XCsvParserCharArray.ensureConfiguration((XCsvConfiguration)refConfig.get());
        XCsvConfiguration.Builder builder = XCsvConfiguration.Builder().copyFrom(effectiveConfig);
        if (symbolIndex >= 10) {
            builder.setCommentSignal(symbols[7].charAt(0)).setCommentSimpleStarter(symbols[8].charAt(0)).setCommentFullStarter(symbols[9].charAt(0)).setCommentFullTerminator(symbols[10]);
        }
        if (symbolIndex >= 6) {
            builder.setSegmentStarter(symbols[3].charAt(0)).setSegmentTerminator(symbols[4].charAt(0)).setHeaderStarter(symbols[5].charAt(0)).setHeaderTerminator(symbols[6].charAt(0));
        }
        builder.setLiteralDelimiter(symbols[0].charAt(0)).setValueSeparator(symbols[1].charAt(0)).setLineSeparator(symbols[2].charAt(0));
        refConfig.set(builder.buildConfiguration());
    }

    private static boolean isValidSymbols(String[] metaChars) {
        int bound;
        int i;
        block5: {
            i = 0;
            while (i <= 6) {
                if (metaChars[i] == null) {
                    bound = i;
                    break block5;
                }
                ++i;
            }
            bound = 7;
        }
        i = 0;
        while (i < bound) {
            String current = metaChars[i];
            int j = i + 1;
            while (j < bound) {
                if (current.equals(metaChars[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static EscapeHandler ensureEscapeHandler(XCsvConfiguration xcsvConfiguration) {
        return XCsvParserCharArray.ensureConfiguration(xcsvConfiguration).escapeHandler();
    }

    private static XCsvConfiguration ensureConfiguration(XCsvConfiguration xcsvConfiguration) {
        return X.coalesce(xcsvConfiguration, XCSV.configurationDefault());
    }

    private static XCsvDataType ensureDataType(XCsvDataType dataType) {
        return X.coalesce(dataType, XCsvDataType.XCSV);
    }

    private static int checkMetaCharacters(char[] input, int iStart, int iBound, XReference<XCsvConfiguration> refConfig) {
        if (iStart == iBound) {
            return iStart;
        }
        int i = iStart;
        char assumedMetaSeparator = input[i];
        if (++i == iBound) {
            return i;
        }
        if (!XCSV.isValidValueSeparator(assumedMetaSeparator)) {
            return iStart;
        }
        char assumedEscaper = input[i];
        if (assumedMetaSeparator == assumedEscaper) {
            return iStart;
        }
        int j = ++i;
        int c = 0;
        EscapeHandler escapeHandler = XCsvParserCharArray.ensureEscapeHandler((XCsvConfiguration)refConfig.get());
        String[] metaChars = new String[11];
        while (c < 10) {
            if ((i = XCsvParserCharArray.parseMetaCharacter(input, i, iBound, assumedMetaSeparator, assumedEscaper, metaChars, c, escapeHandler)) == j) break;
            j = i;
            ++c;
        }
        if (c == 10) {
            i = XCsvParserCharArray.parseFullCommentTerminator(input, i, iBound, assumedMetaSeparator, metaChars, c);
        }
        if (c < 2) {
            return iStart;
        }
        if (!XCsvParserCharArray.isValidSymbols(metaChars)) {
            throw new RuntimeException("Inconsistent meta characters: " + String.valueOf(input, iStart, i - iStart));
        }
        XCsvParserCharArray.updateConfig(refConfig, c, metaChars);
        return i;
    }

    static final boolean isSegmentStart(char[] input, int iStart, int iBound, VarString literalBuilder, XCsvConfiguration config) {
        return XCsvParserCharArray.parseSegmentStart(input, iStart, iBound, literalBuilder, config) != iStart;
    }

    static final int parseSegmentStart(char[] input, int iStart, int iBound, VarString literalBuilder, XCsvConfiguration config) {
        if (iStart >= iBound) {
            return iStart;
        }
        if (input[iStart] == config.segmentStarter()) {
            return XCsvRecordParserCharArray.Static.skipSkippable(input, iStart + 1, iBound, config.commentSignal(), config);
        }
        int i = iStart;
        if (input[i] == config.literalDelimiter()) {
            i = XCsvParserCharArray.parseLiteralDelimited(input, i, iBound, config.literalDelimiter(), config.escaper(), literalBuilder, config.escapeHandler(), XCsvParserCharArray::noOp);
            if (input[i = XCsvRecordParserCharArray.Static.skipSkippable(input, i, iBound, config.commentSignal(), config)] != config.segmentStarter()) {
                literalBuilder.clear();
            }
        } else {
            literalBuilder.clear();
            char segmentStarter = config.segmentStarter();
            while (i < iBound && XChars.isNonWhitespace(input[i]) && input[i] != segmentStarter) {
                ++i;
            }
            int simpleLiteralEnd = i;
            if ((i = XCsvRecordParserCharArray.Static.skipSkippable(input, i, iBound, config.commentSignal(), config)) == iBound) {
                return iStart;
            }
            if (input[i] == segmentStarter) {
                literalBuilder.add(input, iStart, simpleLiteralEnd - iStart);
            }
        }
        return input[i] == config.segmentStarter() ? XCsvRecordParserCharArray.Static.skipSkippable(input, i + 1, iBound, config.commentSignal(), config) : iStart;
    }

    public static final void parseSegments(char[] input, int iStart, int iBound, VarString literalBuilder, XCsvConfiguration config, XCsvRowCollector rowAggregator, XCsvRecordParserCharArray.Provider recordParserProvider) {
        if (XCsvParserCharArray.isSegmentStart(input, iStart, iBound, literalBuilder, config)) {
            XCsvParserCharArray.parseMultipleSegments(input, iStart, iBound, literalBuilder, config, rowAggregator, recordParserProvider);
        } else {
            XCsvParserCharArray.parseSingletonSegment(input, iStart, iBound, literalBuilder, config, rowAggregator, recordParserProvider);
        }
    }

    static final void parseMultipleSegments(char[] input, int iStart, int iBound, VarString literalBuilder, XCsvConfiguration config, XCsvRowCollector rowAggregator, XCsvRecordParserCharArray.Provider recordParserProvider) {
        ColumnHeaderCollector columnNames = new ColumnHeaderCollector(new BulkList<String>());
        ColumnHeaderCollector columnTypes = new ColumnHeaderCollector(new BulkList<String>());
        char segmentTerminator = config.segmentTerminator();
        char lineSeparator = config.lineSeparator();
        char valueSeparator = config.valueSeparator();
        char commentSignal = config.commentSignal();
        char literalDelimiter = config.literalDelimiter();
        char escaper = config.escaper();
        EscapeHandler escapeHandler = config.escapeHandler();
        int i = iStart;
        while (i < iBound) {
            int i1 = XCsvParserCharArray.parseSegmentStart(input, i, iBound, literalBuilder, config);
            if (i1 == i) {
                throw new XCsvException("invalid segment start at index " + i);
            }
            i = XCsvParserCharArray.parseSegment(input, i1, iBound, lineSeparator, valueSeparator, commentSignal, literalDelimiter, escaper, escapeHandler, segmentTerminator, rowAggregator, literalBuilder, literalBuilder.toString(), columnNames, columnTypes, config, recordParserProvider);
            if (i >= iBound || input[i] != segmentTerminator) {
                throw new XCsvException("unclosed segment at index " + i);
            }
            i = XCsvRecordParserCharArray.Static.skipSkippable(input, i + 1, iBound, config.commentSignal(), config);
        }
    }

    static final void parseSingletonSegment(char[] input, int iStart, int iBound, VarString literalBuilder, XCsvConfiguration config, XCsvRowCollector rowAggregator, XCsvRecordParserCharArray.Provider recordParserProvider) {
        XCsvParserCharArray.parseSegment(input, iStart, iBound, config.lineSeparator(), config.valueSeparator(), config.commentSignal(), config.literalDelimiter(), config.escaper(), config.escapeHandler(), config.segmentTerminator(), rowAggregator, literalBuilder, null, new ColumnHeaderCollector(new BulkList<String>()), new ColumnHeaderCollector(new BulkList<String>()), config, recordParserProvider);
    }

    private static int parseSegmentHeader(char[] input, int iStart, int iBound, VarString literalBuilder, ColumnHeaderCollector columnNames, ColumnHeaderCollector columnTypes, XCsvConfiguration config) {
        int i = iStart;
        columnNames.clear();
        columnTypes.clear();
        char terminator = config.terminator();
        char valueSeparator = config.valueSeparator();
        char lineSeparator = config.lineSeparator();
        char commentSignal = config.commentSignal();
        i = XCsvParserCharArray.parseSimpleColumnLine(input, i, iBound, lineSeparator, terminator, config, literalBuilder, columnNames);
        if (i >= iBound || input[i] == terminator) {
            return i;
        }
        if (input[i] == lineSeparator) {
            ++i;
        }
        if ((i = XCsvRecordParserCharArray.Static.skipDataComments(input, i, iBound, terminator, valueSeparator, lineSeparator, commentSignal, config)) < iBound && input[i] == config.headerStarter()) {
            if ((i = XCsvParserCharArray.parseSimpleColumnLine(input, i + 1, iBound, config.headerTerminator(), terminator, config, literalBuilder, columnTypes)) >= iBound || input[i] == terminator) {
                throw new XCsvException("Unclosed header type line at index " + i);
            }
            ++i;
            while (i < iBound && input[i] != valueSeparator && XChars.isWhitespace(input[i])) {
                ++i;
            }
            i = XCsvRecordParserCharArray.Static.skipDataComments(input, i, iBound, terminator, valueSeparator, lineSeparator, commentSignal, config);
        }
        i = XCsvParserCharArray.skipLines(input, i, iBound, config.lineSeparator(), config.postColumnHeaderSkipLineCount());
        i = XCsvRecordParserCharArray.Static.skipDataComments(input, i, iBound, terminator, valueSeparator, lineSeparator, commentSignal, config);
        return i;
    }

    private static int parseSegment(char[] input, int iStart, int iBound, char lineSeparator, char valueSeparator, char commentSignal, char literalDelimiter, char escaper, EscapeHandler escapeHandler, char terminator, XCsvRowCollector rowCollector, VarString literalBuilder, String segmentName, ColumnHeaderCollector columnNames, ColumnHeaderCollector columnTypes, XCsvConfiguration config, XCsvRecordParserCharArray.Provider recordParserProvider) {
        if (iStart == iBound) {
            return iStart;
        }
        int i = iStart;
        i = XCsvParserCharArray.parseSegmentHeader(input, i, iBound, literalBuilder, columnNames, columnTypes, config);
        rowCollector.beginTable(segmentName, columnNames.values, columnTypes.values);
        XCsvRecordParserCharArray recordParser = recordParserProvider.provideRecordParser();
        while (i < iBound) {
            i = recordParser.parseRecord(input, i, iBound, valueSeparator, literalDelimiter, escaper, lineSeparator, terminator, config, literalBuilder, escapeHandler, rowCollector);
            rowCollector.completeRow();
            if (i >= iBound || input[i] == terminator) break;
            if (input[i] != lineSeparator) continue;
            i = XCsvRecordParserCharArray.Static.skipDataComments(input, i + 1, iBound, terminator, valueSeparator, lineSeparator, commentSignal, config);
        }
        rowCollector.completeTable();
        return i;
    }

    public static final XCsvParserCharArray New() {
        return new XCsvParserCharArray();
    }

    private XCsvParserCharArray() {
    }

    static XCsvSegmentsParser<_charArrayRange> provideSegmentsParser(XCsvConfiguration config, XCsvRowCollector rowAggregator) {
        return input -> XCsvParserCharArray.parseSegments(input.array(), input.start(), input.bound(), VarString.New(), config, rowAggregator, () -> XCsvParserCharArray::parseRecord);
    }

    @Override
    public XCsvConfiguration parseCsvData(XCsvDataType dataType, XCsvConfiguration config, _charArrayRange input, XCsvSegmentsParser.Provider<_charArrayRange> parserProvider, XCsvRowCollector rowAggregator) {
        XCsvConfiguration cfg = XCsvParserCharArray.ensureConfiguration(config);
        XCsvDataType dtp = XCsvParserCharArray.ensureDataType(dataType);
        XCsvSegmentsParser.Provider<_charArrayRange> pp = parserProvider != null ? parserProvider : XCsvParserCharArray::provideSegmentsParser;
        int startIndex = input.start();
        char[] data = input.array();
        int boundIndex = XCsvParserCharArray.skipLinesBackwards(data, startIndex, input.bound(), cfg.lineSeparator(), cfg.trailingLineCount());
        int i = XCsvParserCharArray.skipLines(data, startIndex, boundIndex, cfg.lineSeparator(), cfg.skipLineCount());
        i = XCsvRecordParserCharArray.Static.skipSkippable(data, i, boundIndex, cfg.commentSignal(), cfg);
        XReference<XCsvConfiguration> refConfig = X.Reference(cfg);
        i = XCsvParserCharArray.checkMetaCharacters(data, i, boundIndex, refConfig);
        cfg = XCsvParserCharArray.ensureEffectiveConfiguration(dtp, data, i, boundIndex, (XCsvConfiguration)refConfig.get());
        i = XCsvRecordParserCharArray.Static.skipSkippable(data, i, boundIndex, cfg.commentSignal(), cfg);
        XCsvSegmentsParser<_charArrayRange> parser = pp.provideSegmentsParser(cfg, rowAggregator);
        parser.parseSegments(_charArrayRange.New(data, i, boundIndex));
        return cfg;
    }

    static XCsvConfiguration ensureEffectiveConfiguration(XCsvDataType dataType, char[] input, int startIndex, int boundIndex, XCsvConfiguration config) {
        if (config != null) {
            return config;
        }
        if (startIndex >= boundIndex) {
            return dataType.configuration();
        }
        char lineSeparator = XCSV.configurationDefault().lineSeparator();
        EqConstHashTable.Values valueSeparatorWeights = dataType.valueSeparatorWeights().values();
        BulkList<Counter> counters = BulkList.New();
        long totalLines = XCsvParserCharArray.countLines(input, startIndex, boundIndex, lineSeparator);
        for (XCSV.ValueSeparatorWeight vsWeight : valueSeparatorWeights) {
            Counter counter = XCsvParserCharArray.countVsCandidate(input, startIndex, boundIndex, lineSeparator, vsWeight).calculateScore(totalLines);
            counters.add(counter);
        }
        counters.sort(Counter::orderByScore);
        XCsvConfiguration guessedConfiguration = XCsvParserCharArray.guessValueSeparator(dataType, counters);
        return guessedConfiguration;
    }

    private static XCsvConfiguration guessValueSeparator(XCsvDataType dataType, BulkList<Counter> counters) {
        if (counters.isEmpty() || counters.last().score() == 0.0) {
            return dataType.configuration();
        }
        char guessedValueSeparator = counters.last().character;
        return XCsvConfiguration.New(guessedValueSeparator);
    }

    static long countLines(char[] input, int startIndex, int boundIndex, char lineSeparator) {
        if (startIndex == boundIndex) {
            return 0L;
        }
        return 1 + XChars.count(input, startIndex, boundIndex, lineSeparator);
    }

    static Counter countVsCandidate(char[] input, int startIndex, int boundIndex, char lineSeparator, XCSV.ValueSeparatorWeight vsWeight) {
        char valueSeparator = vsWeight.valueSeparator();
        int emptyLines = 0;
        int vsTotalCount = 0;
        int vsPrevLineCount = 0;
        int vsCurrLineCount = 0;
        int vsLineCountChange = -1;
        int vsMaxCountPerLines = 0;
        int vsMinCountPerLines = Integer.MAX_VALUE;
        int i = startIndex - 1;
        while (true) {
            if (++i < boundIndex && input[i] != lineSeparator) {
                if (input[i] != valueSeparator) continue;
                ++vsCurrLineCount;
                continue;
            }
            if (vsCurrLineCount >= vsMaxCountPerLines) {
                vsMaxCountPerLines = vsCurrLineCount;
            }
            if (vsCurrLineCount == 0) {
                ++emptyLines;
            } else if (vsCurrLineCount < vsMinCountPerLines) {
                vsMinCountPerLines = vsCurrLineCount;
            }
            vsTotalCount += vsCurrLineCount;
            vsLineCountChange = XCsvParserCharArray.updateLineCountChange(vsLineCountChange, vsPrevLineCount, vsCurrLineCount);
            vsPrevLineCount = vsCurrLineCount;
            vsCurrLineCount = 0;
            if (i == boundIndex) break;
        }
        return new Counter(valueSeparator, vsWeight.weight(), vsTotalCount, vsMaxCountPerLines, vsMinCountPerLines, vsLineCountChange, emptyLines);
    }

    private static int updateLineCountChange(int currentLineCountChange, int vsPrevLineCount, int vsCurrLineCount) {
        return currentLineCountChange < 0 ? 0 : currentLineCountChange + Math.abs(vsPrevLineCount - vsCurrLineCount);
    }

    static final class ColumnHeaderCollector
    implements _charRangeProcedure {
        final BulkList<String> values;

        ColumnHeaderCollector(BulkList<String> values) {
            this.values = values;
        }

        final void clear() {
            this.values.clear();
        }

        @Override
        public final void accept(char[] data, int offset, int length) {
            this.values.add(data == null ? null : new String(data, offset, length));
        }
    }

    static final class Counter {
        final char character;
        final float weight;
        final int totalCount;
        final int maxCountPerLines;
        final int minCountPerLines;
        final int lineCountChange;
        final int emptyLines;
        double score;

        Counter(char character, float weight, int totalCount, int maxCountPerLines, int minCountPerLines, int lineCountChange, int emptyLines) {
            this.character = character;
            this.weight = weight;
            this.totalCount = totalCount;
            this.maxCountPerLines = maxCountPerLines;
            this.minCountPerLines = minCountPerLines;
            this.lineCountChange = lineCountChange;
            this.emptyLines = emptyLines;
        }

        final Counter calculateScore(long totalLines) {
            if (this.totalCount == 0) {
                this.score = 0.0;
                return this;
            }
            double averageCountPerLine = (double)this.totalCount / (double)totalLines;
            double emptyLineRatio = (double)this.emptyLines / (double)totalLines;
            double lineCountChangeRatio = (double)this.lineCountChange / (double)totalLines;
            double maxCountDeviationRatio = (double)this.maxCountPerLines / averageCountPerLine;
            double minCountDeviationRatio = averageCountPerLine / (double)this.minCountPerLines;
            double emptyLineFactor = 1.0 / (1.0 + emptyLineRatio);
            double lineCountChangeFactor = 1.0 / (1.0 + lineCountChangeRatio);
            double maxCountDeviationFactor = 1.0 / maxCountDeviationRatio;
            double minCountDeviationFactor = 1.0 / minCountDeviationRatio;
            double baseScore = averageCountPerLine * emptyLineFactor * lineCountChangeFactor * maxCountDeviationFactor * minCountDeviationFactor;
            this.score = XMath.round6(baseScore * (double)this.weight);
            return this;
        }

        final double score() {
            return this.score;
        }

        static final int orderByScore(Counter c1, Counter c2) {
            return c1.score >= c2.score ? (c1.score != c2.score ? 1 : 0) : -1;
        }
    }
}

