/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import org.eclipse.serializer.chars.MemoryCharConversionIntegersUTF8;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.memory.XMemory;

public final class MemoryCharConversion_doubleUTF8 {
    private static final transient double DOUBLE_NORMALIZATION_THRESHOLD_HIGH = 1.0E7;
    private static final transient double DOUBLE_NORMALIZATION_THRESHOLD_LOW = 0.001;
    private static final transient double DOUBLE_ONE = 1.0;
    private static final transient double DOUBLE_ZERO = 0.0;
    private static final transient double DOUBLE_E100 = 1.0E100;
    private static final transient double DOUBLE_E10 = 1.0E10;
    private static final transient double DOUBLE_LAST_DIGIT0 = 1.0E-19;
    private static final transient double DOUBLE_LAST_DIGIT1 = 1.0E-18;
    private static final transient double DOUBLE_LAST_DIGIT2 = 1.0E-17;
    private static final transient byte[] CHARS_ZERO = MemoryCharConversion_doubleUTF8.toSingleCharBytes(XChars.CHARS_ZERO);
    private static final transient byte[] CHARS_ONE = MemoryCharConversion_doubleUTF8.toSingleCharBytes(XChars.CHARS_ONE);
    private static final transient byte[] CHARS_NAN = MemoryCharConversion_doubleUTF8.toSingleCharBytes(XChars.CHARS_NAN);
    private static final transient byte[] CHARS_NEGATIVE_INFINITY = MemoryCharConversion_doubleUTF8.toSingleCharBytes(XChars.CHARS_NEGATIVE_INFINITY);
    private static final transient byte[] CHARS_POSITIVE_INFINITY = MemoryCharConversion_doubleUTF8.toSingleCharBytes(XChars.CHARS_POSITIVE_INFINITY);
    private static final transient byte[] CHARS_NORM_THRESH_HIGH = MemoryCharConversion_doubleUTF8.toSingleCharBytes(XChars.CHARS_NORM_THRESH_HIGH);
    private static final transient int DOUBLE_DIGITS_MAX = 17;
    private static final transient int DOUBLE_DIGITS_BOUND = 16;
    private static final transient byte ZERO = 48;
    private static final transient byte ONE = 49;
    private static final transient byte TWO = 50;
    private static final transient byte FIVE = 53;
    private static final transient byte SEVEN = 55;
    private static final transient byte EIGHT = 56;
    private static final transient byte NINE = 57;
    private static final transient byte MINUS = 45;
    private static final transient byte DOT = 46;
    private static final transient byte E = 69;

    private static byte[] toSingleCharBytes(char[] chars) {
        byte[] bytes = new byte[chars.length];
        int i = 0;
        while (i < chars.length) {
            bytes[i] = (byte)chars[i];
            ++i;
        }
        return bytes;
    }

    public static final long put(double value, long address) {
        if (Double.isNaN(value)) {
            XMemory.copyArrayToAddress(CHARS_NAN, address);
            return address + (long)CHARS_NAN.length;
        }
        if (value < 0.0) {
            if (value == Double.NEGATIVE_INFINITY) {
                XMemory.copyArrayToAddress(CHARS_NEGATIVE_INFINITY, address);
                return address + (long)CHARS_NEGATIVE_INFINITY.length;
            }
            XMemory.set_byte(address, (byte)45);
            return MemoryCharConversion_doubleUTF8.put_doublePositive(-value, address + 1L);
        }
        if (value == 0.0) {
            XMemory.copyArrayToAddress(CHARS_ZERO, address);
            return address + (long)CHARS_ZERO.length;
        }
        if (value == 1.0) {
            XMemory.copyArrayToAddress(CHARS_ONE, address);
            return address + (long)CHARS_ONE.length;
        }
        if (value == Double.POSITIVE_INFINITY) {
            XMemory.copyArrayToAddress(CHARS_POSITIVE_INFINITY, address);
            return address + (long)CHARS_POSITIVE_INFINITY.length;
        }
        return MemoryCharConversion_doubleUTF8.put_doublePositive(value, address);
    }

    private static long put_doublePositive(double value, long address) {
        return value < 1.0 ? MemoryCharConversion_doubleUTF8.put_doubleLt1(value, address) : MemoryCharConversion_doubleUTF8.put_doubleGte1(value, address);
    }

    private static long put_doubleLt1(double value, long address) {
        return value < 0.001 ? MemoryCharConversion_doubleUTF8.put_doubleLt1Normalized(value, address) : MemoryCharConversion_doubleUTF8.put_doubleLt1Denormalized(value, address);
    }

    private static long put_doubleGte1(double value, long address) {
        return value < 1.0E7 ? MemoryCharConversion_doubleUTF8.put_doubleGte1Denormalized(value, address) : MemoryCharConversion_doubleUTF8.put_doubleGte1Normalized(value, address);
    }

    private static long put_doubleGte1Denormalized(double value, long address) {
        int exponent = MemoryCharConversion_doubleUTF8.exponent(value);
        XMemory.set_byte(address, (byte)48);
        long i = MemoryCharConversion_doubleUTF8.put_doubleAndCleanup(value * MemoryCharConversion_doubleUTF8.pow10(16 - exponent), address + 1L);
        if (XMemory.get_byte(address) != 48) {
            return MemoryCharConversion_doubleUTF8.handle_doubleGte1DenormSpecialCase(address, exponent);
        }
        XMemory.copyRange(address + 1L, address, exponent + 1);
        XMemory.set_byte(address + (long)exponent + 1L, (byte)46);
        return Math.max(i, address + (long)exponent + 3L);
    }

    private static long handle_doubleGte1DenormSpecialCase(long address, int exponent) {
        if (exponent == 7) {
            XMemory.copyArrayToAddress(CHARS_NORM_THRESH_HIGH, address);
            return address + (long)CHARS_NORM_THRESH_HIGH.length;
        }
        int e = Math.max(exponent, 1) + 1;
        int i = 1;
        while (i <= e) {
            XMemory.set_byte(address + 1L, (byte)48);
            ++i;
        }
        XMemory.set_byte(address + (long)e, (byte)46);
        XMemory.set_byte(address + (long)e + 1L, (byte)48);
        return address + (long)e + 2L;
    }

    private static long putSimpleCharacterString(String s, long address) {
        char[] chars = XChars.readChars(s);
        int i = 0;
        while (i < chars.length) {
            XMemory.set_byte(address + (long)i, (byte)chars[i]);
            ++i;
        }
        return address + (long)chars.length;
    }

    private static long put_doubleGte1Normalized(double value, long address) {
        int exponent = MemoryCharConversion_doubleUTF8.exponent(value);
        double intedValue = value * (exponent < 17 ? MemoryCharConversion_doubleUTF8.pow10(16 - exponent) : MemoryCharConversion_doubleUTF8.root10(16 - exponent));
        if (intedValue == Double.POSITIVE_INFINITY || intedValue == Double.NEGATIVE_INFINITY) {
            return MemoryCharConversion_doubleUTF8.putSimpleCharacterString(Double.toString(value), address);
        }
        XMemory.set_byte(address, (byte)48);
        long i = MemoryCharConversion_doubleUTF8.put_doubleAndCleanup(intedValue, address + 1L);
        if (XMemory.get_byte(address) != 48) {
            XMemory.set_byte(address + 1L, (byte)46);
            XMemory.set_byte(address + 2L, (byte)48);
            i = address + 3L;
        } else {
            XMemory.set_byte(address, XMemory.get_byte(address + 1L));
            XMemory.set_byte(address + 1L, (byte)46);
            if (i == address + 2L) {
                ++i;
            }
        }
        XMemory.set_byte(i, (byte)69);
        return MemoryCharConversionIntegersUTF8.put_int3(exponent, i + 1L);
    }

    private static long put_doubleLt1Denormalized(double value, long address) {
        XMemory.set_byte(address + 1L, (byte)48);
        long i = MemoryCharConversion_doubleUTF8.put_doubleLt1DenormAndCleanup(value, address);
        XMemory.set_byte(address, XMemory.get_byte(address + 1L));
        XMemory.set_byte(address + 1L, (byte)46);
        if (i == address + 2L) {
            XMemory.set_byte(i++, (byte)48);
        }
        return i;
    }

    private static long put_doubleLt1DenormAndCleanup(double value, long address) {
        switch (MemoryCharConversion_doubleUTF8.exponent(value)) {
            case -3: {
                XMemory.set_byte(address + 2L, (byte)48);
                XMemory.set_byte(address + 3L, (byte)48);
                return MemoryCharConversion_doubleUTF8.put_doubleAndCleanup(value / 1.0E-19, address + 4L);
            }
            case -2: {
                XMemory.set_byte(address + 2L, (byte)48);
                return MemoryCharConversion_doubleUTF8.put_doubleAndCleanup(value / 1.0E-18, address + 3L);
            }
        }
        return MemoryCharConversion_doubleUTF8.put_doubleAndCleanup(value / 1.0E-17, address + 2L);
    }

    private static long put_doubleLt1Normalized(double value, long address) {
        int exponent = MemoryCharConversion_doubleUTF8.exponent(value);
        double intedValue = value * MemoryCharConversion_doubleUTF8.pow10(16 - exponent);
        if (intedValue == Double.POSITIVE_INFINITY || intedValue == Double.NEGATIVE_INFINITY) {
            return MemoryCharConversion_doubleUTF8.putSimpleCharacterString(Double.toString(value), address);
        }
        long i = MemoryCharConversion_doubleUTF8.put_doubleAndCleanup(intedValue, address + 1L);
        XMemory.set_byte(address, XMemory.get_byte(address + 1L));
        XMemory.set_byte(address + 1L, (byte)46);
        if (i == address + 2L) {
            XMemory.set_byte(i++, (byte)48);
        }
        XMemory.set_byte(i, (byte)69);
        XMemory.set_byte(i + 1L, (byte)45);
        return MemoryCharConversionIntegersUTF8.put_int3(-exponent, i + 2L);
    }

    private static int exponent(double value) {
        return (int)Math.floor(Math.log10(value));
    }

    private static double pow10(int exponent) {
        double result = 1.0;
        int e = exponent;
        while (e >= 100) {
            e -= 100;
            result *= 1.0E100;
        }
        while (e >= 10) {
            e -= 10;
            result *= 1.0E10;
        }
        while (e-- > 0) {
            result *= 10.0;
        }
        return result;
    }

    private static double root10(int exponent) {
        double result = 1.0;
        int e = exponent;
        while (e < -99) {
            e += 100;
            result /= 1.0E100;
        }
        while (e < -9) {
            e += 10;
            result /= 1.0E10;
        }
        while (e++ <= 0) {
            result /= 10.0;
        }
        return result;
    }

    private static long put_doubleAndCleanup(double value, long address) {
        return MemoryCharConversion_doubleUTF8.cleanupDecimal(address, MemoryCharConversionIntegersUTF8.put_longPositive((long)value, address));
    }

    private static long cleanupDecimal(long address, long i) {
        switch ((int)(i - address)) {
            case 17: {
                return MemoryCharConversion_doubleUTF8.removeTrailingLast(i - 1L);
            }
            case 16: {
                return MemoryCharConversion_doubleUTF8.removeTrailingPreLast(i - 1L);
            }
        }
        return XMemory.get_byte(i - 1L) == 57 ? MemoryCharConversion_doubleUTF8.removeTrailingNinesSimple(i - 1L) : MemoryCharConversion_doubleUTF8.removeTrailingZerosSimple(i - 1L);
    }

    private static long removeTrailingZerosSimple(long address) {
        long a = address;
        while (XMemory.get_byte(a) == 48) {
            --a;
        }
        return a + 1L;
    }

    private static long removeTrailingLast(long address) {
        if (XMemory.get_byte(address - 3L) == 57 && XMemory.get_byte(address - 2L) == 57 && XMemory.get_byte(address - 1L) >= 55) {
            return MemoryCharConversion_doubleUTF8.removeTrailingNinesSimple(address - 3L);
        }
        if (XMemory.get_byte(address - 3L) == 48 && XMemory.get_byte(address - 2L) == 48 && XMemory.get_byte(address - 1L) <= 50) {
            return MemoryCharConversion_doubleUTF8.removeTrailingZerosSimple(address - 3L);
        }
        if (XMemory.get_byte(address - 2L) == 57 && XMemory.get_byte(address - 1L) >= 56) {
            return MemoryCharConversion_doubleUTF8.removeTrailingNinesSimple(address - 2L);
        }
        if (XMemory.get_byte(address - 2L) == 48 && XMemory.get_byte(address - 1L) <= 49) {
            return MemoryCharConversion_doubleUTF8.removeTrailingZerosSimple(address - 2L);
        }
        if (XMemory.get_byte(address - 1L) == 57 && XMemory.get_byte(address) >= 53) {
            XMemory.set_byte(address - 2L, (byte)(XMemory.get_byte(address - 2L) + 1));
            return address - 1L;
        }
        if (XMemory.get_byte(address - 1L) == 48 && XMemory.get_byte(address) < 53) {
            return address - 1L;
        }
        if (XMemory.get_byte(address) >= 53) {
            XMemory.set_byte(address - 1L, (byte)(XMemory.get_byte(address - 1L) + 1));
            return address;
        }
        return address;
    }

    private static long removeTrailingPreLast(long address) {
        if (XMemory.get_byte(address - 2L) == 57 && XMemory.get_byte(address - 1L) == 57 && XMemory.get_byte(address - 1L) >= 55) {
            return MemoryCharConversion_doubleUTF8.removeTrailingNinesSimple(address - 2L);
        }
        if (XMemory.get_byte(address - 2L) == 48 && XMemory.get_byte(address - 1L) == 48 && XMemory.get_byte(address) <= 50) {
            return MemoryCharConversion_doubleUTF8.removeTrailingZerosSimple(address - 2L);
        }
        if (XMemory.get_byte(address - 1L) == 57 && XMemory.get_byte(address) >= 56) {
            return MemoryCharConversion_doubleUTF8.removeTrailingNinesSimple(address - 1L);
        }
        if (XMemory.get_byte(address - 1L) == 48 && XMemory.get_byte(address) <= 49) {
            return MemoryCharConversion_doubleUTF8.removeTrailingZerosSimple(address - 1L);
        }
        if (XMemory.get_byte(address) >= 56) {
            XMemory.set_byte(address - 1L, (byte)(XMemory.get_byte(address - 1L) + 1));
            return address;
        }
        if (XMemory.get_byte(address) <= 49) {
            return address;
        }
        return address + 1L;
    }

    private static long removeTrailingNinesSimple(long address) {
        long a = address;
        while (XMemory.get_byte(a) == 57) {
            --a;
        }
        XMemory.set_byte(a, (byte)(XMemory.get_byte(a) + 1));
        return a + 1L;
    }

    private MemoryCharConversion_doubleUTF8() {
        throw new UnsupportedOperationException();
    }
}

