/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.memory.XMemory;

public final class MemoryCharConversionUTF8 {
    static final int THRESHOLD_1_BYTE = 128;
    static final int THRESHOLD_2_BYTE = 2048;
    static final int MAX_CHAR_LENGTH = 3;

    public static final int maxCharacterLength() {
        return 3;
    }

    public static final boolean isSingleByte(char c) {
        return c < '\u0080';
    }

    public static final byte toSingleByte(char c) {
        if (MemoryCharConversionUTF8.isSingleByte(c)) {
            return (byte)c;
        }
        throw new IllegalArgumentException("Not a simple UTF-8 character: " + c);
    }

    public static final int utf8Length(char c) {
        return MemoryCharConversionUTF8.isSingleByte(c) ? 1 : (c < '\u0800' ? 2 : 3);
    }

    public static final int utf8Length(char ... chars) {
        int length = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            length += MemoryCharConversionUTF8.utf8Length(c);
            ++n2;
        }
        return length;
    }

    public static final byte[] toUTF8(char ... chars) {
        byte[] array = new byte[MemoryCharConversionUTF8.utf8Length(chars)];
        int a = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (MemoryCharConversionUTF8.isSingleByte(c)) {
                array[a++] = (byte)c;
            } else if (c < '\u0800') {
                array[a] = (byte)(0xC0 | c >> 6);
                array[a + 1] = (byte)(0x80 | c & 0x3F);
                a += 2;
            } else {
                array[a] = (byte)(0xE0 | c >> 12);
                array[a + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                array[a + 2] = (byte)(0x80 | c & 0x3F);
                a += 3;
            }
            ++n2;
        }
        return array;
    }

    public static final long writeUTF8(long address, char c) {
        if (MemoryCharConversionUTF8.isSingleByte(c)) {
            XMemory.set_byte(address, (byte)c);
            return address + 1L;
        }
        if (c < '\u0800') {
            XMemory.set_byte(address, (byte)(0xC0 | c >> 6));
            XMemory.set_byte(address + 1L, (byte)(0x80 | c & 0x3F));
            return address + 2L;
        }
        XMemory.set_byte(address, (byte)(0xE0 | c >> 12));
        XMemory.set_byte(address + 1L, (byte)(0x80 | c >> 6 & 0x3F));
        XMemory.set_byte(address + 2L, (byte)(0x80 | c & 0x3F));
        return address + 3L;
    }

    public static final long writeUTF8(long address, char ... chars) {
        long a = address;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            a = MemoryCharConversionUTF8.writeUTF8(a, c);
            ++n2;
        }
        return a;
    }

    public static final long writeUTF8(long address, char[] chars, int offset, int length) {
        long a = address;
        int bound = offset + length;
        int i = offset;
        while (i < bound) {
            a = MemoryCharConversionUTF8.writeUTF8(a, chars[i]);
            ++i;
        }
        return a;
    }

    public static final long writeUTF8(long address, String string) {
        return MemoryCharConversionUTF8.writeUTF8(address, XChars.readChars(string));
    }

    public static final long writeUTF8(long address, VarString vs) {
        char[] chars = vs.toArray();
        return MemoryCharConversionUTF8.writeUTF8(address, chars, 0, chars.length);
    }

    private MemoryCharConversionUTF8() {
        throw new UnsupportedOperationException();
    }
}

