/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.memory.XMemory;

public final class MemoryCharConversionIntegers {
    private static final int V001G = 1000000000;
    private static final int V100M = 100000000;
    private static final int V010M = 10000000;
    private static final int V001M = 1000000;
    private static final int V100K = 100000;
    private static final int V010K = 10000;
    private static final int V001K = 1000;
    private static final int V100 = 100;
    private static final int V010 = 10;
    private static final long V001Z = 1000000000000000000L;
    private static final long V100P = 100000000000000000L;
    private static final long V010P = 10000000000000000L;
    private static final long V001P = 1000000000000000L;
    private static final long V100T = 100000000000000L;
    private static final long V010T = 10000000000000L;
    private static final long V001T = 1000000000000L;
    private static final long V100G = 100000000000L;
    private static final long V010G = 10000000000L;
    static final int BYTE_SIZE_CHAR = XMemory.byteSize_char();
    static final int BYTE_SIZE_DOUBLECHAR = 2 * BYTE_SIZE_CHAR;
    static final int MAX_BYTE_COUNT_byte = BYTE_SIZE_CHAR * XChars.MAX_CHAR_COUNT_byte;
    static final int MAX_BYTE_COUNT_short = BYTE_SIZE_CHAR * XChars.MAX_CHAR_COUNT_short;
    static final int MAX_BYTE_COUNT_int = BYTE_SIZE_CHAR * XChars.MAX_CHAR_COUNT_int;
    static final int MAX_BYTE_COUNT_long = BYTE_SIZE_CHAR * XChars.MAX_CHAR_COUNT_long;

    public static long put_byte(byte value, long address) {
        if (value < 0) {
            return MemoryCharConversionIntegers.put_intPositive5(-value, MemoryCharConversionIntegers.putMinus(address));
        }
        return MemoryCharConversionIntegers.put_intPositive5(value, address);
    }

    public static long put_short(short value, long address) {
        if (value < 0) {
            return MemoryCharConversionIntegers.put_intPositive5(-value, MemoryCharConversionIntegers.putMinus(address));
        }
        return MemoryCharConversionIntegers.put_intPositive5(value, address);
    }

    public static long put_int(int value, long address) {
        if (value < 0) {
            return MemoryCharConversionIntegers.put_intNegative(value, address);
        }
        return MemoryCharConversionIntegers.put_intPositive(value, address);
    }

    public static long put_long(long value, long address) {
        if (value < 0L) {
            return MemoryCharConversionIntegers.put_longNegative(value, address);
        }
        return MemoryCharConversionIntegers.put_longPositive(value, address);
    }

    private static long putMinus(long address) {
        XMemory.set_char(address, '-');
        return address + (long)BYTE_SIZE_CHAR;
    }

    private static long put1Char(int singleDigitValue, long address) {
        XMemory.set_char(address, (char)(48 + singleDigitValue));
        return address + (long)BYTE_SIZE_CHAR;
    }

    private static long put2Chars(int doubleDigitValue, long address) {
        XMemory.set_char(address, XChars.DECIMAL_CHAR_TABLE_10S[doubleDigitValue]);
        XMemory.set_char(address + (long)BYTE_SIZE_CHAR, XChars.DECIMAL_CHAR_TABLE_01S[doubleDigitValue]);
        return address + (long)BYTE_SIZE_DOUBLECHAR;
    }

    private static long put_longNegative(long value, long address) {
        if (value == Long.MIN_VALUE) {
            XMemory.copyArrayToAddress(XChars.CHARS_MIN_VALUE_long, address);
            return address + (long)MAX_BYTE_COUNT_long;
        }
        return MemoryCharConversionIntegers.put_longPositive(-value, MemoryCharConversionIntegers.putMinus(address));
    }

    private static long put_intNegative(int value, long address) {
        if (value == Integer.MIN_VALUE) {
            XMemory.copyArrayToAddress(XChars.CHARS_MIN_VALUE_int, address);
            return address + (long)MAX_BYTE_COUNT_int;
        }
        return MemoryCharConversionIntegers.put_intPositive(-value, MemoryCharConversionIntegers.putMinus(address));
    }

    public static long put_longPositive(long value, long address) {
        if (value >= 1000000000L) {
            if (value >= 1000000000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveHI(value % 1000000000000000000L, MemoryCharConversionIntegers.put1Char((int)(value / 1000000000000000000L), address));
            }
            if (value >= 100000000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveHI(value, address);
            }
            if (value >= 10000000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveFG(value % 10000000000000000L, MemoryCharConversionIntegers.put1Char((int)(value / 10000000000000000L), address));
            }
            if (value >= 1000000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveFG(value, address);
            }
            if (value >= 100000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveDE(value % 100000000000000L, MemoryCharConversionIntegers.put1Char((int)(value / 100000000000000L), address));
            }
            if (value >= 10000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveDE(value, address);
            }
            if (value >= 1000000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveBC(value % 1000000000000L, MemoryCharConversionIntegers.put1Char((int)(value / 1000000000000L), address));
            }
            if (value >= 100000000000L) {
                return MemoryCharConversionIntegers.put_longPositiveBC(value, address);
            }
            if (value >= 10000000000L) {
                return MemoryCharConversionIntegers.put_longPositive9A(value % 10000000000L, MemoryCharConversionIntegers.put1Char((int)(value / 10000000000L), address));
            }
            return MemoryCharConversionIntegers.put_longPositive9A(value, address);
        }
        return MemoryCharConversionIntegers.put_intPositive((int)value, address);
    }

    private static long put_intPositive(int value, long address) {
        if (value >= 100000) {
            if (value >= 1000000000) {
                return MemoryCharConversionIntegers.put_intPositive9m(value, address);
            }
            if (value >= 100000000) {
                return MemoryCharConversionIntegers.put_intPositive78(value % 100000000, MemoryCharConversionIntegers.put1Char(value / 100000000, address));
            }
            if (value >= 10000000) {
                return MemoryCharConversionIntegers.put_intPositive78(value, address);
            }
            if (value >= 1000000) {
                return MemoryCharConversionIntegers.put_intPositive56(value % 1000000, MemoryCharConversionIntegers.put1Char(value / 1000000, address));
            }
            return MemoryCharConversionIntegers.put_intPositive56(value, address);
        }
        return MemoryCharConversionIntegers.put_intPositive5(value, address);
    }

    private static long put_intPositive5(int value, long address) {
        if (value >= 100) {
            if (value >= 10000) {
                return MemoryCharConversionIntegers.put_intPositive43(value % 10000, MemoryCharConversionIntegers.put1Char(value / 10000, address));
            }
            if (value >= 1000) {
                return MemoryCharConversionIntegers.put_intPositive43(value, address);
            }
            return MemoryCharConversionIntegers.put2Chars(value % 100, MemoryCharConversionIntegers.put1Char(value / 100, address));
        }
        return MemoryCharConversionIntegers.put_intPositive21(value, address);
    }

    private static long put_longPositiveHI(long value, long address) {
        return MemoryCharConversionIntegers.put_longPositiveFG(value % 10000000000000000L, MemoryCharConversionIntegers.put2Chars((int)(value / 10000000000000000L), address));
    }

    private static long put_longPositiveFG(long value, long address) {
        return MemoryCharConversionIntegers.put_longPositiveDE(value % 100000000000000L, MemoryCharConversionIntegers.put2Chars((int)(value / 100000000000000L), address));
    }

    private static long put_longPositiveDE(long value, long address) {
        return MemoryCharConversionIntegers.put_longPositiveBC(value % 1000000000000L, MemoryCharConversionIntegers.put2Chars((int)(value / 1000000000000L), address));
    }

    private static long put_longPositiveBC(long value, long address) {
        return MemoryCharConversionIntegers.put_longPositive9A(value % 10000000000L, MemoryCharConversionIntegers.put2Chars((int)(value / 10000000000L), address));
    }

    private static long put_longPositive9A(long value, long address) {
        return MemoryCharConversionIntegers.put_intPositive78((int)(value % 100000000L), MemoryCharConversionIntegers.put2Chars((int)(value / 100000000L), address));
    }

    private static long put_intPositive9m(int value, long address) {
        return MemoryCharConversionIntegers.put_intPositive78(value % 100000000, MemoryCharConversionIntegers.put2Chars(value / 100000000, address));
    }

    private static long put_intPositive78(int value, long address) {
        return MemoryCharConversionIntegers.put_intPositive56(value % 1000000, MemoryCharConversionIntegers.put2Chars(value / 1000000, address));
    }

    private static long put_intPositive56(int value, long address) {
        return MemoryCharConversionIntegers.put_intPositive43(value % 10000, MemoryCharConversionIntegers.put2Chars(value / 10000, address));
    }

    private static long put_intPositive43(int value, long address) {
        return MemoryCharConversionIntegers.put2Chars(value % 100, MemoryCharConversionIntegers.put2Chars(value / 100, address));
    }

    private static long put_intPositive21(int value, long address) {
        return value >= 10 ? MemoryCharConversionIntegers.put2Chars(value, address) : MemoryCharConversionIntegers.put1Char(value, address);
    }

    private MemoryCharConversionIntegers() {
        throw new UnsupportedOperationException();
    }
}

