/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.typing.Stateless;

public interface EscapeHandler {
    public void handleEscapedChar(char var1, VarString var2);

    public boolean needsEscaping(char var1);

    public char transformEscapedChar(char var1);

    public char unescape(char var1);

    public static char parseCharacter(String c, char escapeCharacter) {
        if (c == null || c.isEmpty()) {
            throw new IllegalArgumentException("String is empty");
        }
        if (c.charAt(0) == escapeCharacter) {
            if (c.length() > 2) {
                throw new IllegalArgumentException("String consists of more than one character");
            }
            return Default.internalUnescape(c.charAt(1));
        }
        if (c.length() > 1) {
            throw new IllegalArgumentException("String consists of more than one character");
        }
        return c.charAt(0);
    }

    public static final class Default
    implements EscapeHandler,
    Stateless {
        static char internalUnescape(char chr) {
            switch (chr) {
                case 't': {
                    return '\t';
                }
                case 'b': {
                    return '\b';
                }
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 'f': {
                    return '\f';
                }
            }
            return chr;
        }

        @Override
        public final char unescape(char chr) {
            return Default.internalUnescape(chr);
        }

        @Override
        public final void handleEscapedChar(char escapedChar, VarString literalBuilder) {
            literalBuilder.add(Default.internalUnescape(escapedChar));
        }

        @Override
        public final boolean needsEscaping(char chr) {
            switch (chr) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    return true;
                }
            }
            return false;
        }

        @Override
        public final char transformEscapedChar(char chr) {
            switch (chr) {
                case '\t': {
                    return 't';
                }
                case '\b': {
                    return 'b';
                }
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\f': {
                    return 'f';
                }
            }
            return chr;
        }
    }
}

