/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.bytes;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.math.XMath;

public final class VarByte
implements Externalizable {
    private static final int CAPACITY_MIN = 4;
    private static final int CAPACITY_SMALL = 64;
    byte[] data;
    int size;

    private static final int boundPow2(int n) {
        if (XMath.isGreaterThanHighestPowerOf2(n)) {
            return Integer.MAX_VALUE;
        }
        int p2 = 4;
        while (p2 < n) {
            p2 <<= 1;
        }
        return p2;
    }

    public static VarByte New() {
        return new VarByte(64);
    }

    public static VarByte New(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity may not be negative: " + initialCapacity);
        }
        return new VarByte(VarByte.boundPow2(initialCapacity));
    }

    private VarByte() {
        this(4);
    }

    private VarByte(int uncheckedInitialCapacity) {
        this.data = new byte[uncheckedInitialCapacity];
        this.size = 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.read();
        byte[] data = new byte[VarByte.boundPow2(size)];
        int i = 0;
        while (i < size) {
            data[i] = in.readByte();
            ++i;
        }
        this.data = data;
        this.size = size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] data = this.data;
        int size = this.size;
        out.write(size);
        int i = 0;
        while (i < size) {
            out.writeByte(data[i]);
            ++i;
        }
    }

    public String toString() {
        return new String(this.data, 0, this.size);
    }

    public String toString(Charset charset) throws UnsupportedEncodingException {
        return new String(this.data, 0, this.size, charset);
    }

    public void ensureFreeCapacity(int requiredFreeCapacity) {
        int newCapacity;
        if (this.data.length - this.size >= requiredFreeCapacity) {
            return;
        }
        if (Integer.MAX_VALUE - this.size < requiredFreeCapacity) {
            throw new ArrayCapacityException((long)requiredFreeCapacity + (long)this.size);
        }
        int newSize = this.size + requiredFreeCapacity;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        byte[] data = new byte[newCapacity];
        System.arraycopy(this.data, 0, data, 0, this.size);
        this.data = data;
    }

    private void internalAppend(byte[] bytes, int offset, int length) {
        this.ensureFreeCapacity(length);
        System.arraycopy(bytes, offset, this.data, this.size, length);
        this.size += length;
    }

    public VarByte append(byte[] bytes, int offset, int length) {
        this.internalAppend(bytes, offset, length);
        return this;
    }

    public VarByte clear() {
        byte[] data = this.data;
        int i = 0;
        int length = data.length;
        while (i < length) {
            data[i] = 0;
            ++i;
        }
        this.size = 0;
        return this;
    }
}

