/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.afs.types;

import java.util.function.Function;
import org.eclipse.serializer.afs.exceptions.AfsExceptionConsistency;
import org.eclipse.serializer.afs.exceptions.AfsExceptionExclusiveAttemptConflict;
import org.eclipse.serializer.afs.exceptions.AfsExceptionExclusiveAttemptSharedUserConflict;
import org.eclipse.serializer.afs.exceptions.AfsExceptionMutation;
import org.eclipse.serializer.afs.exceptions.AfsExceptionMutationInUse;
import org.eclipse.serializer.afs.exceptions.AfsExceptionSharedAttemptExclusiveUserConflict;
import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.afs.types.AFileSystem;
import org.eclipse.serializer.afs.types.AReadableFile;
import org.eclipse.serializer.afs.types.AWritableFile;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.HashTable;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.interfaces.OptimizableCollection;
import org.eclipse.serializer.util.X;

public interface AccessManager {
    public AFileSystem fileSystem();

    public boolean isUsed(ADirectory var1);

    public boolean isMutating(ADirectory var1);

    public boolean isUsed(AFile var1);

    public boolean isUsedReading(AFile var1);

    public boolean isUsedWriting(AFile var1);

    public boolean isUsedReading(AFile var1, Object var2);

    public boolean isUsedWriting(AFile var1, Object var2);

    public AReadableFile useReading(AFile var1, Object var2);

    public AWritableFile useWriting(AFile var1, Object var2);

    public AReadableFile tryUseReading(AFile var1, Object var2);

    public AWritableFile tryUseWriting(AFile var1, Object var2);

    public AReadableFile downgrade(AWritableFile var1);

    public boolean unregister(AReadableFile var1);

    public boolean unregister(AWritableFile var1);

    default public Object defaultUser() {
        return Thread.currentThread();
    }

    default public AReadableFile useReading(AFile file) {
        return this.useReading(file, this.defaultUser());
    }

    default public AWritableFile useWriting(AFile file) {
        return this.useWriting(file, this.defaultUser());
    }

    default public AReadableFile tryUseReading(AFile file) {
        return this.useReading(file, this.defaultUser());
    }

    default public AWritableFile tryUseWriting(AFile file) {
        return this.useWriting(file, this.defaultUser());
    }

    public <R> R executeMutating(ADirectory var1, Function<? super ADirectory, R> var2);

    public static AccessManager New(AFileSystem fileSystem) {
        return new Default<AFileSystem>((AFileSystem)X.notNull((Object)fileSystem));
    }

    public static class Default<S extends AFileSystem>
    implements AccessManager {
        private final S fileSystem;
        private final HashTable<ADirectory, DirEntry> usedDirectories;
        private final HashTable<ADirectory, Thread> mutatingDirectories;
        private final HashTable<AFile, FileEntry> fileUsers;
        private static final ConflictHandler CONFLICT_HANDLER_NO_OP = new ConflictHandler(){

            @Override
            public void handleSharedAttemptExclusiveUserConflict(AFile actual, Object user, FileEntry entry) {
            }

            @Override
            public void handleExclusiveAttemptConflict(AFile actual, Object user, FileEntry entry) {
            }

            @Override
            public void handleExclusiveAttemptSharedUsersConflict(AFile actual, Object user, FileEntry entry) {
            }
        };
        private static final ConflictHandler CONFLICT_HANDLER_EXCEPTION = new ConflictHandler(){

            @Override
            public void handleSharedAttemptExclusiveUserConflict(AFile actual, Object user, FileEntry entry) {
                throw new AfsExceptionSharedAttemptExclusiveUserConflict("File is already exclusively used by a different user: " + actual + ". Exclusive user: " + Default.toStringWithIdentity(entry.exclusive.user()) + ". Attempting user: " + Default.toStringWithIdentity(user) + ".");
            }

            @Override
            public void handleExclusiveAttemptConflict(AFile actual, Object user, FileEntry entry) {
                throw new AfsExceptionExclusiveAttemptConflict("File is already used by a different exclusive user: " + actual + ". Exclusive user: " + Default.toStringWithIdentity(entry.exclusive.user()) + ". Attempting user: " + Default.toStringWithIdentity(user) + ".");
            }

            @Override
            public void handleExclusiveAttemptSharedUsersConflict(AFile actual, Object user, FileEntry entry) {
                throw new AfsExceptionExclusiveAttemptSharedUserConflict("File \"" + actual.toPathString() + "\" cannot be accessed exclusively since there are shared users present.");
            }
        };

        protected Default(S fileSystem) {
            this.fileSystem = fileSystem;
            this.usedDirectories = HashTable.New();
            this.mutatingDirectories = HashTable.New();
            this.fileUsers = HashTable.New();
        }

        protected final Object mutex() {
            return this.fileSystem;
        }

        public final S fileSystem() {
            return this.fileSystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUsed(ADirectory directory) {
            Object object = this.mutex();
            synchronized (object) {
                return this.usedDirectories.get((Object)ADirectory.actual(directory)) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isMutating(ADirectory directory) {
            Object object = this.mutex();
            synchronized (object) {
                return this.mutatingDirectories.keys().contains((Object)ADirectory.actual(directory));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUsed(AFile file) {
            Object object = this.mutex();
            synchronized (object) {
                FileEntry e = (FileEntry)this.fileUsers.get((Object)AFile.actual(file));
                if (e == null) {
                    return false;
                }
                return e.exclusive != null || e.hasSharedUsers();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUsedReading(AFile file) {
            Object object = this.mutex();
            synchronized (object) {
                FileEntry e = (FileEntry)this.fileUsers.get((Object)AFile.actual(file));
                if (e == null) {
                    return false;
                }
                return e.exclusive != null || e.hasSharedUsers();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUsedWriting(AFile file) {
            Object object = this.mutex();
            synchronized (object) {
                FileEntry e = (FileEntry)this.fileUsers.get((Object)AFile.actual(file));
                if (e == null) {
                    return false;
                }
                return e.exclusive != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUsedReading(AFile file, Object user) {
            Object object = this.mutex();
            synchronized (object) {
                FileEntry e = (FileEntry)this.fileUsers.get((Object)AFile.actual(file));
                if (e == null) {
                    return false;
                }
                return e.exclusive == user || e.getForUser(user) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUsedWriting(AFile file, Object user) {
            Object object = this.mutex();
            synchronized (object) {
                FileEntry e = (FileEntry)this.fileUsers.get((Object)AFile.actual(file));
                if (e == null) {
                    return false;
                }
                return e.exclusive != null && e.exclusive.user() == user;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final <R> R executeMutating(ADirectory directory, Function<? super ADirectory, R> logic) {
            Object object = this.mutex();
            synchronized (object) {
                ADirectory actual = ADirectory.actual(directory);
                Thread mutatingThread = (Thread)this.mutatingDirectories.get((Object)actual);
                if (mutatingThread == Thread.currentThread()) {
                    return logic.apply(actual);
                }
                if (mutatingThread != null) {
                    throw new AfsExceptionMutationInUse("Directory \"" + directory.toPathString() + "\" already used for mutation by \"" + mutatingThread + "\".");
                }
                Object user = this.usedDirectories.get((Object)actual);
                if (user != null && user != Thread.currentThread()) {
                    throw new AfsExceptionMutationInUse("Directory \"" + directory.toPathString() + "\" already used by \"" + user + "\".");
                }
                this.mutatingDirectories.add((Object)actual, (Object)Thread.currentThread());
                R r = logic.apply(directory);
                return r;
                finally {
                    this.mutatingDirectories.removeFor((Object)actual);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AReadableFile useReading(AFile file, Object user) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalUseReading(file, user, CONFLICT_HANDLER_EXCEPTION);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AReadableFile tryUseReading(AFile file, Object user) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalUseReading(file, user, CONFLICT_HANDLER_NO_OP);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AWritableFile useWriting(AFile file, Object user) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalUseWriting(file, user, CONFLICT_HANDLER_EXCEPTION);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AWritableFile tryUseWriting(AFile file, Object user) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalUseWriting(file, user, CONFLICT_HANDLER_NO_OP);
            }
        }

        private FileEntry createFileEntry(AFile actual) {
            FileEntry e = new FileEntry();
            this.fileUsers.add((Object)actual, (Object)e);
            return e;
        }

        private AReadableFile registerReading(FileEntry entry, AFile actual, Object user) {
            AReadableFile wrapper = this.registerReading(actual, user);
            entry.add(wrapper);
            return wrapper;
        }

        private AReadableFile registerReading(AFile actual, Object user) {
            this.checkForMutatingParents(actual, user);
            this.incrementDirectoryUsageCount(actual.parent());
            return this.fileSystem().wrapForReading(actual, user);
        }

        private AReadableFile convertToReading(AWritableFile file) {
            this.checkForMutatingParents(file.actual(), file.user());
            this.incrementDirectoryUsageCount(file.actual().parent());
            return this.fileSystem().convertToReading(file);
        }

        protected final void incrementDirectoryUsageCount(ADirectory directory) {
            ADirectory actual = ADirectory.actual(directory);
            DirEntry entry = (DirEntry)this.usedDirectories.get((Object)actual);
            if (entry == null) {
                entry = this.addUsedDirectoryEntry(actual);
                if (actual.parent() != null) {
                    this.incrementDirectoryUsageCount(actual.parent());
                }
            }
            ++entry.usingChildCount;
        }

        private DirEntry addUsedDirectoryEntry(ADirectory actual) {
            DirEntry entry = new DirEntry(actual);
            this.usedDirectories.add((Object)actual, (Object)entry);
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AReadableFile downgrade(AWritableFile file) {
            Object object = this.mutex();
            synchronized (object) {
                file.validateIsNotRetired();
                AFile actual = AFile.actual(file);
                FileEntry e = (FileEntry)this.fileUsers.get((Object)actual);
                if (e == null) {
                    throw new IllegalStateException("File not registered as used: " + file.toPathString());
                }
                AReadableFile wrapper = this.convertToReading(file);
                e.add(wrapper);
                e.exclusive = null;
                return wrapper;
            }
        }

        protected final AReadableFile internalUseReading(AFile file, Object user, ConflictHandler conflictHandler) {
            AReadableFile wrapper;
            AFile actual = AFile.actual(file);
            FileEntry e = (FileEntry)this.fileUsers.get((Object)actual);
            if (e == null) {
                return this.registerReading(this.createFileEntry(actual), actual, user);
            }
            if (e.exclusive != null) {
                if (e.exclusive.user() == user) {
                    return e.exclusive;
                }
                conflictHandler.handleSharedAttemptExclusiveUserConflict(actual, user, e);
            }
            if ((wrapper = e.getForUser(user)) == null) {
                wrapper = this.registerReading(e, actual, user);
            }
            return wrapper;
        }

        protected final AWritableFile internalUseWriting(AFile file, Object user, ConflictHandler conflictHandler) {
            AFile actual = AFile.actual(file);
            FileEntry e = (FileEntry)this.fileUsers.get((Object)actual);
            if (e == null) {
                this.createFileEntry((AFile)actual).exclusive = this.registerWriting(actual, user);
                return this.createFileEntry((AFile)actual).exclusive;
            }
            if (e.exclusive != null) {
                if (e.exclusive.user() == user) {
                    return e.exclusive;
                }
                conflictHandler.handleExclusiveAttemptConflict(actual, user, e);
                return null;
            }
            if (e.hasSharedUsers()) {
                AReadableFile soleUserFile = e.getIfSoleUser(user);
                if (soleUserFile != null) {
                    e.exclusive = this.convertToWriting(soleUserFile);
                    e.removeForUser(user);
                } else {
                    conflictHandler.handleExclusiveAttemptSharedUsersConflict(actual, user, e);
                }
            } else {
                e.exclusive = this.registerWriting(actual, user);
            }
            return e.exclusive;
        }

        static String toStringWithIdentity(Object o) {
            return o == null ? null : "(" + XChars.systemString((Object)o) + ") " + o.toString();
        }

        private AWritableFile registerWriting(AFile actual, Object user) {
            this.checkForMutatingParents(actual, user);
            this.incrementDirectoryUsageCount(actual.parent());
            return this.fileSystem().wrapForWriting(actual, user);
        }

        private AWritableFile convertToWriting(AReadableFile file) {
            this.checkForMutatingParents(file.actual(), file.user());
            this.incrementDirectoryUsageCount(file.actual().parent());
            return this.fileSystem().convertToWriting(file);
        }

        private void checkForMutatingParents(AFile actual, Object user) {
            for (ADirectory p = actual.parent(); p != null; p = p.parent()) {
                Thread mutatingThread = (Thread)this.mutatingDirectories.get((Object)p);
                if (mutatingThread == null || mutatingThread == user) continue;
                throw new AfsExceptionMutation("File \"" + actual.toPathString() + "\" cannot be accessed by user \"" + user + "\" since directory \"" + p.toPathString() + "\" is in the process of being changed by user thread \"" + mutatingThread + "\".");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean unregister(AReadableFile file) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalUnregister(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean unregister(AWritableFile file) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalUnregister(file);
            }
        }

        protected boolean internalUnregister(AReadableFile file) {
            AFile actual = file.actual();
            FileEntry e = (FileEntry)this.fileUsers.get((Object)actual);
            if (e == null) {
                return false;
            }
            if (!this.internalUnregister(file, e)) {
                return false;
            }
            this.decrementDirectoryUsageCount(actual.parent());
            Default.optimizeMemoryUsage(this.fileUsers);
            return true;
        }

        private static void optimizeMemoryUsage(OptimizableCollection collection) {
            if ((collection.size() & 0x7FL) != 0L) {
                return;
            }
            collection.optimize();
        }

        protected void decrementDirectoryUsageCount(ADirectory directory) {
            ADirectory actual = ADirectory.actual(directory);
            DirEntry entry = this.getNonNullDirEntry(actual);
            if (--entry.usingChildCount == 0) {
                if (actual.parent() != null) {
                    this.decrementDirectoryUsageCount(actual.parent());
                }
                this.usedDirectories.removeFor((Object)actual);
                Default.optimizeMemoryUsage(this.usedDirectories);
            }
        }

        protected final DirEntry getNonNullDirEntry(ADirectory directory) {
            ADirectory actual = ADirectory.actual(directory);
            DirEntry entry = (DirEntry)this.usedDirectories.get((Object)actual);
            if (entry == null) {
                throw new IllegalStateException("Directory not registered as used: " + directory.toPathString());
            }
            return entry;
        }

        protected boolean internalUnregister(AReadableFile file, FileEntry entry) {
            if (file.isRetired()) {
                return false;
            }
            if (file instanceof AWritableFile) {
                this.unregisterExclusive((AWritableFile)file, entry);
            } else {
                this.unregisterShared(file, entry);
            }
            return true;
        }

        protected void unregisterShared(AReadableFile file, FileEntry entry) {
            file.retire();
            if (entry.removeShared(file) && entry.exclusive == null) {
                this.fileUsers.removeFor((Object)file.actual());
            }
        }

        protected void unregisterExclusive(AWritableFile file, FileEntry entry) {
            this.validateExclusive(file, entry);
            this.removeExclusive(file, entry);
        }

        protected void validateExclusive(AWritableFile file, FileEntry entry) {
            if (entry.exclusive == file) {
                return;
            }
            Default.throwUnregisteredException(file, entry);
        }

        protected static void throwUnregisteredException(AReadableFile file, FileEntry entry) {
            throw new AfsExceptionConsistency("Inconsistency detected: attempting to unregister non-retired but not registered file \"" + file + "\".");
        }

        protected void removeExclusive(AWritableFile file, FileEntry entry) {
            entry.exclusive = null;
            this.fileUsers.removeFor((Object)file.actual());
            file.retire();
        }

        static interface ConflictHandler {
            public void handleSharedAttemptExclusiveUserConflict(AFile var1, Object var2, FileEntry var3);

            public void handleExclusiveAttemptConflict(AFile var1, Object var2, FileEntry var3);

            public void handleExclusiveAttemptSharedUsersConflict(AFile var1, Object var2, FileEntry var3);
        }

        static final class FileEntry {
            private static final AReadableFile[] NO_SHARED_USERS = new AReadableFile[0];
            private AReadableFile[] sharedUsers = NO_SHARED_USERS;
            AWritableFile exclusive;

            FileEntry() {
            }

            final boolean hasSharedUsers() {
                return this.sharedUsers != NO_SHARED_USERS;
            }

            final AReadableFile getIfSoleUser(Object user) {
                return this.sharedUsers.length == 1 && this.sharedUsers[0].user() == user ? this.sharedUsers[0] : null;
            }

            final AReadableFile getForUser(Object user) {
                for (AReadableFile f : this.sharedUsers) {
                    if (f.user() != user) continue;
                    return f;
                }
                return null;
            }

            private int indexForUser(Object user) {
                return XArrays.indexOf((Object)user, (Object[])this.sharedUsers, FileEntry::isForUser);
            }

            static final boolean isForUser(AReadableFile file, Object user) {
                return file.user() == user;
            }

            final void add(AReadableFile file) {
                if (this.sharedUsers == NO_SHARED_USERS) {
                    this.sharedUsers = (AReadableFile[])X.Array((Object)file);
                    return;
                }
                if (this.getForUser(file.user()) == null) {
                    this.sharedUsers = (AReadableFile[])XArrays.add((Object[])this.sharedUsers, (Object)file);
                    return;
                }
            }

            final boolean removeShared(AReadableFile file) {
                if (this.sharedUsers.length == 1 && this.sharedUsers[0] == file) {
                    this.sharedUsers = NO_SHARED_USERS;
                    return true;
                }
                int index = this.indexForUser(file.user());
                if (index < 0) {
                    Default.throwUnregisteredException(file, this);
                }
                if (this.sharedUsers[index] != file) {
                    throw new AfsExceptionConsistency("Inconsistency detected: to be removed file \"" + file + "\" is not the same as the one contained for the same user: \"" + this.sharedUsers[index] + "\".");
                }
                this.removeIndex(index);
                return false;
            }

            final void removeForUser(Object user) {
                int index = this.indexForUser(user);
                if (index < 0) {
                    return;
                }
                this.removeIndex(index);
            }

            private void removeIndex(int index) {
                this.sharedUsers = index == 0 && this.sharedUsers.length == 1 ? NO_SHARED_USERS : (AReadableFile[])XArrays.remove((Object[])this.sharedUsers, (int)index);
            }
        }

        static final class DirEntry {
            final ADirectory directory;
            int usingChildCount;

            DirEntry(ADirectory directory) {
                this.directory = directory;
            }
        }
    }

    @FunctionalInterface
    public static interface Creator {
        public AccessManager createAccessManager(AFileSystem var1);
    }
}

