/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.process.desktop;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.werp.domain.angebot.Angebotsdaten;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Baugruppe;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.artikel.news.ArtikelNeuErstellt;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fcckliste;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklistenbehaftet;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.Projektnummer;
import com.schneide.werp.domain.projekt.Projektst\u00fccklisteneintrag;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.gui.component.AuswahlEinerDatei;
import com.schneide.werp.periphery.datenimport.Datenimport;
import com.schneide.werp.process.generic.WerpProcess;
import com.schneide.werp.produktion.convert.AngebotsextraktEinlesen;
import com.schneide.werp.produktion.model.repository.BeschreibbaresArtikelRepository;
import com.schneide.werp.produktion.model.repository.BeschreibbaresProjektRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ProjektImportieren
extends WerpProcess {
    public ProjektImportieren(WerpSession session) {
        super(session);
    }

    public void activateFor(BeschreibbaresArtikelRepository artikel, BeschreibbaresProjektRepository projekte, Anwendungsumgebung umgebung) throws IOException {
        Optional maybeImport = umgebung.datenimport();
        if (maybeImport.isEmpty()) {
            return;
        }
        Datenimport importierung = (Datenimport)maybeImport.get();
        Optional maybeQuelldatei = new AuswahlEinerDatei(new File("."), "Angebotsextrakt (*.csv)", new String[]{".csv"}).selectFile((WerpSession)this.session());
        if (maybeQuelldatei.isEmpty()) {
            return;
        }
        AngebotsextraktEinlesen einlesen = new AngebotsextraktEinlesen(importierung.ausCSV());
        Optional<Angebotsdaten> maybeAngebot = einlesen.ausDatei((VirtualFile)maybeQuelldatei.get());
        if (maybeAngebot.isEmpty()) {
            this.getLogger().error((Object)"Konnte Angebotsdaten nicht extrahieren.");
            return;
        }
        Angebotsdaten angebot = maybeAngebot.get();
        this.getLogger().debug((Object)("Angebot eingelesen: " + angebot.nummer().alsText() + " f\u00fcr " + angebot.auftrag().alsText() + " mit " + IterableUtil.getSizeFor((Iterable)angebot.positionen()) + " Positionen."));
        ArrayList neuErstellt = new ArrayList();
        Subscriber neueArtikel = new Subscriber(ArtikelNeuErstellt.class, n -> neuErstellt.add(n.artikel()));
        Subscriber.attach((Subscriber)neueArtikel, (EventBus)this.applicationBus());
        Iterable<Angebotsektion> sektionen = this.erstelleAlleProjektbezogenenArtikelF\u00fcr(angebot.auftrag(), angebot.positionen(), artikel);
        St\u00fcckliste.EingeleseneSt\u00fcckliste st\u00fccklistenergebnis = St\u00fcckliste.aus((Iterable)angebot.positionen(), (ArtikelRepository)artikel, Projektst\u00fccklisteneintrag::new);
        neueArtikel.stop();
        this.getLogger().info((Object)("Es wurden " + neuErstellt.size() + " Artikel neu erstellt:"));
        for (Artikel each : neuErstellt) {
            this.getLogger().info((Object)((each.istBaugruppe() ? "Baugruppe" : "Einzelteil") + " " + each.druckbareBeschreibung()));
        }
        Iterable nichtZugeordnet = st\u00fccklistenergebnis.nichtZugeordneteArtikel();
        if (IterableUtil.hasContent((Iterable)nichtZugeordnet)) {
            this.getLogger().warn((Object)"Die folgenden Artikel konnten nicht zugeordnet werden:");
            DirectChunkBuffer liste = new DirectChunkBuffer((CharSequence)"\n");
            for (St\u00fcckliste.NichtZugeordneterArtikel each : nichtZugeordnet) {
                String beschreibung = each.position().position().alsText() + ": " + each.nichtZugeordnet().alsText();
                this.getLogger().warn((Object)beschreibung);
                liste.add((CharSequence)beschreibung);
            }
            DefaultDialog.showInformationDialog((WindowStack)((WerpSession)this.session()).getMainWindowStack(), (I18Nable)new I18NKey("Nicht importierbare Artikel"), (I18Nable)new I18NKey("Die folgenden Artikel konnten nicht zugeordnet werden:\n" + String.valueOf(liste)));
        }
        St\u00fcckliste projektst\u00fcckliste = st\u00fccklistenergebnis.st\u00fcckliste();
        this.getLogger().debug((Object)("Projektst\u00fcckliste mit " + projektst\u00fcckliste.size() + " Positionen bekannter Artikel erstellt."));
        for (St\u00fcckliste.NichtZugeordneterArtikel each : projektst\u00fcckliste.eintr\u00e4ge()) {
            this.getLogger().debug((Object)(each.anzahl() + "x " + each.artikelreferenz().artikelnummerMitRevisionAlsAnzeigetext()));
        }
        ArrayList<Projektst\u00fccklisteneintrag> hauptpositionen = new ArrayList<Projektst\u00fccklisteneintrag>();
        int aktuellePosition = 1;
        for (Angebotsektion each : sektionen) {
            Angebotsdaten.Angebotsposition hauptposition = each.haupt();
            Optional maybeArtikel = artikel.aktuelleRevisionF\u00fcr(hauptposition.artikelnummer().alsArtikelnummer());
            if (maybeArtikel.isEmpty()) {
                this.getLogger().warn((Object)("Kann den Hauptpositionsartikel " + hauptposition.artikelnummer().alsText() + " nicht finden."));
                continue;
            }
            Projektst\u00fccklisteneintrag eintrag = new Projektst\u00fccklisteneintrag(aktuellePosition, hauptposition.anzahl(), (Artikel)maybeArtikel.get());
            hauptpositionen.add(eintrag);
            ++aktuellePosition;
        }
        Projekt projekt = new Projekt(new Projektnummer(angebot.auftrag().alsText()), angebot.kunde().alsText(), angebot.beschreibung().alsText(), IterableUtil.asList((Iterable)angebot.weitereAngaben()), hauptpositionen);
        projekte.speichere(projekt);
        this.getLogger().debug((Object)St\u00fccklistenbehaftet.alsText((St\u00fccklistenbehaftet)projekt));
        DefaultDialog.showInformationDialog((WindowStack)((WerpSession)this.session()).getMainWindowStack(), (I18Nable)new I18NKey(""), (I18Nable)new I18NKey("Projekt " + projekt.nummer().alsText() + " mit " + projektst\u00fcckliste.size() + " Einzelpositionen in " + hauptpositionen.size() + " Sektionen importiert."));
        this.getLogger().info((Object)"Import abgeschlossen.");
    }

    private Iterable<Angebotsektion> erstelleAlleProjektbezogenenArtikelF\u00fcr(Angebotsdaten.Auftragnummer auftrag, Iterable<Angebotsdaten.Angebotsposition> positionen, BeschreibbaresArtikelRepository artikel) {
        Iterable<Angebotsektion> sektionen = this.unterteileInSektionen(positionen);
        for (Angebotsektion each : sektionen) {
            if (!this.istAuftragspezifisch(each.haupt(), auftrag)) continue;
            this.getLogger().debug((Object)("Der Artikel " + each.haupt().artikelnummer().alsText() + " ist eine Projektbaugruppe und wird neu erstellt."));
            Baugruppe neu = new Baugruppe(each.haupt().artikelnummer().alsArtikelnummer(), each.haupt().beschreibung(), Artikelrevision.erste, "");
            int position = 1;
            for (Angebotsdaten.Angebotsposition unterpunkt : each.untergeordnet()) {
                Optional<Artikel<?>> maybeArtikel = this.erstelleOderFinde(unterpunkt, auftrag, artikel);
                if (!maybeArtikel.isPresent()) continue;
                neu.f\u00fcgeInSt\u00fccklisteEin(position, unterpunkt.anzahl(), maybeArtikel.get());
                ++position;
            }
            try {
                artikel.speichere((Artikel<?>)neu);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"Kann die Baugruppe nicht speichern.", (Throwable)e);
            }
        }
        return sektionen;
    }

    private Optional<Artikel<?>> erstelleOderFinde(Angebotsdaten.Angebotsposition unterpunkt, Angebotsdaten.Auftragnummer auftrag, BeschreibbaresArtikelRepository artikel) {
        Optional maybeVorhanden = artikel.aktuelleRevisionF\u00fcr(unterpunkt.artikelnummer().alsArtikelnummer());
        if (this.mussKonstruiertWerden(unterpunkt)) {
            return this.neuZuKonstruierendenArtikelAnlegen(unterpunkt, artikel);
        }
        if (this.istAuftragspezifisch(unterpunkt, auftrag)) {
            return this.auftragsspezifischenArtikelAnlegen(unterpunkt, auftrag, artikel, maybeVorhanden);
        }
        return maybeVorhanden;
    }

    private boolean mussKonstruiertWerden(Angebotsdaten.Angebotsposition unterpunkt) {
        return unterpunkt.artikelnummer().alsArtikelnummer().mussNochKonstruiertWerden();
    }

    private Optional<Artikel<?>> neuZuKonstruierendenArtikelAnlegen(Angebotsdaten.Angebotsposition unterpunkt, BeschreibbaresArtikelRepository artikel) {
        this.getLogger().debug((Object)("Der Artikel " + unterpunkt.artikelnummer().alsText() + " muss erst noch konstruiert werden und wird neu erstellt."));
        Baugruppe neu = new Baugruppe(unterpunkt.artikelnummer().alsArtikelnummer(), unterpunkt.beschreibung(), Artikelrevision.erste, "Erf\u00fcllungsweg_SO_10");
        this.speichereNeuen(artikel, (Artikel<?>)neu);
        return Optional.of(neu);
    }

    private Optional<Artikel<?>> auftragsspezifischenArtikelAnlegen(Angebotsdaten.Angebotsposition unterpunkt, Angebotsdaten.Auftragnummer auftrag, BeschreibbaresArtikelRepository artikel, Optional<Artikel<?>> maybeVorhanden) {
        this.getLogger().debug((Object)("Der Artikel " + unterpunkt.artikelnummer().alsText() + " ist ein Projekteinzelteil und wird neu erstellt."));
        Einzelteil neu = null;
        if (maybeVorhanden.isPresent()) {
            Artikel<?> vorhanden = maybeVorhanden.get();
            this.getLogger().debug((Object)("Die Vorlage des Artikels ist bereits vorhanden und wird verwendet: " + vorhanden.artikelnummerMitRevision()));
            Artikelnummer bisher = vorhanden.artikelnummer();
            Artikelnummer neueNummer = bisher.spezifischF\u00fcr(auftrag);
            neu = vorhanden.kopieMit(neueNummer);
        } else {
            this.getLogger().debug((Object)"F\u00fcr den Artikel ist keine Vorlage vorhanden. Er wird komplett neu erstellt.");
            neu = new Einzelteil(unterpunkt.artikelnummer().alsArtikelnummer(), unterpunkt.beschreibung(), Artikelrevision.erste, "");
        }
        this.speichereNeuen(artikel, (Artikel<?>)neu);
        return Optional.of(neu);
    }

    private void speichereNeuen(BeschreibbaresArtikelRepository artikel, Artikel<?> neu) {
        try {
            artikel.speichere(neu);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Kann den neuen Artikel " + neu.artikelnummerMitRevision() + " nicht speichern."), (Throwable)e);
        }
    }

    protected boolean istAuftragspezifisch(Angebotsdaten.Angebotsposition position, Angebotsdaten.Auftragnummer auftrag) {
        if (position.anpassung()) {
            return true;
        }
        return position.artikelnummer().alsText().startsWith(auftrag.alsText());
    }

    protected Iterable<Angebotsektion> unterteileInSektionen(Iterable<Angebotsdaten.Angebotsposition> positionen) {
        ArrayList<Angebotsektion> result = new ArrayList<Angebotsektion>();
        Optional<Angebotsektion> aktuelleSektion = Optional.empty();
        for (Angebotsdaten.Angebotsposition each : positionen) {
            if (each.position().istHauptposition()) {
                Angebotsektion neu = new Angebotsektion(each);
                result.add(neu);
                aktuelleSektion = Optional.of(neu);
                continue;
            }
            aktuelleSektion.ifPresent(s -> s.f\u00fcgeHinzu(each));
        }
        return result;
    }

    protected static class Angebotsektion {
        private final Angebotsdaten.Angebotsposition haupt;
        private final List<Angebotsdaten.Angebotsposition> untergeordnet;

        public Angebotsektion(Angebotsdaten.Angebotsposition haupt) {
            this.haupt = haupt;
            this.untergeordnet = new ArrayList<Angebotsdaten.Angebotsposition>();
        }

        public Angebotsdaten.Angebotsposition haupt() {
            return this.haupt;
        }

        public Iterable<Angebotsdaten.Angebotsposition> untergeordnet() {
            return this.untergeordnet;
        }

        public void f\u00fcgeHinzu(Angebotsdaten.Angebotsposition darunter) {
            this.untergeordnet.add(darunter);
        }
    }
}

