/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.process.desktop;

import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsliste;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklistenbehaftet;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.material.Abmessung;
import com.schneide.werp.domain.material.Blechabmessung;
import com.schneide.werp.domain.material.Blecheinsatz;
import com.schneide.werp.domain.material.Masse;
import com.schneide.werp.domain.material.Material;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.ProjektRepository;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.process.generic.WerpProcess;
import com.schneide.werp.produktion.gui.dialog.Projektauswahldialog;
import com.schneide.werp.produktion.output.BlechberichtAlsPDF;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class BlechberichtErstellen
extends WerpProcess {
    public BlechberichtErstellen(WerpSession session) {
        super(session);
    }

    public void activateFor(ProjektRepository projekte, ArtikelRepository artikel, Erf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Projektauswahldialog projektwahl = new Projektauswahldialog((WerpSession)this.session(), projekte);
        Optional maybeProjekt = projektwahl.showDialog();
        if (maybeProjekt.isEmpty()) {
            this.getLogger().info((Object)"Kein Projekt ausgew\u00e4hlt.");
            return;
        }
        Projekt zuProduzieren = (Projekt)maybeProjekt.get();
        this.getLogger().debug((Object)St\u00fccklistenbehaftet.alsText((St\u00fccklistenbehaftet)zuProduzieren));
        Produktionsliste produktionsliste = Produktionsliste.f\u00fcr((Projekt)zuProduzieren);
        HashMap<Material, Map> alleBleche = new HashMap<Material, Map>();
        for (Produktionslisteneintrag each : produktionsliste.hierarchieAlsListe()) {
            Map eintr\u00e4ge2;
            Artikel derArtikel = each.artikel().spezifikation();
            Optional maybeBlech = derArtikel.abmessung().flatMap(Abmessung::f\u00fcrBlech);
            if (maybeBlech.isEmpty()) {
                this.getLogger().debug((Object)("Kein Blech: " + String.valueOf(derArtikel)));
                continue;
            }
            Blechabmessung blech = (Blechabmessung)maybeBlech.get();
            Optional maybeMaterial = derArtikel.material();
            if (maybeMaterial.isEmpty()) {
                this.getLogger().warn((Object)("Unbekanntes Material f\u00fcr " + String.valueOf(derArtikel)));
                continue;
            }
            Material material2 = (Material)maybeMaterial.get();
            Optional maybeMasse = derArtikel.masse();
            if (maybeMasse.isEmpty()) {
                this.getLogger().warn((Object)("Unbekannte Masse f\u00fcr " + String.valueOf(derArtikel)));
                continue;
            }
            Masse masse = (Masse)maybeMasse.get();
            Blechabmessung.Blechdicke dicke = blech.dicke();
            Blecheinsatz einsatz = new Blecheinsatz(each.koordinate(), derArtikel, each.gesamtanzahl(), blech.breite(), blech.l\u00e4nge(), masse);
            if (!alleBleche.containsKey(material2)) {
                alleBleche.put(material2, new HashMap());
            }
            if (!(eintr\u00e4ge2 = (Map)alleBleche.get(material2)).containsKey(dicke)) {
                eintr\u00e4ge2.put(dicke, new ArrayList());
            }
            ((List)eintr\u00e4ge2.get(dicke)).add(einsatz);
        }
        alleBleche.forEach((material, eintr\u00e4ge) -> {
            System.out.println("### Material " + material.bezeichnung() + ":");
            eintr\u00e4ge.forEach((dicke, eins\u00e4tze) -> {
                System.out.println(" ## Dicke " + dicke.bezeichnung() + ":");
                long fl\u00e4chensumme = 0L;
                BigDecimal massensumme = BigDecimal.ZERO;
                for (Blecheinsatz each : eins\u00e4tze) {
                    System.out.println("  # Einsatz: " + String.valueOf(each));
                    fl\u00e4chensumme += each.gesamtfl\u00e4che();
                    massensumme = massensumme.add(each.gesamtmasse());
                }
                double fl\u00e4cheInQuadratMetern = (double)fl\u00e4chensumme / 1000.0 / 1000.0;
                System.out.println("--> Gesamtfl\u00e4che [m\u00b2]: " + this.nachkommastellen(3).format(fl\u00e4cheInQuadratMetern));
                System.out.println("--> Gesamtmasse [kg]: " + this.nachkommastellen(1).format(massensumme));
            });
        });
        umgebung.dokumenterstellung().ifPresent(de -> {
            Report pdf = new BlechberichtAlsPDF().f\u00fcr(zuProduzieren.produktionsnummer(), zuProduzieren.beschreibung(), alleBleche);
            Dokumenterstellung.Dokumentanzeige anzeige = Dokumenterstellung.speichere((Report)pdf, (String)"dokumente/berichte/blech", (String)(Dateiname.g\u00fcltigF\u00fcr((String)zuProduzieren.nummer().alsText()) + "-blechbericht.pdf"), (Dokumenterstellung)de);
            anzeige.show();
        });
    }

    private DecimalFormat nachkommastellen(int stellen) {
        DecimalFormat formatierung = new DecimalFormat("0." + "0".repeat(stellen), DecimalFormatSymbols.getInstance(Locale.GERMAN));
        return formatierung;
    }
}

