/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.process.desktop;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.optional.OptionalUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.gui.component.AuswahlEinerDatei;
import com.schneide.werp.periphery.datenimport.Datenimport;
import com.schneide.werp.process.generic.WerpProcess;
import com.schneide.werp.produktion.convert.Automatisierungsst\u00fccklistenEinlesen;
import com.schneide.werp.produktion.model.repository.BeschreibbaresArtikelRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;

public class ArtikelF\u00fcrAutomatisierungImportieren
extends WerpProcess {
    public ArtikelF\u00fcrAutomatisierungImportieren(WerpSession session) {
        super(session);
    }

    public void activateFor(BeschreibbaresArtikelRepository artikel, ArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Iterable<VirtualFile> toImport = this.selectedFiles();
        this.importierenVon(toImport, artikel, arbeitsschritte, umgebung);
    }

    public void importierenVon(Iterable<VirtualFile> dateien, BeschreibbaresArtikelRepository artikel, ArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Optional maybeImport = umgebung.datenimport();
        if (maybeImport.isEmpty()) {
            return;
        }
        Datenimport importierung = (Datenimport)maybeImport.get();
        Automatisierungsst\u00fccklistenEinlesen einlesen = new Automatisierungsst\u00fccklistenEinlesen(arbeitsschritte, importierung.ausExcel());
        Iterable<Artikel<?>> neuEingelesen = this.einlesenAus(dateien, einlesen);
        neuEingelesen.forEach(a -> {
            try {
                artikel.speichere((Artikel<?>)a);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Konnte Artikel " + a.artikelnummerMitRevision() + " nicht speichern."), (Throwable)e);
            }
        });
        Iterable nichtAufl\u00f6sbar = artikel.alleReferenzenAufl\u00f6sen();
        String aufl\u00f6sungsergebnis = IterableUtil.isEmpty((Iterable)nichtAufl\u00f6sbar) ? "Alle Referenzen aufgel\u00f6st." : IterableUtil.getSizeFor((Iterable)nichtAufl\u00f6sbar) + " Referenzen nicht aufl\u00f6sbar.";
        this.meldeInStatuszeile(IterableUtil.getSizeFor(neuEingelesen) + " Artikel importiert. " + aufl\u00f6sungsergebnis);
        this.getLogger().info((Object)"Import abgeschlossen.");
    }

    private Iterable<Artikel<?>> einlesenAus(Iterable<VirtualFile> toImport, Automatisierungsst\u00fccklistenEinlesen einlesen) {
        ArrayList neuEingelesen = new ArrayList();
        for (VirtualFile each : toImport) {
            this.meldeInStatuszeile("Lese Datei " + each.getName() + " ein.");
            try {
                Iterable<Artikel<?>> alleEingelesenenArtikel = einlesen.ausDatei(each);
                CollectionUtil.addAll(neuEingelesen, alleEingelesenenArtikel);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"Fehler beim Import.", (Throwable)e);
            }
        }
        this.getLogger().info((Object)(neuEingelesen.size() + " Artikel eingelesen."));
        return neuEingelesen;
    }

    private Iterable<VirtualFile> selectedFiles() {
        AuswahlEinerDatei auswahl = new AuswahlEinerDatei(new File("."), "Komponentendefinition (*.xlsx)", new String[]{".xlsx"});
        return OptionalUtil.asIterable((Optional)auswahl.selectFile((WerpSession)this.session()));
    }
}

