/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.output;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.maths.Percent;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.zusammenfassung.Laufzettel;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.publishing.Headline;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.publishing.ReportEntry;
import com.schneide.werp.domain.publishing.ReportLine;
import com.schneide.werp.domain.publishing.ReportSection;
import com.schneide.werp.domain.publishing.SectionClosure;
import com.schneide.werp.domain.publishing.detail.Seitengr\u00f6\u00dfe;
import com.schneide.werp.produktion.engine.qrcode.QRCodeF\u00fcr;
import com.schneide.werp.produktion.output.generic.AusgabeAlsPDF;
import java.util.List;

public class LaufzettelAlsPDF
extends AusgabeAlsPDF {
    public Report f\u00fcr(Produktionsnummer produktion, String bezeichnung, Iterable<? extends Laufzettel> laufzettel) {
        Report dokument = this.neuerReportMit(Seitengr\u00f6\u00dfe.DIN_A4, Percent.fromFactor((double)0.75));
        SectionClosure abschluss = IterableUtil.getSizeFor(laufzettel) == 1 ? SectionClosure.none : SectionClosure.pageBreak;
        for (Laufzettel laufzettel2 : laufzettel) {
            Iterable<ReportSection> sektionen = this.erstelleF\u00fcr("Produktion " + produktion.alsText() + ": " + bezeichnung, laufzettel2, IterableUtil.lastOf(laufzettel) == laufzettel2 ? SectionClosure.none : abschluss);
            sektionen.forEach(arg_0 -> ((Report)dokument).add(arg_0));
        }
        return dokument;
    }

    private Iterable<ReportSection> erstelleF\u00fcr(String titel, Laufzettel laufzettel, SectionClosure abschluss) {
        ReportSection code = new ReportSection(SectionClosure.none);
        this.qrCodeIn(code, () -> QRCodeF\u00fcr.auftr\u00e4ge(laufzettel.schritte()));
        ReportSection kopfteil = new ReportSection(SectionClosure.boldLine);
        kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{titel}));
        kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{" "}));
        kopfteil.add((ReportEntry)Headline.forReport((String)laufzettel.titel()));
        Iterable vorg\u00e4nger = laufzettel.vorg\u00e4nger();
        if (!IterableUtil.isEmpty((Iterable)vorg\u00e4nger)) {
            kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Ben\u00f6tigt:"}));
            for (Laufzettel each : vorg\u00e4nger) {
                kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"- " + each.identifier()}));
            }
        }
        ReportSection mittelteil = new ReportSection(SectionClosure.line);
        for (Arbeitsauftrag each : laufzettel.schritte()) {
            mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"[   ] " + each.identifikation().alsText() + " f\u00fcr Pos. " + each.listenkoordinate().alsText()}));
            mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"      " + each.t\u00e4tigkeitsbeschreibung() + each.kommentar() + " f\u00fcr:"}));
            mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"      " + each.anzahl() + "x " + each.f\u00fcrArtikel().artikelnummerMitRevision() + ": " + each.f\u00fcrArtikel().bezeichnung()}));
        }
        ReportSection fu\u00dfteil = new ReportSection(abschluss);
        Iterable nachfolger = laufzettel.nachfolger();
        if (!IterableUtil.isEmpty((Iterable)nachfolger)) {
            fu\u00dfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Wird ben\u00f6tigt von:"}));
            for (Laufzettel each : nachfolger) {
                fu\u00dfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"- " + each.identifier()}));
            }
        }
        return List.of(code, kopfteil, mittelteil, fu\u00dfteil);
    }
}

