/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.output;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.maths.Percent;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.publishing.Headline;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.publishing.ReportEntry;
import com.schneide.werp.domain.publishing.ReportLine;
import com.schneide.werp.domain.publishing.ReportSection;
import com.schneide.werp.domain.publishing.SectionClosure;
import com.schneide.werp.domain.publishing.detail.Seitengr\u00f6\u00dfe;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.engine.qrcode.QRCodeF\u00fcr;
import com.schneide.werp.produktion.output.generic.AusgabeAlsPDF;
import java.util.Collections;
import java.util.List;

public class Arbeitsauftr\u00e4geAlsPDF
extends AusgabeAlsPDF {
    public Report f\u00fcr(String bezeichnung, Iterable<Ausdruckangaben> auftr\u00e4ge) {
        Report dokument = this.neuerReportMit(Seitengr\u00f6\u00dfe.DIN_A5, Percent.fromFactor((double)0.5));
        SectionClosure abschluss = IterableUtil.getSizeFor(auftr\u00e4ge) == 1 ? SectionClosure.none : SectionClosure.pageBreak;
        for (Ausdruckangaben each : auftr\u00e4ge) {
            Iterable<ReportSection> sektionen = this.erstelleF\u00fcr("Produktion " + each.auftrag().identifikation().projekt().alsText() + ": " + bezeichnung, each, IterableUtil.lastOf(auftr\u00e4ge) == each ? SectionClosure.none : abschluss);
            sektionen.forEach(arg_0 -> ((Report)dokument).add(arg_0));
        }
        return dokument;
    }

    private Iterable<ReportSection> erstelleF\u00fcr(String titel, Ausdruckangaben angaben, SectionClosure abschluss) {
        Arbeitsauftrag auftrag = angaben.auftrag();
        ReportSection code = new ReportSection(SectionClosure.none);
        this.qrCodeIn(code, () -> QRCodeF\u00fcr.auftrag(auftrag));
        ReportSection kopfteil = new ReportSection(SectionClosure.boldLine);
        kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{titel}));
        kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{" "}));
        String zusatzangabe = auftrag.t\u00e4tigkeit().istVorziehbar() ? " ".repeat(5) + "(vorziehbar)" : "";
        kopfteil.add((ReportEntry)Headline.forReport((String)(auftrag.identifikation().alsText() + zusatzangabe)));
        for (ArbeitsauftragIdentifikation vorarbeit : auftrag.vorarbeiten()) {
            kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"ben\u00f6tigt: " + vorarbeit.alsText()}));
        }
        ReportSection mittelteil = new ReportSection(SectionClosure.line);
        mittelteil.add((ReportEntry)Headline.forSection((String)auftrag.t\u00e4tigkeitsbeschreibung()));
        mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Anzahl: " + auftrag.anzahl()}));
        mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Artikel: " + auftrag.f\u00fcrArtikel().artikelnummerMitRevision()}));
        mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Bezeichnung: " + auftrag.f\u00fcrArtikel().benennung()}));
        mittelteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Listenposition: " + auftrag.listenkoordinate().alsText()}));
        ReportSection fu\u00dfteil = new ReportSection(abschluss);
        String arbeitsergebnis = (auftrag.istLetzterAufErf\u00fcllungsweg() ? "" : "Vorprodukt von ") + auftrag.f\u00fcrArtikel().artikelnummerMitRevision();
        fu\u00dfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"stellt bereit: " + arbeitsergebnis}));
        angaben.nachfolger().forEach(id -> fu\u00dfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{"wird ben\u00f6tigt von: " + id.alsText()})));
        return List.of(code, kopfteil, mittelteil, fu\u00dfteil);
    }

    public record Ausdruckangaben(Arbeitsauftrag auftrag, Iterable<ArbeitsauftragIdentifikation> nachfolger) {
        public static Ausdruckangaben ohneNachfolgerF\u00fcr(Arbeitsauftrag auftrag) {
            return new Ausdruckangaben(auftrag, Collections.emptyList());
        }

        public static Ausdruckangaben f\u00fcr(Arbeitsauftragdaten auftragdaten) {
            return new Ausdruckangaben(auftragdaten.auftrag(), (Iterable<ArbeitsauftragIdentifikation>)new TransformingIterable(aad -> aad.auftrag().identifikation(), auftragdaten.nacharbeiten()));
        }
    }
}

