/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.verzeichnis;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.lifecycle.Stoppable;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.Projektnummer;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ProjektDatenspeicherung;
import com.schneide.werp.produktion.model.repository.BeschreibbaresProjektRepository;
import java.io.IOException;
import java.util.Optional;

public class VerzeichnisbasiertesProjektRepository
extends LoggedObject
implements BeschreibbaresProjektRepository,
Stoppable {
    private final VirtualFile basisverzeichnis;
    private final ProjektDatenspeicherung persistence;
    private final ArtikelRepository artikel;

    public VerzeichnisbasiertesProjektRepository(VirtualFile basisverzeichnis, ProjektDatenspeicherung persistence, ArtikelRepository artikel) {
        this.basisverzeichnis = basisverzeichnis;
        this.persistence = persistence;
        this.artikel = artikel;
    }

    public void stop() {
        this.getLogger().info((Object)"Schlie\u00dfe den Projekt-Cache");
    }

    public void wiedereinlesenMit() {
    }

    public Iterable<Projekt> alle() {
        return new TransformingIterable(null, this.alleProjektdateien());
    }

    public Optional<Projekt> f\u00fcr(Projektnummer nummer) {
        VirtualFile zieldatei = this.zieldateiF\u00fcr(nummer);
        if (!zieldatei.isFile()) {
            return Optional.empty();
        }
        try {
            return this.persistence.ladeAus(zieldatei, this.artikel);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Kann das Projekt mit der Nummer " + String.valueOf(nummer) + " nicht laden."), (Throwable)e);
            return Optional.empty();
        }
    }

    public int anzahl() {
        return IterableUtil.getSizeFor(this.alleProjektdateien());
    }

    private Iterable<VirtualFile> alleProjektdateien() {
        return this.basisverzeichnis.listDirectory(new VirtualFileFilter(){

            public boolean accept(VirtualFile f) {
                return f.isFile() && f.getName().endsWith(VerzeichnisbasiertesProjektRepository.this.persistence.dateiendung());
            }
        });
    }

    public Optional<Projekt> anIndex(int index) {
        VirtualFile datei = (VirtualFile)IterableUtil.getElementAt((int)index, this.alleProjektdateien());
        try {
            return this.persistence.ladeAus(datei, this.artikel);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Fehler beim Einlesen einer Projektdatei.", (Throwable)e);
            return Optional.empty();
        }
    }

    protected boolean sollGespeichertWerden(Projekt projekt) {
        return this.f\u00fcr(projekt.nummer()).isEmpty();
    }

    @Override
    public void speichere(Projekt projekt) throws IOException {
        if (!this.sollGespeichertWerden(projekt)) {
            this.getLogger().info((Object)("Speichere " + String.valueOf(projekt) + " nicht nochmals, ist bereits vorhanden."));
            return;
        }
        VirtualFile zieldatei = this.zieldateiF\u00fcr(projekt.nummer());
        this.persistence.speichere(projekt, zieldatei);
    }

    private VirtualFile zieldateiF\u00fcr(Projektnummer projektnummer) {
        String dateiname = this.dateinameF\u00fcr(projektnummer);
        VirtualFile zieldatei = this.basisverzeichnis.getChild(dateiname);
        return zieldatei;
    }

    private String dateinameF\u00fcr(Projektnummer projektnummer) {
        return Dateiname.g\u00fcltigF\u00fcr((String)projektnummer.alsText()) + this.persistence.dateiendung();
    }
}

