/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.verzeichnis;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ProduktionsartikelDatenspeicherung;
import com.schneide.werp.produktion.model.repository.BeschreibbaresProduktionsartikelRepository;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;

public class VerzeichnisbasiertesProduktionsartikelRepository
extends LoggedObject
implements BeschreibbaresProduktionsartikelRepository {
    private final VirtualFile basisverzeichnis;
    private final ProduktionsartikelDatenspeicherung persistence;
    private final ArtikelRepository alleArtikel;

    public VerzeichnisbasiertesProduktionsartikelRepository(VirtualFile basisverzeichnis, ProduktionsartikelDatenspeicherung persistence, ArtikelRepository alleArtikel) {
        this.basisverzeichnis = basisverzeichnis;
        this.persistence = persistence;
        this.alleArtikel = alleArtikel;
    }

    public Optional<Produktionsartikel> f\u00fcr(Produktionskoordinate koordinate) {
        try {
            VirtualFile datei = this.zieldateiF\u00fcr(koordinate);
            if (!datei.isFile()) {
                return Optional.empty();
            }
            return this.persistence.ladeAus(datei, this.alleArtikel);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Produktionsartikel konnte wegen technischer Probleme nicht geladen werden.", (Throwable)e);
            return Optional.empty();
        }
    }

    public Stream<Produktionsartikel> alleF\u00fcr(Produktionsnummer projekt) {
        try {
            Iterable dateien = this.projektverzeichnisF\u00fcr(projekt).listAllFilesEndingOn(this.persistence.dateiendung());
            Stream.Builder result = Stream.builder();
            dateien.forEach(vf -> {
                try {
                    this.persistence.ladeAus(vf, this.alleArtikel).ifPresent(result::add);
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("Technischer Fehler beim Laden aus " + String.valueOf(vf)), (Throwable)e);
                }
            });
            return result.build();
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Technischer Fehler beim Laden aller Produktionsartikel", (Throwable)e);
            return Stream.empty();
        }
    }

    @Override
    public void speichere(Produktionsartikel neu) throws IOException {
        VirtualFile zieldatei = this.zieldateiF\u00fcr(neu.koordinate());
        this.persistence.speichere(neu, zieldatei);
    }

    protected VirtualFile zieldateiF\u00fcr(Produktionskoordinate identifikation) throws IOException {
        VirtualFile projektverzeichnis = this.projektverzeichnisF\u00fcr(identifikation.nummer());
        DirectChunkBuffer name = new DirectChunkBuffer((CharSequence)"-");
        identifikation.alsZahlenfolge().forEach(p -> name.add(p));
        return projektverzeichnis.getChild(Dateiname.g\u00fcltigF\u00fcr((String)name.asString()) + this.persistence.dateiendung());
    }

    protected VirtualFile projektverzeichnisF\u00fcr(Produktionsnummer projekt) throws IOException {
        VirtualFile projektverzeichnis = this.basisverzeichnis.subdirectory(Dateiname.g\u00fcltigF\u00fcr((String)projekt.alsText()));
        return projektverzeichnis;
    }
}

