/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.verzeichnis;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.lifecycle.Stoppable;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ArtikelDatenspeicherung;
import com.schneide.werp.produktion.model.repository.base.BeschreibbaresArtikelRepositoryBase;
import com.schneide.werp.produktion.model.repository.cache.ArtikelCache;
import java.io.IOException;
import java.util.Optional;

public class VerzeichnisbasiertesArtikelRepository
extends BeschreibbaresArtikelRepositoryBase
implements Stoppable {
    private final VirtualFile basisverzeichnis;
    private final ArtikelDatenspeicherung persistence;
    private final ArtikelCache cache;

    public VerzeichnisbasiertesArtikelRepository(VirtualFile basisverzeichnis, ArtikelDatenspeicherung persistence, EventBus applicationBus) {
        super(applicationBus);
        this.basisverzeichnis = basisverzeichnis;
        this.persistence = persistence;
        this.cache = new ArtikelCache();
        this.getLogger().debug((Object)(this.cache.anzahl() + " gecachte Artikel geladen."));
    }

    public void stop() {
        this.getLogger().info((Object)"Schlie\u00dfe den Artikel-Cache");
    }

    public void wiedereinlesenMit(ArbeitsschrittRepository arbeitsschritte) {
        final String endung = this.persistence.dateiendung();
        Iterable artikeldateien = this.basisverzeichnis.listDirectory(new VirtualFileFilter(){

            public boolean accept(VirtualFile f) {
                return f.isFile() && f.getName().endsWith(endung);
            }
        });
        artikeldateien.forEach(vf -> {
            try {
                Optional maybeArtikel = this.persistence.ladeAus(vf, arbeitsschritte);
                maybeArtikel.ifPresent(this.cache::speichere);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"", (Throwable)e);
            }
        });
        this.getLogger().debug((Object)(this.cache.anzahl() + " Artikel gecacht."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Artikel<?>> alle() {
        ArtikelCache artikelCache = this.cache;
        synchronized (artikelCache) {
            return this.cache.alle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Artikel<?>> f\u00fcrRevisionierteArtikelnummer(String revisionierteArtikelnummer) {
        ArtikelCache artikelCache = this.cache;
        synchronized (artikelCache) {
            return this.cache.f\u00fcrRevisionierteArtikelnummer(revisionierteArtikelnummer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int anzahl() {
        ArtikelCache artikelCache = this.cache;
        synchronized (artikelCache) {
            return this.cache.anzahl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Artikel<?>> anIndex(int index) {
        ArtikelCache artikelCache = this.cache;
        synchronized (artikelCache) {
            return this.cache.anIndex(index);
        }
    }

    protected boolean sollGespeichertWerden(Artikel<?> artikel) {
        Optional<Artikel<?>> maybeSchonVorhanden = this.f\u00fcrRevisionierteArtikelnummer(artikel.revisionierteArtikelnummer());
        if (maybeSchonVorhanden.isEmpty()) {
            return true;
        }
        Artikel<?> schonVorhanden = maybeSchonVorhanden.get();
        return schonVorhanden.istEinzelteil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void speichernDurchf\u00fchrenF\u00fcr(Artikel<?> artikel) throws IOException {
        if (!this.sollGespeichertWerden(artikel)) {
            this.getLogger().info((Object)("Speichere " + String.valueOf(artikel) + " nicht nochmals, ist Baugruppe: " + artikel.istBaugruppe()));
            return;
        }
        String dateiname = Dateiname.g\u00fcltigF\u00fcr((String)artikel.revisionierteArtikelnummer()) + this.persistence.dateiendung();
        VirtualFile zieldatei = this.basisverzeichnis.getChild(dateiname);
        ArtikelCache artikelCache = this.cache;
        synchronized (artikelCache) {
            this.persistence.speichere(artikel, zieldatei);
            this.cache.speichere(artikel);
        }
    }
}

