/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.verzeichnis;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.applicationLevel.BooleanProperty;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragRepository;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragbearbeitungRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.ProduktionsartikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ArbeitsauftragDatenspeicherung;
import com.schneide.werp.produktion.model.repository.BeschreibbaresArbeitsauftragRepository;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class VerzeichnisbasiertesArbeitsauftragRepository
extends LoggedObject
implements BeschreibbaresArbeitsauftragRepository {
    private final VirtualFile basisverzeichnis;
    private final ArbeitsauftragDatenspeicherung persistence;
    private final ArbeitsschrittRepository alleArbeitsschritte;
    private final ProduktionsartikelRepository alleProduktionsartikel;
    private final VerzeichnisbasiertesArbeitsauftragbearbeitungRepository alleBearbeitungen;
    private final Map<String, Arbeitsauftrag> cache;

    public VerzeichnisbasiertesArbeitsauftragRepository(VirtualFile basisverzeichnis, ArbeitsauftragDatenspeicherung persistence, ArbeitsschrittRepository alleArbeitsschritte, ProduktionsartikelRepository alleProduktionsartikel) {
        this.basisverzeichnis = basisverzeichnis;
        this.persistence = persistence;
        this.alleArbeitsschritte = alleArbeitsschritte;
        this.alleProduktionsartikel = alleProduktionsartikel;
        this.alleBearbeitungen = new VerzeichnisbasiertesArbeitsauftragbearbeitungRepository(this::projektverzeichnisF\u00fcr);
        this.cache = new HashMap<String, Arbeitsauftrag>();
    }

    public Stream<Produktionsnummer> verf\u00fcgbareProduktionen() {
        return IterableUtil.asStream((Iterable)this.basisverzeichnis.subdirectories()).map(vf -> new Produktionsnummer(vf.getName()));
    }

    public boolean verwaltet(ArbeitsauftragIdentifikation identifikation) {
        try {
            VirtualFile datei = this.zieldateiF\u00fcr(identifikation);
            return datei.isFile();
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Arbeitsauftrag konnte wegen technischer Probleme nicht geladen werden: " + String.valueOf(identifikation)), (Throwable)e);
            return false;
        }
    }

    public Optional<Arbeitsauftrag> f\u00fcr(ArbeitsauftragIdentifikation identifikation) {
        try {
            VirtualFile datei = this.zieldateiF\u00fcr(identifikation);
            if (!datei.isFile()) {
                return Optional.empty();
            }
            return this.ladenAus(datei);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Arbeitsauftrag konnte wegen technischer Probleme nicht geladen werden.", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<Arbeitsauftrag> ladenAus(VirtualFile datei) {
        Map<String, Arbeitsauftrag> map = this.cache;
        synchronized (map) {
            Optional<Arbeitsauftrag> maybeCached = Optional.ofNullable(this.cache.get(datei.getAbsoluteName()));
            if (maybeCached.isPresent()) {
                return maybeCached;
            }
        }
        try {
            Optional geladen = this.persistence.ladeAus(datei, this.alleArbeitsschritte, (ArbeitsauftragRepository)this, this.alleProduktionsartikel);
            geladen.ifPresent(aa -> this.cachenF\u00fcr(datei, (Arbeitsauftrag)aa));
            return geladen;
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Technischer Fehler beim Laden aus " + String.valueOf(datei)), (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachenF\u00fcr(VirtualFile datei, Arbeitsauftrag aa) {
        Map<String, Arbeitsauftrag> map = this.cache;
        synchronized (map) {
            this.cache.put(datei.getAbsoluteName(), aa);
        }
    }

    public Stream<Arbeitsauftrag> alleF\u00fcr(Produktionsnummer projekt) {
        try {
            Iterable dateien = this.projektverzeichnisF\u00fcr(projekt).listAllFilesEndingOn(this.persistence.dateiendung());
            Stream.Builder result = Stream.builder();
            dateien.forEach(vf -> this.ladenAus((VirtualFile)vf).ifPresent(result::add));
            return result.build();
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Technischer Fehler beim Laden aller Arbeitsauftrag", (Throwable)e);
            return Stream.empty();
        }
    }

    @Override
    public void speichere(Arbeitsauftrag neu) throws IOException {
        VirtualFile zieldatei = this.zieldateiF\u00fcr(neu.identifikation());
        this.persistence.speichere(neu, zieldatei);
        this.cachenF\u00fcr(zieldatei, neu);
    }

    protected VirtualFile zieldateiF\u00fcr(ArbeitsauftragIdentifikation identifikation) throws IOException {
        VirtualFile projektverzeichnis = this.projektverzeichnisF\u00fcr(identifikation.projekt());
        return projektverzeichnis.getChild(Dateiname.g\u00fcltigF\u00fcr((String)identifikation.alsText()) + this.persistence.dateiendung());
    }

    protected VirtualFile projektverzeichnisF\u00fcr(Produktionsnummer projekt) throws IOException {
        VirtualFile projektverzeichnis = this.basisverzeichnis.subdirectory(Dateiname.g\u00fcltigF\u00fcr((String)projekt.alsText()));
        return projektverzeichnis;
    }

    public ArbeitsauftragbearbeitungRepository bearbeitung() {
        return this.alleBearbeitungen;
    }

    public static class VerzeichnisbasiertesArbeitsauftragbearbeitungRepository
    extends LoggedObject
    implements ArbeitsauftragbearbeitungRepository {
        private final Projektverzeichnis verzeichnisse;
        private final Map<Produktionsnummer, Map<ArbeitsauftragIdentifikation, Boolean>> cache;

        public VerzeichnisbasiertesArbeitsauftragbearbeitungRepository(Projektverzeichnis verzeichnisse) {
            this.verzeichnisse = verzeichnisse;
            this.cache = new HashMap<Produktionsnummer, Map<ArbeitsauftragIdentifikation, Boolean>>();
        }

        public void unfertig(ArbeitsauftragIdentifikation auftrag) {
            this.\u00e4ndereZustand(auftrag, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean istFertiggestellt(ArbeitsauftragIdentifikation auftrag) {
            Map<Produktionsnummer, Map<ArbeitsauftragIdentifikation, Boolean>> map = this.cache;
            synchronized (map) {
                Produktionsnummer projekt = auftrag.projekt();
                if (!this.cache.containsKey(projekt)) {
                    this.ladeF\u00fcr(projekt);
                }
                return Optional.ofNullable(this.cache.get(projekt).get(auftrag)).orElse(false);
            }
        }

        public void stelleFertig(ArbeitsauftragIdentifikation auftrag) {
            this.\u00e4ndereZustand(auftrag, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void \u00e4ndereZustand(ArbeitsauftragIdentifikation auftrag, boolean istFertiggestellt) {
            Map<Produktionsnummer, Map<ArbeitsauftragIdentifikation, Boolean>> map = this.cache;
            synchronized (map) {
                Produktionsnummer projekt = auftrag.projekt();
                if (!this.cache.containsKey(projekt)) {
                    this.ladeF\u00fcr(projekt);
                }
                this.cache.get(projekt).put(auftrag, istFertiggestellt);
                this.speichereF\u00fcr(projekt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ladeF\u00fcr(Produktionsnummer projekt) {
            Map<Produktionsnummer, Map<ArbeitsauftragIdentifikation, Boolean>> map = this.cache;
            synchronized (map) {
                try {
                    VirtualFile fertigstellungsdatei = this.fertigstellungsdateiF\u00fcr(projekt);
                    Configuration fertigstellung = new Configuration(new VirtualFile[]{fertigstellungsdatei});
                    HashMap geladen = new HashMap();
                    fertigstellung.properties().forEach(p -> {
                        Optional maybeIdentifikation = ArbeitsauftragIdentifikation.aus((String)p.getKey());
                        if (maybeIdentifikation.isEmpty()) {
                            this.getLogger().error((Object)("Nicht lesbare Arbeitsauftrag-Identifikation: " + p.getKey()));
                            return;
                        }
                        boolean zustand = BooleanProperty.parse((String)p.getValue());
                        geladen.put((ArbeitsauftragIdentifikation)maybeIdentifikation.get(), zustand);
                    });
                    this.cache.put(projekt, geladen);
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("Technischer Fehler beim Laden der Arbeitsauftrag-Fertigstellungsdatei f\u00fcr " + projekt.alsText()), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void speichereF\u00fcr(Produktionsnummer projekt) {
            Map<Produktionsnummer, Map<ArbeitsauftragIdentifikation, Boolean>> map = this.cache;
            synchronized (map) {
                try {
                    VirtualFile fertigstellungsdatei = this.fertigstellungsdateiF\u00fcr(projekt);
                    Configuration fertigstellung = new Configuration(new VirtualFile[]{fertigstellungsdatei});
                    Map<ArbeitsauftragIdentifikation, Boolean> zuSpeichern = this.cache.getOrDefault(projekt, Collections.emptyMap());
                    zuSpeichern.forEach((key, value) -> fertigstellung.addProperty(key.alsText(), String.valueOf(value)));
                    fertigstellung.commit();
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("Technischer Fehler beim Schreiben der Arbeitsauftrag-Fertigstellungsdatei f\u00fcr " + projekt.alsText()), (Throwable)e);
                }
            }
        }

        protected VirtualFile fertigstellungsdateiF\u00fcr(Produktionsnummer projekt) throws IOException {
            VirtualFile projektverzeichnis = this.verzeichnisse.f\u00fcr(projekt);
            VirtualFile result = projektverzeichnis.getChild("fertigstellung.setting");
            return result;
        }
    }

    public static interface Projektverzeichnis {
        public VirtualFile f\u00fcr(Produktionsnummer var1) throws IOException;
    }
}

