/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.cache.generic;

import com.schneide.base.logging.LoggedObject;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class EntityCache<Entity>
extends LoggedObject {
    private final String entitybezeichnung;
    private final Function<Entity, String> identifier;
    private final Comparator<Entity> sortierung;
    private final Map<String, Entity> cache;
    private final List<Entity> sortierterCache;

    public EntityCache(String entitybezeichnung, Function<Entity, String> identifier, Comparator<Entity> sortierung) {
        this.entitybezeichnung = entitybezeichnung;
        this.identifier = identifier;
        this.sortierung = sortierung;
        this.cache = new HashMap<String, Entity>();
        this.sortierterCache = new LinkedList<Entity>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Entity> alle() {
        Map<String, Entity> map = this.cache;
        synchronized (map) {
            return Collections.unmodifiableList(this.sortierterCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Entity> f\u00fcr(String gesuchterIdentifier) {
        Map<String, Entity> map = this.cache;
        synchronized (map) {
            return Optional.ofNullable(this.cache.get(gesuchterIdentifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int anzahl() {
        Map<String, Entity> map = this.cache;
        synchronized (map) {
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Entity> anIndex(int index) {
        Map<String, Entity> map = this.cache;
        synchronized (map) {
            try {
                return Optional.ofNullable(this.sortierterCache.get(index));
            }
            catch (IndexOutOfBoundsException e) {
                this.getLogger().warn((Object)("Ung\u00fcltiger Index f\u00fcr " + this.entitybezeichnung + " angefragt."), (Throwable)e);
                return Optional.empty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speichere(Entity neu) {
        String neuerIdentifier = this.identifier.apply(neu);
        Map<String, Entity> map = this.cache;
        synchronized (map) {
            Entity previous = this.cache.put(neuerIdentifier, neu);
            if (previous != null) {
                this.sortierterCache.remove(previous);
            }
            this.sortierterCache.add(neu);
            Collections.sort(this.sortierterCache, this.sortierung);
        }
    }
}

