/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.main;

import com.schneide.base.application.gui.SchneideApplicationFrame;
import com.schneide.base.application.gui.model.FrameVisualisationSpecification;
import com.schneide.base.application.interaction.MenuManager;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.gui.swing.EDT;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.produktion.engine.dashboard.news.DashboardAnzeigen;
import com.schneide.werp.produktion.gui.camera.news.ChangeQRCodeRecognition;
import com.schneide.werp.produktion.gui.camera.news.StartQRCodeRecognition;
import com.schneide.werp.produktion.gui.camera.news.StopQRCodeRecognition;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.ArbeitsauftragDashboard;
import com.schneide.werp.produktion.gui.main.Hauptbereich;
import com.schneide.werp.produktion.gui.main.component.Kontextbanner;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public class WerpMainFrame
extends SchneideApplicationFrame<WerpSession, PlainWerpUser> {
    public static final String NAME = "werp main frame";
    private final JPanel kontextbanner = (JPanel)EDT.query(() -> WerpMainFrame.panelWith(Color.gray));
    private final Hauptbereich inhaltbereich;
    private final JPanel detailbereich;
    private final Subscriber<DashboardAnzeigen> dashboardwechsel;

    public WerpMainFrame(WerpSession session, FrameVisualisationSpecification specification, MenuManager<WerpSession, PlainWerpUser> menuManager, UserManager<PlainWerpUser> userManager, Iterable<ArbeitsauftragDashboard> dashboards, Supplier<Dokumenterstellung> erstellung, Supplier<Stream<Produktionsnummer>> existierendeProduktionen, Supplier<Iterable<Arbeitsschritt>> alleT\u00e4tigkeiten) {
        super((SchneideSession)session, specification, menuManager, userManager);
        this.inhaltbereich = new Hauptbereich(erstellung, existierendeProduktionen, alleT\u00e4tigkeiten, session);
        this.detailbereich = (JPanel)EDT.query(WerpMainFrame::panel);
        TransformingIterable dashboardbuttons = new TransformingIterable(d -> d.anzeigeschaltfl\u00e4che(), dashboards);
        Kontextbanner kontext = new Kontextbanner((Iterable<? extends JToggleButton>)dashboardbuttons);
        this.f\u00fcrKontextbanner(kontext.prepare());
        this.dashboardwechsel = new Subscriber(DashboardAnzeigen.class, n -> EDT.later(() -> this.f\u00fcrHauptbereich(n.dashboard())));
    }

    public void requestFocus() {
        this.inhaltbereich.requestFocus();
    }

    private static JPanel panelWith(Color background) {
        JPanel result = WerpMainFrame.panel();
        result.setBackground(background);
        return result;
    }

    private static JPanel panel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 2));
        result.setBorder(BorderFactory.createLineBorder(Color.black));
        return result;
    }

    public void f\u00fcrHauptbereich(ArbeitsauftragDashboard dashboard) {
        EDT.always();
        this.inhaltbereich.zeigeAn(dashboard);
    }

    public void f\u00fcrKontextbanner(JComponent indicatorComponent) {
        EDT.always();
        this.kontextbanner.add(indicatorComponent);
    }

    public void f\u00fcrDetailbereich(JComponent measurementComponent) {
        EDT.always();
        this.detailbereich.add(measurementComponent);
    }

    protected void buildUI() {
        EDT.always();
        super.buildUI();
        JPanel mainArea = new JPanel((LayoutManager)new MigLayout("", "[grow]10px[400px:30%]", "[70px][grow][200px:40%]"));
        this.getFrame().getContentPane().add((Component)mainArea, "Center");
        mainArea.add((Component)this.kontextbanner, "cell 0 0, spanx 2, grow");
        mainArea.add((Component)this.inhaltbereich.prepare(), "cell 0 1, spany 2, wmin 400px, grow");
        mainArea.add((Component)this.detailbereich, "cell 1 1, spany 2, hmin 300px, grow");
        Subscriber.attach(this.dashboardwechsel, (EventBus)((WerpSession)this.getSession()).getApplicationBus());
        this.inhaltbereich.lauscheAuf(((WerpSession)this.getSession()).getApplicationBus());
        this.requestFocus();
        this.getFrame().setFocusable(true);
        this.getFrame().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.handle(e, StartQRCodeRecognition::new);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.handle(e, StopQRCodeRecognition::new);
            }

            protected void handle(KeyEvent e, Supplier<ChangeQRCodeRecognition> news) {
                if (e.getKeyCode() == 17) {
                    WerpMainFrame.this.dashboardwechsel.publishIfSubscribed((News)news.get());
                }
            }
        });
    }

    public void windowClosing(WindowEvent arg0) {
        this.dashboardwechsel.stop();
        ((WerpSession)this.getSession()).getActionManager().performAction("system.shutdown", this.getSession());
    }
}

