/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.frame;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.gui.icon.LoadedIcon;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsliste;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.frame.generic.WerpFrame;
import java.awt.Component;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ProduktionslistenFrame
extends WerpFrame {
    private static final LoadedIcon einzelteilIcon = new LoadedIcon("resources/images/icons/einzelteil-24px.png");
    private static final LoadedIcon baugruppeIcon = new LoadedIcon("resources/images/icons/baugruppe-24px.png");
    private final Produktionsliste produktion;
    private final Map<Produktionslisteneintrag, List<Arbeitsauftrag>> direkteAuftr\u00e4ge;
    private final Map<Produktionslisteneintrag, Integer> gesamteAuftr\u00e4ge;
    private final boolean mitAuftr\u00e4gen;

    public ProduktionslistenFrame(WerpSession session, Produktionsliste produktion, Iterable<Arbeitsauftrag> arbeitsauftr\u00e4ge) {
        super(session, "Produktionsliste f\u00fcr " + produktion.nummer().alsText());
        this.produktion = produktion;
        this.mitAuftr\u00e4gen = IterableUtil.hasContent(arbeitsauftr\u00e4ge);
        this.direkteAuftr\u00e4ge = produktion.zuordnenVon(arbeitsauftr\u00e4ge);
        this.gesamteAuftr\u00e4ge = new HashMap<Produktionslisteneintrag, Integer>();
        produktion.eachDepthFirst(ple -> {
            int direkt = this.direkteAuftr\u00e4ge.get(ple).size();
            ple.eintragspfad().forEach(eintrag -> this.gesamteAuftr\u00e4ge.compute((Produktionslisteneintrag)eintrag, (p, bisher) -> bisher == null ? direkt : bisher + direkt));
        });
    }

    protected void buildUIFor(JFrame givenFrame) {
        HashMap<Produktionslisteneintrag, TreeNode> nodeMapping = new HashMap<Produktionslisteneintrag, TreeNode>();
        this.produktion.eachDepthFirst(ple -> nodeMapping.put((Produktionslisteneintrag)ple, new ProduktionslisteneintragTreeNode((Produktionslisteneintrag)ple, (Map<Produktionslisteneintrag, TreeNode>)nodeMapping)));
        ProduktionslistenTreeNode root = new ProduktionslistenTreeNode(this.produktion, nodeMapping);
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree tree = new JTree(model);
        tree.setCellRenderer(new ProduktionsbezogenerTreeCellRenderer(this.mitAuftr\u00e4gen));
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        JScrollPane scrolling = new JScrollPane(tree);
        givenFrame.getContentPane().add(scrolling);
    }

    private String auftragstextF\u00fcr(ProduktionsbezogenerTreeNode p) {
        StringBuilder zusatz = new StringBuilder();
        zusatz.append(" (");
        int eigene = p.eigeneArbeitsauftr\u00e4ge();
        zusatz.append(eigene);
        zusatz.append(" ");
        zusatz.append(eigene == 1 ? "Arbeitsauftrag" : "Arbeitsauftr\u00e4ge");
        int gesamt = p.gesamteArbeitsauftr\u00e4ge();
        if (gesamt != eigene) {
            zusatz.append(", ");
            zusatz.append(gesamt);
            zusatz.append(" gesamt");
        }
        zusatz.append(")");
        return zusatz.toString();
    }

    private class ProduktionslistenTreeNode
    extends ProduktionsbezogenerTreeNode {
        private final Produktionsliste liste;

        public ProduktionslistenTreeNode(Produktionsliste liste, Map<Produktionslisteneintrag, TreeNode> nodeMapping) {
            super(ProduktionslistenFrame.this, nodeMapping);
            this.liste = liste;
        }

        @Override
        public int eigeneArbeitsauftr\u00e4ge() {
            return 0;
        }

        @Override
        public int gesamteArbeitsauftr\u00e4ge() {
            return IterableUtil.asStream((Iterable)this.liste.hauptbaugruppen()).mapToInt(ple -> ProduktionslistenFrame.this.gesamteAuftr\u00e4ge.get(ple)).sum();
        }

        @Override
        public String text() {
            return this.liste.nummer().alsText();
        }

        @Override
        protected Iterable<Produktionslisteneintrag> drunter() {
            return this.liste.hauptbaugruppen();
        }

        @Override
        public TreeNode getParent() {
            return null;
        }
    }

    private class ProduktionsbezogenerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 2663619078857329622L;
        private final boolean zeigeArbeitsauftragsanzahl;

        public ProduktionsbezogenerTreeCellRenderer(boolean zeigeArbeitsauftragsanzahl) {
            this.zeigeArbeitsauftragsanzahl = zeigeArbeitsauftragsanzahl;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            ProduktionsbezogenerTreeNode p = (ProduktionsbezogenerTreeNode)value;
            Component result = super.getTreeCellRendererComponent(tree, p.text(), sel, expanded, leaf, row, focus);
            JLabel label = (JLabel)result;
            label.setIcon(leaf ? einzelteilIcon.icon() : baugruppeIcon.icon());
            label.setFont(label.getFont().deriveFont(14.0f));
            StringBuilder text = new StringBuilder();
            text.append(p.text());
            if (this.zeigeArbeitsauftragsanzahl) {
                text.append(ProduktionslistenFrame.this.auftragstextF\u00fcr(p));
            }
            label.setText(text.toString());
            return label;
        }
    }

    private abstract class ProduktionsbezogenerTreeNode
    implements TreeNode {
        private final Map<Produktionslisteneintrag, TreeNode> nodeMapping;
        private final Map<TreeNode, Integer> childIndicesCache;

        public ProduktionsbezogenerTreeNode(ProduktionslistenFrame produktionslistenFrame, Map<Produktionslisteneintrag, TreeNode> nodeMapping) {
            this.nodeMapping = nodeMapping;
            this.childIndicesCache = new HashMap<TreeNode, Integer>();
        }

        public abstract String text();

        public abstract int eigeneArbeitsauftr\u00e4ge();

        public abstract int gesamteArbeitsauftr\u00e4ge();

        protected TreeNode asNode(Produktionslisteneintrag eintrag) {
            return this.nodeMapping.get(eintrag);
        }

        protected abstract Iterable<Produktionslisteneintrag> drunter();

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.asNode((Produktionslisteneintrag)IterableUtil.getElementAt((int)childIndex, this.drunter()));
        }

        @Override
        public int getChildCount() {
            return IterableUtil.getSizeFor(this.drunter());
        }

        @Override
        public int getIndex(TreeNode node) {
            if (!this.childIndicesCache.containsKey(node)) {
                int index = 0;
                for (TreeNode each : this.childNodes()) {
                    this.childIndicesCache.put(each, index);
                    ++index;
                }
            }
            return this.childIndicesCache.get(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return !IterableUtil.isEmpty(this.drunter());
        }

        @Override
        public boolean isLeaf() {
            return IterableUtil.isEmpty(this.drunter());
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return Collections.enumeration(IterableUtil.asList(this.childNodes()));
        }

        private Iterable<TreeNode> childNodes() {
            TransformingIterable unternodes = new TransformingIterable(this::asNode, this.drunter());
            return unternodes;
        }
    }

    private class ProduktionslisteneintragTreeNode
    extends ProduktionsbezogenerTreeNode {
        private final Produktionslisteneintrag eintrag;

        public ProduktionslisteneintragTreeNode(Produktionslisteneintrag eintrag, Map<Produktionslisteneintrag, TreeNode> nodeMapping) {
            super(ProduktionslistenFrame.this, nodeMapping);
            this.eintrag = eintrag;
        }

        @Override
        public int eigeneArbeitsauftr\u00e4ge() {
            return Optional.ofNullable(ProduktionslistenFrame.this.direkteAuftr\u00e4ge.get(this.eintrag)).map(List::size).orElse(0);
        }

        @Override
        public int gesamteArbeitsauftr\u00e4ge() {
            return Optional.ofNullable(ProduktionslistenFrame.this.gesamteAuftr\u00e4ge.get(this.eintrag)).orElse(0);
        }

        @Override
        public String text() {
            return this.eintrag.koordinate().alsText() + " - " + this.eintrag.eigeneAnzahl() + "x " + this.eintrag.artikel().artikelnummerMitRevision() + ": " + this.eintrag.artikel().bezeichnung();
        }

        @Override
        protected Iterable<Produktionslisteneintrag> drunter() {
            return this.eintrag.untergeordnet();
        }

        @Override
        public TreeNode getParent() {
            return this.eintrag.\u00fcbergeordnet().map(this::asNode).orElse(null);
        }
    }
}

