/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.threading.executor.DoInBackground;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.gui.widget.generic.MultiComboBox;
import com.schneide.werp.gui.widget.generic.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class Produktionseingrenzunganzeige
extends UIComponent<JPanel> {
    private final MultiComboBox<SelectableProduktionsnummer> gew\u00e4hlteProduktionen;
    private final Runnable neuLaden;

    public Produktionseingrenzunganzeige(Supplier<Stream<Produktionsnummer>> existierendeProduktionen, Runnable neuLaden) {
        this.neuLaden = neuLaden;
        this.gew\u00e4hlteProduktionen = (MultiComboBox)EDT.query(() -> {
            Vector entries = new Vector();
            ((Stream)existierendeProduktionen.get()).forEach(pn -> entries.add(new SelectableProduktionsnummer((Produktionsnummer)pn)));
            MultiComboBox result = new MultiComboBox(new DefaultComboBoxModel(entries), 20);
            result.setMaximumSize(new Dimension(150, 50));
            return result;
        });
    }

    public void requestFocus() {
        EDT.perform(() -> this.gew\u00e4hlteProduktionen.requestFocusInWindow());
    }

    private void suchlaufDurchf\u00fchren() {
        DoInBackground.now((String)"Suche", (Runnable)this.neuLaden);
    }

    public Iterable<Produktionsnummer> gew\u00e4hlteProduktionen() {
        return (Iterable)EDT.query(() -> {
            Iterable selected = this.gew\u00e4hlteProduktionen.getSelectedItems();
            return new TransformingIterable(SelectableProduktionsnummer::produktion, selected);
        });
    }

    protected JPanel buildComponent() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new MigLayout("", "[]", "[][]"));
        result.add((Component)new JLabel("Nur Arbeitsauftr\u00e4ge aus:"), "wrap");
        ActionListener suchlaufDurchf\u00fchren = e -> this.suchlaufDurchf\u00fchren();
        result.add((Component)this.gew\u00e4hlteProduktionen);
        this.gew\u00e4hlteProduktionen.addActionListener(suchlaufDurchf\u00fchren);
        result.setBorder((Border)new RoundedBorder(Color.black, 10));
        return result;
    }

    private static class SelectableProduktionsnummer
    extends MultiComboBox.CheckableItem {
        private final Produktionsnummer produktion;

        public SelectableProduktionsnummer(Produktionsnummer produktion) {
            super(produktion.alsText(), false);
            this.produktion = produktion;
        }

        public Produktionsnummer produktion() {
            return this.produktion;
        }
    }
}

