/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.datatypes.collections.iterable.FilteredIterable;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.Arbeitsauftragbanner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class Arbeitsauftragspalte
extends UIComponent<JPanel> {
    private final String \u00fcberschrift;
    private final JPanel content;
    private final Predicate<Arbeitsauftragdaten> spaltenfilter;
    private final boolean einspaltig;
    private final WerpSession session;

    public Arbeitsauftragspalte(String \u00fcberschrift, boolean einspaltig, Predicate<Arbeitsauftragdaten> spaltenfilter, WerpSession session) {
        this.\u00fcberschrift = \u00fcberschrift;
        this.einspaltig = einspaltig;
        this.spaltenfilter = spaltenfilter;
        this.session = session;
        this.content = (JPanel)EDT.query(() -> {
            JPanel result = new JPanel();
            result.setLayout((LayoutManager)this.layoutF\u00fcr(einspaltig ? 1 : 3));
            return result;
        });
    }

    private MigLayout layoutF\u00fcr(int spalten) {
        this.getLogger().debug((Object)("Baue Layout f\u00fcr " + spalten + " Banner nebeneinander"));
        return new MigLayout("insets 5 0 0 0, wrap " + spalten, "[sg spalte, fill]".repeat(spalten), "[sg zeile, fill]");
    }

    public void anordnen(int inSpalten) {
        this.getLogger().debug((Object)("Anordnen in " + inSpalten + " Bannern!"));
        if (this.einspaltig) {
            return;
        }
        EDT.later(() -> {
            this.content.setLayout((LayoutManager)this.layoutF\u00fcr(inSpalten));
            this.content.revalidate();
            this.content.repaint();
        });
    }

    public void leeren() {
        this.anzeigen(Collections.emptyList());
    }

    public void anzeigen(Iterable<Arbeitsauftragdaten> ungefiltert) {
        this.getLogger().debug((Object)("Filtere " + IterableUtil.getSizeFor(ungefiltert) + " Auftr\u00e4ge passend zur Spalte"));
        FilteredIterable anzeigen = new FilteredIterable(ungefiltert, this.spaltenfilter);
        EDT.perform(() -> {
            this.content.removeAll();
            for (Arbeitsauftragdaten each : anzeigen) {
                this.content.add((Component)new Arbeitsauftragbanner(each, this.session).prepare(), "grow, push");
            }
            this.content.revalidate();
            this.content.repaint();
        });
    }

    protected JPanel buildComponent() {
        EDT.always();
        return this.setContentTo(this.content);
    }

    private JPanel setContentTo(JPanel content) {
        EDT.always();
        final JPanel result = new JPanel(new BorderLayout());
        JScrollPane scrolling = new JScrollPane(content, 20, 31);
        scrolling.setBorder(BorderFactory.createEmptyBorder());
        scrolling.getVerticalScrollBar().setUnitIncrement(24);
        result.add((Component)scrolling, "Center");
        result.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Arbeitsauftragspalte.this.optimaleAnordnungF\u00fcr(result);
            }
        });
        EDT.later(() -> this.optimaleAnordnungF\u00fcr(result));
        return result;
    }

    private void optimaleAnordnungF\u00fcr(JPanel container) {
        int width = container.getWidth();
        int nebeneinander = width / 370;
        this.anordnen(nebeneinander);
    }

    private static class \u00dcberschriftLabel
    extends JLabel {
        private static final long serialVersionUID = -1326836713483606054L;

        public \u00dcberschriftLabel(String text) {
            super(text);
            HashMap<TextAttribute, Integer> attributes = new HashMap<TextAttribute, Integer>();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.setFont(this.getFont().deriveFont(1).deriveFont(26.0f).deriveFont(attributes));
        }
    }
}

