/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.eventbus.News;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.text.HTMLText;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.domain.session.testing.DemoWerpSession;
import com.schneide.werp.gui.widget.generic.Datumsangabe;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.domain.arbeitsschritt.ArbeitsschrittLogoRepository;
import com.schneide.werp.produktion.engine.arbeitsauftrag.news.ArbeitsauftragEditieren;
import com.schneide.werp.produktion.model.repository.inmemory.MemoryBasedArbeitsauftragRepository;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Clock;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class Arbeitsauftragbanner
extends UIComponent<JPanel> {
    public static final int erwarteteBreite = 360;
    public static final Color blockiert = Color.decode("0xDBCBD8");
    public static final Color erledigbar = Color.decode("0xBABD8D");
    public static final Color erledigt = Color.decode("0xF2FDFF");
    private final Arbeitsauftragdaten daten;
    private final WerpSession session;

    public Arbeitsauftragbanner(Arbeitsauftragdaten daten, WerpSession session) {
        this.daten = daten;
        this.session = session;
    }

    protected JPanel buildComponent() {
        EDT.always();
        ArbeitsschrittLogo kundenlogo = new ArbeitsschrittLogo(this.daten);
        ArbeitsauftragsnummerLabel auftragsnummer = new ArbeitsauftragsnummerLabel(this.auftrag().identifikation());
        if (this.auftrag().t\u00e4tigkeit().istVorziehbar()) {
            auftragsnummer.setText(auftragsnummer.getText() + " !");
            kundenlogo.setBorder(BorderFactory.createLineBorder(Color.red, 2));
        }
        T\u00e4tigkeitsbeschreibungLabel auftragsbeschreibung = new T\u00e4tigkeitsbeschreibungLabel(this.auftrag().t\u00e4tigkeit(), this.auftrag().listenkoordinate());
        JLabel produktionsbeginn = this.auftrag().produktionsbeginn().map(vt -> {
            ProduktionsbeginnLabel result = new ProduktionsbeginnLabel((LocalDate)vt, this.daten.zeitgeber());
            return result;
        }).orElse(new JLabel(" "));
        FertigstellungsterminLabel fertigstellung = new FertigstellungsterminLabel(this.auftrag().geplanteFertigstellung(), this.daten.zeitgeber());
        JPanel vorg\u00e4nger = this.abh\u00e4ngigkeitspanelF\u00fcr(this.daten.vorarbeiten());
        JPanel artikel = this.gef\u00e4rbterBereich();
        artikel.setLayout((LayoutManager)new MigLayout("ins 0", "", "[][]"));
        artikel.add((Component)new JLabel(this.auftrag().anzahl() + "x " + this.auftrag().f\u00fcrArtikel().artikelnummerMitRevision()), "wrap");
        artikel.add((Component)new JLabel(this.auftrag().f\u00fcrArtikel().benennung()), "wrap");
        JPanel nachfolger = this.abh\u00e4ngigkeitspanelF\u00fcr(this.daten.nacharbeiten());
        JPanel result = this.gef\u00e4rbterBereich();
        result.setLayout((LayoutManager)new MigLayout("", "[fill]push[80px]", "[align top]"));
        JPanel linkeSpalte = this.gef\u00e4rbterBereich();
        linkeSpalte.setLayout((LayoutManager)new MigLayout("", "[]", "[][][][]push[]"));
        JPanel rechteSpalte = this.gef\u00e4rbterBereich();
        rechteSpalte.setLayout((LayoutManager)new MigLayout("", "[]", "[]5px[][]"));
        linkeSpalte.add((Component)auftragsnummer, "wrap");
        linkeSpalte.add((Component)vorg\u00e4nger, "wrap");
        linkeSpalte.add((Component)auftragsbeschreibung, "wrap");
        linkeSpalte.add((Component)artikel, "wrap");
        linkeSpalte.add((Component)nachfolger, "wrap");
        rechteSpalte.add((Component)kundenlogo, "wrap");
        rechteSpalte.add((Component)produktionsbeginn, "wrap");
        rechteSpalte.add(fertigstellung);
        result.add(linkeSpalte);
        result.add(rechteSpalte);
        result.setBorder(BorderFactory.createBevelBorder(0));
        result.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Arbeitsauftragbanner.this.f\u00fclleDetailanzeige();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Arbeitsauftragbanner.this.leereDetailanzeige();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() % 2 == 0 && !e.isConsumed()) {
                    e.consume();
                    Arbeitsauftragbanner.this.editiereAuftrag();
                }
            }
        });
        return result;
    }

    protected void editiereAuftrag() {
        this.session.publish((News)new ArbeitsauftragEditieren(this.daten, this.session));
    }

    protected void f\u00fclleDetailanzeige() {
    }

    protected void leereDetailanzeige() {
    }

    protected Arbeitsauftrag auftrag() {
        return this.daten.auftrag();
    }

    private JPanel abh\u00e4ngigkeitspanelF\u00fcr(Iterable<Arbeitsauftragdaten> abh\u00e4ngigkeiten) {
        JPanel result = this.gef\u00e4rbterBereich();
        String spaltendefinition = "[sg spalte, fill]5px";
        result.setLayout((LayoutManager)new MigLayout("ins 0", "[sg spalte, fill]5px".repeat(5), ""));
        int spalte = 0;
        for (Arbeitsauftragdaten each : abh\u00e4ngigkeiten) {
            Abh\u00e4ngigkeitLabel label = new Abh\u00e4ngigkeitLabel(each);
            result.add((Component)label, ++spalte % 5 == 0 ? "wrap" : "");
        }
        return result;
    }

    private JPanel gef\u00e4rbterBereich() {
        JPanel result = new JPanel();
        result.setOpaque(true);
        result.setBackground(this.bannerfarbe());
        return result;
    }

    private Color bannerfarbe() {
        if (this.daten.istFertiggestellt()) {
            return erledigt;
        }
        if (this.daten.alleVorarbeitenSindErf\u00fcllt()) {
            return erledigbar;
        }
        return blockiert;
    }

    public static void main(String[] args) {
        JFrame demo = new JFrame("Demo");
        demo.setDefaultCloseOperation(3);
        MemoryBasedArbeitsauftragRepository repository = new MemoryBasedArbeitsauftragRepository();
        Produktionsnummer dasProjekt = new Produktionsnummer("EB2024-999");
        Produktionskoordinate dieKoordinate = new Produktionskoordinate(dasProjekt, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Arbeitsauftrag daten = Arbeitsauftragbanner.einAuftrag(dieKoordinate, 272);
        repository.speichere(daten);
        Arbeitsauftrag vorher1 = Arbeitsauftragbanner.einAuftrag(dieKoordinate, 249);
        repository.speichere(vorher1);
        daten.h\u00e4ngtAbVon(vorher1);
        Arbeitsauftrag vorher2 = Arbeitsauftragbanner.einAuftrag(dieKoordinate, 262);
        repository.speichere(vorher2);
        daten.h\u00e4ngtAbVon(vorher2);
        repository.stelleFertig(vorher2.identifikation());
        Arbeitsauftrag nachher1 = Arbeitsauftragbanner.einAuftrag(dieKoordinate, 300);
        repository.speichere(nachher1);
        daten.vorarbeitVon(nachher1);
        Arbeitsauftrag nachher2 = Arbeitsauftragbanner.einAuftrag(dieKoordinate, 333);
        repository.speichere(nachher2);
        daten.vorarbeitVon(nachher2);
        DemoWerpSession session = new DemoWerpSession();
        Arbeitsauftragdaten angaben = new Arbeitsauftragdaten(daten, repository, Arbeitsauftragbanner.keinLogo(), session.zeitgeber());
        Arbeitsauftragbanner banner = new Arbeitsauftragbanner(angaben, (WerpSession)session);
        demo.getContentPane().add(banner.prepare());
        demo.pack();
        demo.setVisible(true);
    }

    private static Arbeitsauftrag einAuftrag(Produktionskoordinate dieKoordinate, int index) {
        Arbeitsauftrag daten = new Arbeitsauftrag(new ArbeitsauftragIdentifikation(dieKoordinate.nummer(), index), Arbeitsauftragbanner.derProduktionsartikel(dieKoordinate), dieKoordinate, 3, Arbeitsauftragbanner.derArbeitsschritt(), "Kommentar " + index);
        return daten;
    }

    private static Arbeitsschritt derArbeitsschritt() {
        return new Arbeitsschritt("MF5", "Schwei\u00dfen", List.of(), false, "Heften, Durchschwei\u00dfen & Richten", Optional.empty());
    }

    private static Produktionsartikel derProduktionsartikel(Produktionskoordinate dieKoordinate) {
        Produktionsartikel result = new Produktionsartikel(dieKoordinate, Arbeitsauftragbanner.derArtikel());
        return result;
    }

    private static Artikel<?> derArtikel() {
        return new Einzelteil(new Artikelnummer("B-ZAB-BL-300165"), "Blech", new Artikelrevision(1), "Erf\u00fcllungsweg_BL_20");
    }

    private static ArbeitsschrittLogoRepository keinLogo() {
        return new ArbeitsschrittLogoRepository(){

            @Override
            public Optional<Icon> logoF\u00fcr(Arbeitsschritt t\u00e4tigkeit, int gr\u00f6\u00dfe) {
                return Optional.empty();
            }
        };
    }

    private static class ArbeitsschrittLogo
    extends JLabel {
        private static final long serialVersionUID = -1775372272303870394L;

        public ArbeitsschrittLogo(Arbeitsauftragdaten angaben) {
            this.setIcon(angaben.t\u00e4tigkeitsicon());
            String ersteZeile = angaben.auftrag().t\u00e4tigkeit().nummer();
            String zweiteZeile = angaben.auftrag().t\u00e4tigkeit().beschreibung();
            this.setToolTipText(HTMLText.bold((String)ersteZeile).br().andText(zweiteZeile).buildHTML());
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }
    }

    private static class ArbeitsauftragsnummerLabel
    extends JLabel {
        private static final long serialVersionUID = -1326836713483606054L;

        public ArbeitsauftragsnummerLabel(ArbeitsauftragIdentifikation auftrag) {
            super(auftrag.alsText());
            this.setFont(this.getFont().deriveFont(1).deriveFont(18.0f));
            this.setToolTipText(auftrag.projekt().alsText());
        }
    }

    private static class T\u00e4tigkeitsbeschreibungLabel
    extends JLabel {
        private static final long serialVersionUID = 4026136787718965607L;

        public T\u00e4tigkeitsbeschreibungLabel(Arbeitsschritt t\u00e4tigkeit, Produktionskoordinate position) {
            super(t\u00e4tigkeit.nummerMitT\u00e4tigkeit() + " f\u00fcr Listenposition " + position.alsText());
            this.setToolTipText(t\u00e4tigkeit.beschreibung());
        }
    }

    private static class FertigstellungsterminLabel
    extends JLabel {
        private static final long serialVersionUID = -4096678399340984840L;

        public FertigstellungsterminLabel(LocalDate termin, Clock zeitgeber) {
            Datumsangabe.Wochengenau angaben = new Datumsangabe.Wochengenau(zeitgeber);
            this.setText(angaben.absolut(termin));
            this.setToolTipText(angaben.relativ(termin));
        }
    }

    private static class Abh\u00e4ngigkeitLabel
    extends JLabel {
        private static final long serialVersionUID = 4980706042840859805L;
        public static final Color unerledigt = Color.decode("0xFF8360");
        public static final Color erledigt = Color.decode("0x3CDBD3");

        public Abh\u00e4ngigkeitLabel(Arbeitsauftragdaten abh\u00e4ngigkeit) {
            super(abh\u00e4ngigkeit.auftrag().identifikation().kurzform());
            this.setToolTipText("<html><b>" + abh\u00e4ngigkeit.auftrag().identifikation().alsText() + "</b><br>" + abh\u00e4ngigkeit.auftrag().einzeiligeBeschreibung() + "</html>");
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 7, 5, 7)));
            this.setOpaque(true);
            this.setBackground(Abh\u00e4ngigkeitLabel.farbeF\u00fcr(abh\u00e4ngigkeit.istFertiggestellt()));
        }

        public static Color farbeF\u00fcr(boolean istFertiggestellt) {
            if (istFertiggestellt) {
                return erledigt;
            }
            return unerledigt;
        }
    }

    private static class ProduktionsbeginnLabel
    extends JLabel {
        private static final long serialVersionUID = -4096678399340984840L;

        public ProduktionsbeginnLabel(LocalDate termin, Clock zeitgeber) {
            Datumsangabe.Tagesgenau angaben = new Datumsangabe.Tagesgenau(zeitgeber);
            this.setText(angaben.absolut(termin));
            this.setToolTipText(angaben.relativ(termin));
        }
    }
}

