/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.I18N;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.helper.LayoutHelper;
import com.schneide.base.input.inputs.LabelInput;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.types.IntegerValue;
import com.schneide.base.input.types.StringValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DirectValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.kommentar.Kommentar;
import com.schneide.werp.domain.kommentar.KommentarRepository;
import com.schneide.werp.domain.kommentar.Kommentarkontext;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.generic.WerpDialog;
import com.schneide.werp.gui.widget.generic.RoundedBorder;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class ArbeitsauftragEditierenDialog
extends WerpDialog<Arbeitsauftragdaten> {
    private final Arbeitsauftragdaten auftrag;
    private final KommentarRepository kommentare;
    private final StringValue identifikation;
    private final StringValue produktionskoordinate;
    private final StringValue artikel;
    private final Iterable<StringValue> eigenschaften;
    private final IntegerValue anzahl;
    private final StringValue arbeitsschritt;
    private final StringValue kommentar;
    private final JPanel kommentarbereich;

    public ArbeitsauftragEditierenDialog(WerpSession session, Arbeitsauftragdaten auftrag, KommentarRepository kommentare) {
        super(session, (I18NResolvable)new I18N("Arbeitsauftrag \u00e4ndern", new Object[0]));
        this.auftrag = auftrag;
        this.kommentare = kommentare;
        this.kommentarbereich = (JPanel)EDT.query(JPanel::new);
        this.identifikation = new StringValue((ValueInformation)new DirectValueInformation("Identifikation", "TODO"), auftrag.auftrag().identifikation().alsText());
        this.produktionskoordinate = new StringValue((ValueInformation)new DirectValueInformation("Produktionskoordinate", "TODO"), auftrag.auftrag().listenkoordinate().alsText());
        this.artikel = new StringValue((ValueInformation)new DirectValueInformation("Artikel", "TODO"), auftrag.auftrag().artikelbeschreibung());
        ArrayList<StringValue> angezeigteEigenschaften = new ArrayList<StringValue>();
        Map definierteEigenschaften = auftrag.auftrag().f\u00fcrArtikel().eigenschaften();
        definierteEigenschaften.forEach((key, value) -> {
            StringValue eintrag = new StringValue((ValueInformation)new DirectValueInformation(key, "TODO"), value);
            angezeigteEigenschaften.add(eintrag);
        });
        this.eigenschaften = angezeigteEigenschaften;
        this.anzahl = new IntegerValue((ValueInformation)new DirectValueInformation("Anzahl", "TODO"), Integer.valueOf(auftrag.auftrag().anzahl()));
        this.arbeitsschritt = new StringValue((ValueInformation)new DirectValueInformation("Arbeitsschritt", "TODO"), auftrag.auftrag().t\u00e4tigkeitsbeschreibung());
        this.kommentar = new StringValue((ValueInformation)new DirectValueInformation("Kommentar", "TODO"), auftrag.auftrag().kommentar());
    }

    protected void buildContentWithin(JPanel content) {
        EDT.only();
        content.setLayout((LayoutManager)new MigLayout());
        this.addMessage(this.aktionsbeschreibung() + " Sie die Angaben f\u00fcr den Arbeitsauftrag " + this.auftrag.auftrag().identifikation().alsText() + ":");
        ArrayList<Object> felder = new ArrayList<Object>();
        felder.add(new LabelInput((Value)this.identifikation, 30));
        felder.add(new LabelInput((Value)this.produktionskoordinate, 30));
        felder.add(new LabelInput((Value)this.artikel, 30));
        this.eigenschaften.forEach(sv -> felder.add(new LabelInput((Value)sv)));
        felder.add(new TextfieldInput((Value)this.anzahl));
        felder.add(new LabelInput((Value)this.arbeitsschritt, 30));
        felder.add(new TextfieldInput((Value)this.kommentar, 45));
        JPanel angaben = LayoutHelper.buildGridLayoutFor(felder);
        content.add((Component)angaben, "wrap");
        this.aktualisiereKommentarbereich();
        content.add((Component)this.kommentarbereich, "wrap");
        content.add((Component)this.fertigstellungsbereich(), "wrap");
        this.addButton().commitCancelButtons();
    }

    protected void aktualisiereKommentarbereich() {
        EDT.always();
        this.kommentarbereich.removeAll();
        this.kommentarbereich.setLayout((LayoutManager)new MigLayout("ins 0", "", ""));
        JPanel kommentarliste = new JPanel((LayoutManager)new MigLayout("ins 0", "", ""));
        JScrollPane scrolling = new JScrollPane(kommentarliste);
        scrolling.setVerticalScrollBarPolicy(22);
        scrolling.setBorder(BorderFactory.createEmptyBorder());
        scrolling.getVerticalScrollBar().setUnitIncrement(24);
        scrolling.setPreferredSize(new Dimension(600, 220));
        EDT.later(() -> {
            JScrollBar vertical = scrolling.getVerticalScrollBar();
            vertical.setValue(vertical.getMaximum());
        });
        Stream alleKommentare = this.kommentare.alleF\u00fcr(this.auftrag.kommentarkontext());
        alleKommentare.map(Supplier::get).map(this::kommentarpanelF\u00fcr).forEach(kp -> kommentarliste.add((Component)kp, "wrap"));
        this.kommentarbereich.add((Component)scrolling, "wrap, growx");
        this.kommentarbereich.add((Component)this.kommentareingabeF\u00fcr(this.auftrag.kommentarkontext()), "wrap");
    }

    protected JPanel kommentareingabeF\u00fcr(Kommentarkontext kontext) {
        EDT.always();
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        JTextArea kommentartext = new JTextArea(3, 40);
        result.add((Component)kommentartext, "wrap");
        JButton absenden = new JButton("Kommentieren");
        absenden.addActionListener(ereignis -> {
            Kommentar neu = new Kommentar(kontext, () -> ((PlainWerpUser)((PlainWerpUser)this.session().getUser())).getFullName(), LocalDateTime.now(this.session().zeitgeber()), kommentartext.getText());
            try {
                this.kommentare.schreibe(neu);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"Fehler beim Kommentieren.", (Throwable)e);
            }
            this.aktualisiereKommentarbereich();
            this.getContent().revalidate();
        });
        result.add((Component)absenden, "wrap");
        return result;
    }

    protected JPanel kommentarpanelF\u00fcr(Kommentar vorhanden) {
        EDT.always();
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.setBorder(BorderFactory.createLineBorder(Color.black));
        JLabel titel = new JLabel(vorhanden.autor().vollerName() + " schreibt am " + vorhanden.zeitpunkt().format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm")));
        result.add((Component)titel, "wrap");
        vorhanden.textZeilenweise().forEach(zeile -> {
            JLabel zeilenlabel = new JLabel((String)zeile);
            result.add((Component)zeilenlabel, "wrap");
        });
        return result;
    }

    protected JPanel fertigstellungsbereich() {
        EDT.always();
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.setBorder((Border)new RoundedBorder(Color.red, 10));
        JToggleButton fertiggestellt = new JToggleButton("Arbeitsauftrag fertiggestellt");
        fertiggestellt.addActionListener(e -> EDT.runNormally(() -> this.auftrag.stelleFertig()));
        JToggleButton nichtFertiggestellt = new JToggleButton("Noch nicht fertiggestellt");
        nichtFertiggestellt.addActionListener(e -> EDT.runNormally(() -> this.auftrag.dochNochUnfertig()));
        ButtonGroup fertigstellung = new ButtonGroup();
        fertigstellung.add(fertiggestellt);
        fertigstellung.add(nichtFertiggestellt);
        (this.auftrag.istFertiggestellt() ? fertiggestellt : nichtFertiggestellt).setSelected(true);
        result.add(fertiggestellt);
        result.add(nichtFertiggestellt);
        return result;
    }

    protected String aktionsbeschreibung() {
        return "\u00c4ndern";
    }

    protected Optional<Arbeitsauftragdaten> giveAnswer() {
        return Optional.of((Arbeitsauftragdaten)EDT.query(() -> {
            Arbeitsauftrag ge\u00e4nderterAuftrag = this.auftrag.auftrag().mit\u00c4nderungen(this.anzahl.getValue(), this.kommentar.getValue());
            return this.auftrag.f\u00fcr(ge\u00e4nderterAuftrag);
        }));
    }
}

