/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.dialog;

import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.I18N;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.ProjektRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.generic.WerpDialog;
import com.schneide.werp.produktion.gui.frame.ProjektverwaltungFrame;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Projektauswahldialog
extends WerpDialog<Projekt> {
    private final ProjektRepository projekte;
    private JTable projekttabelle;

    public Projektauswahldialog(WerpSession session, ProjektRepository projekte) {
        super(session, (I18NResolvable)new I18N("Projekt ausw\u00e4hlen", new Object[0]));
        this.projekte = projekte;
        this.projekttabelle = (JTable)EDT.query(() -> {
            ProjektverwaltungFrame.Projektdaten artikeldaten = new ProjektverwaltungFrame.Projektdaten(this.projekte);
            return new JTable(artikeldaten);
        });
    }

    protected void buildContentWithin(JPanel content) {
        EDT.only();
        this.addMessage("W\u00e4hlen Sie das gew\u00fcnschte Projekt");
        JScrollPane scrolling = new JScrollPane(this.projekttabelle);
        content.add(scrolling);
        this.addButton().commitCancelButtons();
    }

    protected Optional<Projekt> giveAnswer() {
        return (Optional)EDT.query(() -> {
            int selectedRow = this.projekttabelle.getSelectedRow();
            return this.projekte.anIndex(selectedRow);
        });
    }

    public Optional<Projekt> gew\u00e4hlteProjekt() {
        return this.provideAnswer();
    }
}

