/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.camera;

import com.github.sarxos.webcam.Webcam;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.delay.Delay;
import com.schneide.base.threading.executor.DoInBackground;
import com.schneide.werp.produktion.gui.camera.news.ChangeQRCodeRecognition;
import com.schneide.werp.produktion.gui.camera.news.NeuerQRCode;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.stream.Stream;

public class QRCodeRecognition
extends LoggedObject {
    private final Subscriber<ChangeQRCodeRecognition> changeRequest = new Subscriber(ChangeQRCodeRecognition.class, n -> this.changeRecognitionTo(n.shouldBeRunning()));
    private volatile boolean isRunning = false;

    public void lauscheAuf(EventBus applicationBus) {
        DoInBackground.now((String)"QR-Code Recognizer", this::backgroundProcess);
        Subscriber.attach(this.changeRequest, (EventBus)applicationBus);
    }

    protected void changeRecognitionTo(boolean shouldBeRunning) {
        this.isRunning = shouldBeRunning;
    }

    protected void backgroundProcess() {
        Webcam camera = this.webcamWithMaximumViewSize();
        while (true) {
            if (this.isRunning) {
                this.recognitionCycleOn(camera);
            }
            Delay.forMilliseconds((long)50L);
        }
    }

    protected Webcam webcamWithMaximumViewSize() {
        Webcam camera = Webcam.getDefault();
        Dimension[] available = camera.getViewSizes();
        Optional<Dimension> maybeBiggest = Stream.of(available).sorted((links, rechts) -> rechts.width - links.width).findFirst();
        maybeBiggest.ifPresent(arg_0 -> ((Webcam)camera).setViewSize(arg_0));
        Webcam.getDiscoveryService().stop();
        return camera;
    }

    protected void recognitionCycleOn(Webcam camera) {
        BufferedImage frame = this.imageFrom(camera);
        try {
            Result result = new QRCodeReader().decode(QRCodeRecognition.toBinaryBitmap(frame));
            if (result != null) {
                String text = result.getText();
                this.changeRequest.publishIfSubscribed((News)new NeuerQRCode(text));
            }
        }
        catch (ChecksumException | FormatException | NotFoundException e) {
            this.getLogger().info((Object)"No QR-Code found");
        }
    }

    private static BinaryBitmap toBinaryBitmap(BufferedImage image) {
        return new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage imageFrom(Webcam camera) {
        try {
            camera.open();
            BufferedImage result = null;
            while (result == null) {
                result = camera.getImage();
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            camera.close();
        }
    }
}

