/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine.eingrenzung;

import com.schneide.base.datatypes.collections.iterable.FilteredIterable;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.engine.eingrenzung.TextEingrenzung;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.List;

public class Arbeitsauftragsuchtexteingrenzung
extends LoggedObject {
    private final List<TextEingrenzung<Arbeitsauftragdaten>> eingrenzungen = List.of(new TextEingrenzung("Auftragnummer", a -> a.auftrag().identifikation().alsText()), new TextEingrenzung("Artikel", a -> a.auftrag().f\u00fcrArtikel().artikelnummerMitRevision() + " " + a.auftrag().f\u00fcrArtikel().bezeichnung()), new TextEingrenzung("Arbeitsschritt", a -> a.auftrag().t\u00e4tigkeit().nummerMitT\u00e4tigkeit() + " " + a.auftrag().t\u00e4tigkeit().beschreibung()), new TextEingrenzung("Kommentar", a -> a.auftrag().kommentar()), new TextEingrenzung("Produktionsbeginn", a -> a.auftrag().produktionsbeginn().map(d -> Arbeitsauftragsuchtexteingrenzung.eingrenzungstextF\u00fcr(d)).orElse("")), new TextEingrenzung("Geplante Fertigstellung", a -> Arbeitsauftragsuchtexteingrenzung.eingrenzungstextF\u00fcr(a.auftrag().geplanteFertigstellung())));

    private static String eingrenzungstextF\u00fcr(LocalDate datum) {
        return datum.toString() + " " + datum.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL));
    }

    public Iterable<TextEingrenzung<Arbeitsauftragdaten>> verf\u00fcgbareEingrenzungen() {
        return Collections.unmodifiableList(this.eingrenzungen);
    }

    public Iterable<Arbeitsauftragdaten> grenzeEin(Iterable<Arbeitsauftragdaten> auftragsdaten, String text, Iterable<TextEingrenzung<Arbeitsauftragdaten>> aktiveEingrenzungen) {
        this.getLogger().debug((Object)("Filtere " + IterableUtil.getSizeFor(auftragsdaten) + " Auftr\u00e4ge passend zur Eingrenzung"));
        if (text.isBlank()) {
            return auftragsdaten;
        }
        List<String> teile = List.of(text.split("\\s+"));
        return new FilteredIterable(auftragsdaten, a -> {
            for (String each : teile) {
                if (this.wirdDurchgelassenF\u00fcr((Arbeitsauftragdaten)a, each, aktiveEingrenzungen)) continue;
                return false;
            }
            return true;
        });
    }

    protected boolean wirdDurchgelassenF\u00fcr(Arbeitsauftragdaten auftrag, String text, Iterable<TextEingrenzung<Arbeitsauftragdaten>> aktiveEingrenzungen) {
        for (TextEingrenzung<Arbeitsauftragdaten> each : aktiveEingrenzungen) {
            if (!each.durchlassen((Object)auftrag, text)) continue;
            return true;
        }
        return false;
    }
}

