/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine.dashboard;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragRepository;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.engine.base.EntitybasedAktion;
import com.schneide.werp.produktion.engine.arbeitsauftrag.news.Arbeitsauftr\u00e4geAnzeigen;
import com.schneide.werp.produktion.engine.dashboard.news.DashboarddatenAktualisieren;
import com.schneide.werp.produktion.engine.dashboard.news.DashboarddatenAnzeigen;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Dashboardanzeige
extends LoggedObject
implements EntitybasedAktion {
    private final ArbeitsauftragRepository auftr\u00e4ge;
    private final Subscriber<DashboarddatenAnzeigen> anzeigen;
    private final Subscriber<DashboarddatenAktualisieren> aktualisieren;
    private volatile Iterable<Produktionsnummer> letzterUmfang;

    public Dashboardanzeige(ArbeitsauftragRepository auftr\u00e4ge) {
        this.auftr\u00e4ge = auftr\u00e4ge;
        this.letzterUmfang = Collections.emptyList();
        this.anzeigen = new Subscriber(DashboarddatenAnzeigen.class, n -> this.zeigeAn(n.f\u00fcrProduktionen()));
        this.aktualisieren = new Subscriber(DashboarddatenAktualisieren.class, n -> this.zeigeAn(this.letzterUmfang));
    }

    public void lauscheAuf(EventBus applicationBus) {
        Subscriber.attach(this.anzeigen, (EventBus)applicationBus);
        Subscriber.attach(this.aktualisieren, (EventBus)applicationBus);
    }

    protected void zeigeAn(Iterable<Produktionsnummer> produktionen) {
        this.letzterUmfang = produktionen;
        Iterable daten = this.quelle().collect(Collectors.toList());
        this.anzeigen.publishIfSubscribed((News)new Arbeitsauftr\u00e4geAnzeigen(daten));
    }

    protected Stream<Arbeitsauftrag> quelle() {
        if (IterableUtil.isEmpty(this.letzterUmfang)) {
            return this.auftr\u00e4ge.alle();
        }
        return IterableUtil.asStream(this.letzterUmfang).flatMap(arg_0 -> ((ArbeitsauftragRepository)this.auftr\u00e4ge).alleF\u00fcr(arg_0));
    }
}

