/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Erf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungsweg;
import com.schneide.werp.domain.format.excel.Exceldatei;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParallelenErf\u00fcllungswegEinlesen
extends LoggedObject {
    private static final String erf\u00fcllungsweg_Beschreibung = "Beschreibung";
    private static final String erf\u00fcllungsweg_Zusammengesetzter_Schl\u00fcssel = "Zusammengesetzter Schl\u00fcssel";
    private static final String erf\u00fcllungsweg_Beschaffungskategorie = "Beschaffungskategorie";
    private static final String erf\u00fcllungsweg_Name = "Name (ID)";
    private static final String definitionsbeginn = "Arbeitsschrittabfolgen";
    private static final String start = "Start";
    private static final String ende = "Ende";
    private static final String zusammenschluss = "Join";
    private final ArbeitsschrittRepository bekannteSchritte;

    public ParallelenErf\u00fcllungswegEinlesen(ArbeitsschrittRepository bekannteSchritte) {
        this.bekannteSchritte = bekannteSchritte;
    }

    public boolean istErf\u00fcllungswegdefinition(Exceldatei.Exceltabelle tabelle) {
        return tabelle.name().startsWith("Erf\u00fcllungsweg_");
    }

    public Optional<Erf\u00fcllungsweg> aus(Exceldatei.Exceltabelle tabelle) {
        Exceldatei.Tabellengr\u00f6\u00dfe gr\u00f6\u00dfe = tabelle.gr\u00f6\u00dfe();
        int zeilen = gr\u00f6\u00dfe.zeilen();
        ErwarteteParameter parameter = new ErwarteteParameter(erf\u00fcllungsweg_Name, erf\u00fcllungsweg_Beschaffungskategorie, erf\u00fcllungsweg_Zusammengesetzter_Schl\u00fcssel, erf\u00fcllungsweg_Beschreibung);
        ArrayList<Erf\u00fcllungsstrang> alleStr\u00e4nge = new ArrayList<Erf\u00fcllungsstrang>();
        ArrayList<Erf\u00fcllungsstrang> offeneStr\u00e4nge = new ArrayList<Erf\u00fcllungsstrang>();
        boolean imDefinitionsteil = false;
        for (int zeile = 1; zeile <= zeilen; ++zeile) {
            Optional maybeInhalt = tabelle.zeile(zeile);
            if (maybeInhalt.isEmpty()) continue;
            Exceldatei.Excelzeile excelzeile = (Exceldatei.Excelzeile)maybeInhalt.get();
            if (definitionsbeginn.equalsIgnoreCase(excelzeile.stringIn(0))) {
                imDefinitionsteil = true;
                continue;
            }
            if (!imDefinitionsteil) {
                parameter.ber\u00fccksichtige(excelzeile);
                continue;
            }
            ArrayList<Erf\u00fcllungsstrang> schlie\u00dftAmEndeDerZeile = new ArrayList<Erf\u00fcllungsstrang>();
            for (int spalte = 0; spalte < gr\u00f6\u00dfe.spalten(); ++spalte) {
                int aktuelleSpalte = spalte;
                String zelle = excelzeile.stringIn(spalte);
                if (zelle.equalsIgnoreCase(start)) {
                    Startpunkt beginn = new Startpunkt();
                    alleStr\u00e4nge.add(beginn);
                    offeneStr\u00e4nge.add(beginn);
                    continue;
                }
                if (zelle.equalsIgnoreCase(ende)) {
                    PositionierterArbeitsschritt finalesEinlagern = new PositionierterArbeitsschritt(zeile, spalte, (Arbeitsschritt)this.bekannteSchritte.f\u00fcrIdentifierOderT\u00e4tigkeit("Einlagern (Gefertigter Artikel)").get());
                    Endpunkt schluss = new Endpunkt(offeneStr\u00e4nge, finalesEinlagern);
                    offeneStr\u00e4nge.add(schluss);
                    alleStr\u00e4nge.add(schluss);
                    schlie\u00dftAmEndeDerZeile.addAll(offeneStr\u00e4nge);
                    continue;
                }
                if (zelle.equalsIgnoreCase(zusammenschluss)) {
                    Zusammenschluss join = new Zusammenschluss(aktuelleSpalte);
                    offeneStr\u00e4nge.stream().filter(es -> es.kannVorg\u00e4ngerSein(aktuelleSpalte)).forEach(vorg\u00e4nger -> {
                        join.mitVorg\u00e4nger((Erf\u00fcllungsstrang)vorg\u00e4nger);
                        schlie\u00dftAmEndeDerZeile.add((Erf\u00fcllungsstrang)vorg\u00e4nger);
                    });
                    alleStr\u00e4nge.add(join);
                    offeneStr\u00e4nge.add(join);
                    continue;
                }
                Optional<Erf\u00fcllungsstrang> zugeh\u00f6rigerStrang = offeneStr\u00e4nge.stream().filter(es -> es.geh\u00f6rtDazu(aktuelleSpalte)).findFirst();
                if (zelle.isBlank()) continue;
                Optional schrittAusZelle = this.bekannteSchritte.f\u00fcrIdentifierOderT\u00e4tigkeit(zelle);
                if (schrittAusZelle.isEmpty()) {
                    this.getLogger().error((Object)("Kann den Arbeitsschritt " + zelle + " nicht aufl\u00f6sen."));
                    continue;
                }
                PositionierterArbeitsschritt schritt = new PositionierterArbeitsschritt(zeile, spalte, (Arbeitsschritt)schrittAusZelle.get());
                if (zugeh\u00f6rigerStrang.isPresent()) {
                    zugeh\u00f6rigerStrang.get().mitSchritt(schritt);
                    continue;
                }
                Erf\u00fcllungsstrang neu = new Erf\u00fcllungsstrang(spalte);
                offeneStr\u00e4nge.stream().filter(es -> es.kannVorg\u00e4ngerSein(aktuelleSpalte)).forEach(vorg\u00e4nger -> {
                    neu.mitVorg\u00e4nger((Erf\u00fcllungsstrang)vorg\u00e4nger);
                    schlie\u00dftAmEndeDerZeile.add((Erf\u00fcllungsstrang)vorg\u00e4nger);
                });
                alleStr\u00e4nge.add(neu);
                offeneStr\u00e4nge.add(neu);
                neu.mitSchritt(schritt);
            }
            offeneStr\u00e4nge.removeAll(schlie\u00dftAmEndeDerZeile);
        }
        alleStr\u00e4nge.forEach(es -> this.getLogger().debug(es));
        if (!parameter.alleGesetzt()) {
            this.getLogger().error((Object)("Nicht alle Angaben f\u00fcr " + tabelle.name() + " gesetzt."));
            return Optional.empty();
        }
        HashMap strangabschluss = new HashMap();
        for (Erf\u00fcllungsstrang erf\u00fcllungsstrang : alleStr\u00e4nge) {
            IterableUtil.maybeLastOf(erf\u00fcllungsstrang.erf\u00fcllungsfolge()).ifPresent(es -> strangabschluss.put(erf\u00fcllungsstrang, es));
        }
        for (Erf\u00fcllungsstrang erf\u00fcllungsstrang : alleStr\u00e4nge) {
            Optional maybeFirst = IterableUtil.maybeFirst(erf\u00fcllungsstrang.erf\u00fcllungsfolge());
            if (maybeFirst.isEmpty()) continue;
            Erf\u00fcllungsschritt first = (Erf\u00fcllungsschritt)maybeFirst.get();
            erf\u00fcllungsstrang.vorg\u00e4nger().forEach(v -> {
                Optional<Erf\u00fcllungsschritt> maybeStrangvorg\u00e4nger = Optional.ofNullable((Erf\u00fcllungsschritt)strangabschluss.get(v));
                maybeStrangvorg\u00e4nger.ifPresent(arg_0 -> ((Erf\u00fcllungsschritt)first).h\u00e4ngtAbVon(arg_0));
            });
        }
        ArrayList schritte = new ArrayList();
        for (Erf\u00fcllungsstrang each : alleStr\u00e4nge) {
            each.erf\u00fcllungsfolge().forEach(schritte::add);
        }
        Erf\u00fcllungsweg erf\u00fcllungsweg = new Erf\u00fcllungsweg(parameter.parameterF\u00fcr(erf\u00fcllungsweg_Name).get(), parameter.parameterF\u00fcr(erf\u00fcllungsweg_Beschaffungskategorie).get(), parameter.parameterF\u00fcr(erf\u00fcllungsweg_Zusammengesetzter_Schl\u00fcssel).get(), parameter.parameterF\u00fcr(erf\u00fcllungsweg_Beschreibung).get(), schritte);
        return Optional.of(erf\u00fcllungsweg);
    }

    private static class ErwarteteParameter
    extends LoggedObject {
        private final Map<String, String> angaben = new HashMap<String, String>();

        public ErwarteteParameter(String ... schl\u00fcssel) {
            this(List.of(schl\u00fcssel));
        }

        public ErwarteteParameter(Iterable<String> schl\u00fcssel) {
            for (String each : schl\u00fcssel) {
                this.angaben.put(each, null);
            }
        }

        public boolean alleGesetzt() {
            return this.angaben.entrySet().stream().filter(entry -> entry.getValue() == null).findAny().isEmpty();
        }

        public Optional<String> parameterF\u00fcr(String schl\u00fcssel) {
            return Optional.ofNullable(this.angaben.get(schl\u00fcssel));
        }

        public void ber\u00fccksichtige(Exceldatei.Excelzeile zeile) {
            List zellen = zeile.alsTextliste();
            Optional<Object> f\u00fcrSchl\u00fcssel = Optional.empty();
            for (String each : zellen) {
                if (each.isBlank()) continue;
                if (f\u00fcrSchl\u00fcssel.isEmpty()) {
                    f\u00fcrSchl\u00fcssel = this.schl\u00fcsselF\u00fcr(each);
                    continue;
                }
                this.getLogger().debug((Object)("Parameter gefunden: " + (String)f\u00fcrSchl\u00fcssel.get() + " --> " + each));
                this.angaben.put((String)f\u00fcrSchl\u00fcssel.get(), each);
            }
        }

        protected Optional<String> schl\u00fcsselF\u00fcr(String zellentext) {
            return this.angaben.keySet().stream().filter(s -> zellentext.startsWith((String)s)).findAny();
        }
    }

    public static class Startpunkt
    extends Erf\u00fcllungsstrang {
        public Startpunkt() {
            super(-1);
        }

        @Override
        public boolean kannVorg\u00e4ngerSein(int kandidat) {
            return true;
        }

        @Override
        public List<Erf\u00fcllungsstrang> vorg\u00e4nger() {
            return Collections.emptyList();
        }

        @Override
        protected List<PositionierterArbeitsschritt> schrittfolge() {
            return Collections.emptyList();
        }

        @Override
        public String name() {
            return ParallelenErf\u00fcllungswegEinlesen.start;
        }
    }

    public record PositionierterArbeitsschritt(String position, Arbeitsschritt schritt) {
        public PositionierterArbeitsschritt(int zeile, int spalte, Arbeitsschritt schritt) {
            this(PositionierterArbeitsschritt.positionF\u00fcr(zeile, spalte), schritt);
        }

        private static String positionF\u00fcr(int zeile, int spalte) {
            String spaltenname = String.valueOf((char)(65 + spalte));
            return spaltenname + zeile;
        }
    }

    public static class Endpunkt
    extends Erf\u00fcllungsstrang {
        private final PositionierterArbeitsschritt finaleAktion;

        public Endpunkt(Collection<Erf\u00fcllungsstrang> alleAktiven, PositionierterArbeitsschritt finaleAktion) {
            super(-1);
            this.finaleAktion = finaleAktion;
            alleAktiven.forEach(this::mitVorg\u00e4nger);
        }

        @Override
        protected List<PositionierterArbeitsschritt> schrittfolge() {
            return this.vorg\u00e4nger().isEmpty() ? Collections.emptyList() : List.of(this.finaleAktion);
        }

        @Override
        public String name() {
            return ParallelenErf\u00fcllungswegEinlesen.ende;
        }
    }

    public static class Zusammenschluss
    extends Erf\u00fcllungsstrang {
        public Zusammenschluss(int spalte) {
            super(spalte);
        }

        @Override
        protected List<Erf\u00fcllungsstrang> dereferenziert() {
            return this.vorg\u00e4nger();
        }

        @Override
        protected List<PositionierterArbeitsschritt> schrittfolge() {
            return Collections.emptyList();
        }

        @Override
        public String name() {
            return ParallelenErf\u00fcllungswegEinlesen.zusammenschluss;
        }
    }

    public static class Erf\u00fcllungsstrang {
        private final List<PositionierterArbeitsschritt> schrittfolge;
        private final List<Erf\u00fcllungsstrang> vorg\u00e4nger;
        private final int spalte;
        private final List<Erf\u00fcllungsschritt> aufgel\u00f6st;

        public Erf\u00fcllungsstrang(int spalte) {
            this.spalte = spalte;
            this.schrittfolge = new ArrayList<PositionierterArbeitsschritt>();
            this.vorg\u00e4nger = new ArrayList<Erf\u00fcllungsstrang>();
            this.aufgel\u00f6st = new ArrayList<Erf\u00fcllungsschritt>();
        }

        public boolean geh\u00f6rtDazu(int nachfolgerspalte) {
            return this.horizontaleDistanzZu(nachfolgerspalte) == 0;
        }

        public boolean kannVorg\u00e4ngerSein(int nachfolgerspalte) {
            return this.horizontaleDistanzZu(nachfolgerspalte) == 1;
        }

        protected int horizontaleDistanzZu(int nachfolgerspalte) {
            return Math.abs(nachfolgerspalte - this.inSpalte());
        }

        public String name() {
            return String.valueOf(this.inSpalte());
        }

        public int inSpalte() {
            return this.spalte;
        }

        public void mitVorg\u00e4nger(Erf\u00fcllungsstrang neu) {
            this.vorg\u00e4nger.add(neu);
        }

        public void mitSchritt(PositionierterArbeitsschritt neu) {
            this.schrittfolge.add(neu);
        }

        public List<Erf\u00fcllungsstrang> vorg\u00e4nger() {
            ArrayList<Erf\u00fcllungsstrang> result = new ArrayList<Erf\u00fcllungsstrang>();
            this.vorg\u00e4nger.forEach(es -> result.addAll(es.dereferenziert()));
            return result;
        }

        protected List<Erf\u00fcllungsstrang> dereferenziert() {
            return List.of(this);
        }

        protected List<PositionierterArbeitsschritt> schrittfolge() {
            return this.schrittfolge;
        }

        public Iterable<Erf\u00fcllungsschritt> erf\u00fcllungsfolge() {
            if (this.aufgel\u00f6st.isEmpty()) {
                ArrayList<Erf\u00fcllungsschritt> result = new ArrayList<Erf\u00fcllungsschritt>();
                Optional<Erf\u00fcllungsschritt> vorangegangen = Optional.empty();
                for (PositionierterArbeitsschritt each : this.schrittfolge()) {
                    Erf\u00fcllungsschritt neu = new Erf\u00fcllungsschritt(each.position(), each.schritt());
                    vorangegangen.ifPresent(arg_0 -> ((Erf\u00fcllungsschritt)neu).h\u00e4ngtAbVon(arg_0));
                    result.add(neu);
                    vorangegangen = Optional.of(neu);
                }
                this.aufgel\u00f6st.addAll(result);
            }
            return this.aufgel\u00f6st;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Erf\u00fcllungsstrang " + this.name() + " ");
            result.append("(");
            if (this.vorg\u00e4nger.isEmpty()) {
                result.append("Keine Vorg\u00e4nger");
            } else {
                String vorher = String.join((CharSequence)", ", this.vorg\u00e4nger.stream().map(es -> es.name()).collect(Collectors.toList()));
                result.append("Vorg\u00e4nger: " + vorher);
            }
            result.append("): ");
            result.append(String.join((CharSequence)", ", this.schrittfolge.stream().map(as -> as.schritt().t\u00e4tigkeit()).collect(Collectors.toList())));
            return result.toString();
        }
    }
}

