/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.transformation.Fillup;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ArbeitsauftragverlaufDarstellen
extends LoggedObject {
    private final ArbeitsauftragRepository alleAuftr\u00e4ge;

    public ArbeitsauftragverlaufDarstellen(ArbeitsauftragRepository alleAuftr\u00e4ge) {
        this.alleAuftr\u00e4ge = alleAuftr\u00e4ge;
    }

    public String f\u00fcr(Iterable<Arbeitsauftrag> verlauf) {
        List<Auftragseintrag> eintr\u00e4ge = this.inEintr\u00e4gen(verlauf);
        Eintragsgrid grid = new Eintragsgrid();
        eintr\u00e4ge.forEach(ae -> grid.f\u00fcgeEin((Auftragseintrag)ae));
        return grid.alsDarstellung().toString();
    }

    protected int maximaleTextl\u00e4ngeVon(Iterable<Arbeitsauftrag> verlauf) {
        int result = 0;
        for (Arbeitsauftrag each : verlauf) {
            if (each.t\u00e4tigkeitsbeschreibung().length() <= result) continue;
            result = each.t\u00e4tigkeitsbeschreibung().length();
        }
        return result;
    }

    protected List<Auftragseintrag> inEintr\u00e4gen(Iterable<Arbeitsauftrag> verlauf) {
        HashMap<Arbeitsauftrag, Auftragseintrag> eintr\u00e4ge = new HashMap<Arbeitsauftrag, Auftragseintrag>();
        ArrayList<Auftragseintrag> result = new ArrayList<Auftragseintrag>();
        for (Arbeitsauftrag each : verlauf) {
            Auftragseintrag eintrag = new Auftragseintrag(each);
            result.add(eintrag);
            eintr\u00e4ge.put(each, eintrag);
            for (Arbeitsauftrag vorg\u00e4nger : each.vorarbeiten(this.alleAuftr\u00e4ge)) {
                Optional.ofNullable((Auftragseintrag)eintr\u00e4ge.get(vorg\u00e4nger)).ifPresentOrElse(ae -> {
                    ae.neuerNachfolger(eintrag);
                    eintrag.neuerVorg\u00e4nger((Auftragseintrag)ae);
                }, () -> this.getLogger().error((Object)("Kann den Auftragseintrag f\u00fcr den Arbeitsauftrag " + vorg\u00e4nger.identifikation().alsText() + " nicht finden.")));
            }
        }
        return result;
    }

    private static class Eintragsgrid
    extends LoggedObject {
        private final Map<Auftragseintrag, Koordinate> eintrag2Position = new HashMap<Auftragseintrag, Koordinate>();
        private final Map<Koordinate, Auftragseintrag> position2Eintrag = new HashMap<Koordinate, Auftragseintrag>();
        private int zeilen = 0;
        private int spalten = 0;
        private int maximaleL\u00e4nge = 0;

        public void f\u00fcgeEin(Auftragseintrag neu) {
            Optional<Koordinate> vorg\u00e4ngerposition = IterableUtil.asStream(neu.vorg\u00e4nger()).map(ae -> this.eintrag2Position.get(ae)).filter(k -> k != null).findFirst();
            Koordinate aktuelleZeile = vorg\u00e4ngerposition.orElse(new Koordinate(0, -1)).rechts();
            while (this.position2Eintrag.containsKey(aktuelleZeile)) {
                aktuelleZeile = aktuelleZeile.runter();
            }
            this.position2Eintrag.put(aktuelleZeile, neu);
            this.eintrag2Position.put(neu, aktuelleZeile);
            this.zeilen = Math.max(this.zeilen, aktuelleZeile.zeile + 1);
            this.spalten = Math.max(this.spalten, aktuelleZeile.spalte + 1);
            this.maximaleL\u00e4nge = Math.max(this.maximaleL\u00e4nge, neu.l\u00e4nge());
        }

        public Darstellungsgrid alsDarstellung() {
            Darstellungsgrid result = new Darstellungsgrid(this.zeilen, this.maximaleL\u00e4nge);
            for (int zeile = 0; zeile < this.zeilen; ++zeile) {
                for (int spalte = 0; spalte < this.spalten; ++spalte) {
                    Koordinate position = new Koordinate(zeile, spalte);
                    Optional<Auftragseintrag> maybeEintrag = Optional.ofNullable(this.position2Eintrag.get(position));
                    if (maybeEintrag.isEmpty()) continue;
                    result.f\u00fcgeEin(zeile, new Norml\u00e4ngentext(maybeEintrag.get(), this.maximaleL\u00e4nge), IterableUtil.getSizeFor(maybeEintrag.get().nachfolger()));
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (int zeile = 0; zeile < this.zeilen; ++zeile) {
                DirectChunkBuffer zeilentext = new DirectChunkBuffer((CharSequence)Pr\u00e4fix.rechts.alsText());
                for (int spalte = 0; spalte < this.spalten; ++spalte) {
                    Optional<Auftragseintrag> maybeEintrag = Optional.ofNullable(this.position2Eintrag.get(new Koordinate(zeile, spalte)));
                    String text = maybeEintrag.map(ae -> ae.alsText()).orElseGet(() -> " ".repeat(this.maximaleL\u00e4nge));
                    String printtext = Fillup.trailing((String)text, (int)this.maximaleL\u00e4nge, (String)"_");
                    zeilentext.add((CharSequence)printtext);
                }
                result.append(zeilentext.toString());
                result.append("\n");
            }
            return result.toString().trim();
        }
    }

    private static class Darstellungsgrid
    extends LoggedObject {
        private final List<List<Texteintrag>> zeileninhalte;
        private final int maximalL\u00e4nge;

        public Darstellungsgrid(int zeilen, int maximalL\u00e4nge) {
            this.maximalL\u00e4nge = maximalL\u00e4nge;
            this.zeileninhalte = new ArrayList<List<Texteintrag>>();
            for (int i = 0; i < zeilen; ++i) {
                this.zeileninhalte.add(new ArrayList());
            }
        }

        public void f\u00fcgeEin(int zeile, Norml\u00e4ngentext text, int nachfolger) {
            int i;
            this.zeileninhalte.get(zeile).add(text);
            int zwischenst\u00fccke = nachfolger == 0 ? 0 : Math.max(1, nachfolger - 1);
            for (i = 0; i < zwischenst\u00fccke; ++i) {
                this.zeileninhalte.get(zeile).add(Pr\u00e4fix.rechts);
            }
            for (i = 1; i < nachfolger; ++i) {
                int j;
                this.zeileninhalte.get(zeile + i).add(new FreieStelle(this.maximalL\u00e4nge));
                int empty = i - 1;
                int down = nachfolger - i - 1;
                boolean downRight = true;
                for (j = 0; j < empty; ++j) {
                    this.zeileninhalte.get(zeile + i).add(Pr\u00e4fix.start);
                }
                for (j = 0; j < down; ++j) {
                    this.zeileninhalte.get(zeile + i).add(Pr\u00e4fix.runter);
                }
                for (j = 0; j < 1; ++j) {
                    this.zeileninhalte.get(zeile + i).add(Pr\u00e4fix.runter_rechts);
                }
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (List<Texteintrag> zeile : this.zeileninhalte) {
                StringBuilder zeilentext = new StringBuilder();
                zeile.forEach(te -> zeilentext.append(te.alsText()));
                result.append(zeilentext.toString());
                result.append("\n");
            }
            return result.toString().trim();
        }
    }

    private static class Auftragseintrag
    implements Texteintrag {
        private final String text;
        private final List<Auftragseintrag> vorg\u00e4nger;
        private final List<Auftragseintrag> nachfolger;

        public Auftragseintrag(Arbeitsauftrag auftrag) {
            this.text = auftrag.t\u00e4tigkeitsbeschreibung();
            this.vorg\u00e4nger = new ArrayList<Auftragseintrag>();
            this.nachfolger = new ArrayList<Auftragseintrag>();
        }

        public Iterable<Auftragseintrag> vorg\u00e4nger() {
            return this.vorg\u00e4nger;
        }

        public Iterable<Auftragseintrag> nachfolger() {
            return this.nachfolger;
        }

        public void neuerVorg\u00e4nger(Auftragseintrag eintrag) {
            this.vorg\u00e4nger.add(eintrag);
        }

        public void neuerNachfolger(Auftragseintrag eintrag) {
            this.nachfolger.add(eintrag);
        }

        @Override
        public String alsText() {
            return this.text;
        }

        public String toString() {
            return this.vorg\u00e4nger.size() + " - " + this.text + " - " + this.nachfolger.size();
        }
    }

    private record Koordinate(int zeile, int spalte) {
        public Koordinate runter() {
            return new Koordinate(this.zeile + 1, this.spalte);
        }

        public Koordinate rechts() {
            return new Koordinate(this.zeile, this.spalte + 1);
        }
    }

    private static class FreieStelle
    implements Texteintrag {
        private final String text;

        public FreieStelle(int maximaleL\u00e4nge) {
            this.text = " ".repeat(maximaleL\u00e4nge);
        }

        @Override
        public String alsText() {
            return this.text;
        }
    }

    private static class Norml\u00e4ngentext
    implements Texteintrag {
        private final String text;

        public Norml\u00e4ngentext(Auftragseintrag auftrag, int maximaleL\u00e4nge) {
            this.text = Fillup.trailing((String)auftrag.alsText(), (int)maximaleL\u00e4nge, (String)"_");
        }

        @Override
        public String alsText() {
            return this.text;
        }
    }

    private static enum Suffix implements Texteintrag
    {
        hoch("/ "),
        rechts_hoch("_/"),
        ende("  ");

        private final String text;

        private Suffix(String text) {
            this.text = text;
        }

        @Override
        public String alsText() {
            return this.text;
        }
    }

    private static enum Pr\u00e4fix implements Texteintrag
    {
        start("  "),
        rechts("__"),
        runter_rechts("\\_"),
        runter(" \\");

        private final String text;

        private Pr\u00e4fix(String text) {
            this.text = text;
        }

        @Override
        public String alsText() {
            return this.text;
        }
    }

    private static interface Texteintrag {
        public String alsText();

        default public int l\u00e4nge() {
            return this.alsText().length();
        }
    }
}

