/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.domain.kommentar;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.io.reader.LinesOf;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.werp.domain.kommentar.Kommentar;
import com.schneide.werp.domain.kommentar.KommentarRepository;
import com.schneide.werp.domain.kommentar.Kommentarkontext;
import com.schneide.werp.engine.filesystem.Dateiname;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class VerzeichnisbasiertesKommentarRepository
extends LoggedObject
implements KommentarRepository {
    private static final String dateiendung = ".txt";
    private static final DateTimeFormatter zeitpunktformat = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private final VirtualFile basisverzeichnis;

    public VerzeichnisbasiertesKommentarRepository(VirtualFile basisverzeichnis) {
        this.basisverzeichnis = basisverzeichnis;
    }

    public boolean kenntKontext(Kommentarkontext kontext) {
        return this.existierendesVerzeichnisF\u00fcr(kontext).isPresent();
    }

    public Stream<Kommentarkontext> verf\u00fcgbareKontexte() {
        Iterable unterverzeichnisse = this.basisverzeichnis.subdirectories();
        return IterableUtil.asStream((Iterable)unterverzeichnisse).map(VirtualFile::getName).map(Kommentarkontext::new);
    }

    public Stream<Supplier<Kommentar>> alleF\u00fcr(Kommentarkontext kontext) {
        return this.existierendesVerzeichnisF\u00fcr(kontext).stream().flatMap(vf -> {
            Iterable kommentardateien = vf.listAllFilesEndingOn(dateiendung);
            return IterableUtil.asStream((Iterable)kommentardateien).map(kd -> () -> this.ladeAus((VirtualFile)kd, kontext));
        });
    }

    protected Kommentar ladeAus(VirtualFile datei, Kommentarkontext kontext) {
        try {
            LocalDateTime timestamp = LocalDateTime.parse(datei.nameWithoutExtension(), zeitpunktformat);
            List zeilen = LinesOf.virtualFile((VirtualFile)datei);
            Iterator alleZeilen = zeilen.iterator();
            String autor = (String)alleZeilen.next();
            DirectChunkBuffer text = new DirectChunkBuffer((CharSequence)"\n");
            while (alleZeilen.hasNext()) {
                text.add((CharSequence)alleZeilen.next());
            }
            return new Kommentar(kontext, () -> autor, timestamp, text.toString());
        }
        catch (IOException | DateTimeParseException e) {
            this.getLogger().error((Object)("Fehler beim Einlesen eines Kommentars aus " + String.valueOf(datei)), (Throwable)e);
            return new Kommentar(kontext, () -> "FEHLER", LocalDateTime.now(), "FEHLER");
        }
    }

    public void schreibe(Kommentar neu) throws IOException {
        VirtualFile verzeichnis = this.verzeichnisF\u00fcr(neu.kontext());
        verzeichnis.mkdirs();
        String dateiname = zeitpunktformat.format(neu.zeitpunkt()) + dateiendung;
        System.out.println(dateiname);
        VirtualFile datei = verzeichnis.createFile(dateiname);
        DirectChunkBuffer inhalt = new DirectChunkBuffer((CharSequence)"\n");
        inhalt.add((CharSequence)neu.autor().vollerName());
        neu.textZeilenweise().forEach(arg_0 -> ((DirectChunkBuffer)inhalt).add(arg_0));
        datei.setContentTo(inhalt.asString());
    }

    protected Optional<VirtualFile> existierendesVerzeichnisF\u00fcr(Kommentarkontext kontext) {
        VirtualFile maybePresent = this.verzeichnisF\u00fcr(kontext);
        if (maybePresent.isDirectory()) {
            return Optional.of(maybePresent);
        }
        return Optional.empty();
    }

    protected VirtualFile verzeichnisF\u00fcr(Kommentarkontext kontext) {
        String g\u00fcltigerName = Dateiname.g\u00fcltigF\u00fcr((String)kontext.repr\u00e4sentation());
        VirtualFile result = this.basisverzeichnis.getChild(g\u00fcltigerName);
        return result;
    }
}

