/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.domain.arbeitsschritt.filebased;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.format.bild.Bildformat;
import com.schneide.werp.engine.repository.news.AlleCachesLeeren;
import com.schneide.werp.gui.image.PassendeSkalierung;
import com.schneide.werp.produktion.domain.arbeitsschritt.ArbeitsschrittLogoRepository;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ArbeitsschrittLogoAusDateiRepository
extends LoggedObject
implements ArbeitsschrittLogoRepository {
    private final VirtualFile verzeichnis;
    private final Map<String, Icon> cache;
    private final Subscriber<AlleCachesLeeren> cacheFlush;

    public ArbeitsschrittLogoAusDateiRepository(VirtualFile verzeichnis) {
        this.verzeichnis = verzeichnis;
        this.cache = new HashMap<String, Icon>();
        this.cacheFlush = new Subscriber(AlleCachesLeeren.class, news -> this.clearCache());
    }

    public void starteMit(EventBus applicationBus) {
        Subscriber.attach(this.cacheFlush, (EventBus)applicationBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Map<String, Icon> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Icon> logoF\u00fcr(Arbeitsschritt t\u00e4tigkeit, int gr\u00f6\u00dfe) {
        Object object;
        block19: {
            Optional<Bilddatei> maybeLogo;
            String key = t\u00e4tigkeit.nummer();
            if (gr\u00f6\u00dfe == 64) {
                Map<String, Icon> map = this.cache;
                synchronized (map) {
                    if (this.cache.containsKey(key)) {
                        return Optional.ofNullable(this.cache.get(key));
                    }
                }
            }
            if ((maybeLogo = this.logodateiF\u00fcr(key)).isEmpty()) {
                return Optional.empty();
            }
            Bilddatei datei = maybeLogo.get();
            InputStream quelle = datei.datei().getInputStream();
            try {
                BufferedImage bild = ImageIO.read(quelle);
                if (null == bild) {
                    throw new IOException("Nicht lesbares Format");
                }
                ImageIcon result = new ImageIcon(PassendeSkalierung.f\u00fcr((BufferedImage)bild, (int)gr\u00f6\u00dfe));
                if (gr\u00f6\u00dfe == 64) {
                    object = this.cache;
                    synchronized (object) {
                        this.cache.put(key, result);
                    }
                }
                object = Optional.of(result);
                if (quelle == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (quelle != null) {
                        try {
                            quelle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.getLogger().error((Object)("Konnte das T\u00e4tigkeitslogo " + datei.datei().getAbsoluteName() + " nicht laden."), (Throwable)e);
                    return Optional.empty();
                }
            }
            quelle.close();
        }
        return object;
    }

    protected Optional<Bilddatei> logodateiF\u00fcr(String t\u00e4tigkeitsnummer) {
        List<Bildformat> alleFormate = List.of(Bildformat.values());
        for (Bildformat each : alleFormate) {
            String bilddatei = t\u00e4tigkeitsnummer + "." + each.formatName();
            VirtualFile maybePresent = this.verzeichnis.getChild(bilddatei);
            if (!maybePresent.isFile()) continue;
            Bilddatei result = new Bilddatei(maybePresent, each);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private record Bilddatei(VirtualFile datei, Bildformat format) {
    }
}

