/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.convert;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.UpcastingIterable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Baugruppe;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.format.excel.Exceldatei;
import com.schneide.werp.periphery.datenimport.lader.ExcelLader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class Automatisierungsst\u00fccklistenEinlesen {
    private static final List<String> artikeldefinitions\u00fcberschriften = List.of("Artikelnummer", "Erf\u00fcllungsweg", "Bezeichnung (deutsch)");
    private final ExcelLader excel;
    private final ArbeitsschrittRepository arbeitsschritte;

    public Automatisierungsst\u00fccklistenEinlesen(ArbeitsschrittRepository arbeitsschritte, ExcelLader excel) {
        this.arbeitsschritte = arbeitsschritte;
        this.excel = excel;
    }

    public Iterable<Artikel<?>> ausDatei(VirtualFile datei) throws IOException {
        ArrayList result = new ArrayList();
        Iterable<Artikel<?>> eingeleseneArtikel = this.ausDatei(this.excel.ladenAus(datei));
        eingeleseneArtikel.forEach(result::add);
        return result;
    }

    protected boolean istArtikeldefinition(Exceldatei spezifikation) {
        Iterator \u00fcberschriften = spezifikation.ersteTabelle().zeile(1).map(zeile -> zeile.alsTextliste()).orElseGet(Collections::emptyList).iterator();
        for (String each : artikeldefinitions\u00fcberschriften) {
            if (!\u00fcberschriften.hasNext()) {
                return false;
            }
            String gelesen = (String)\u00fcberschriften.next();
            if (each.equalsIgnoreCase(gelesen)) continue;
            return false;
        }
        return true;
    }

    public Iterable<Artikel<?>> ausDatei(Exceldatei spezifikation) {
        boolean istArtikeldefinition = this.istArtikeldefinition(spezifikation);
        if (istArtikeldefinition) {
            return this.ausArtikeldefinitionsdatei(spezifikation);
        }
        return this.ausBaugruppendefinitionsdatei(spezifikation);
    }

    public Iterable<Artikel<?>> ausArtikeldefinitionsdatei(Exceldatei spezifikation) {
        ArrayList result = new ArrayList();
        Exceldatei.Exceltabelle liste = spezifikation.ersteTabelle();
        liste.zeilenNachKopfzeilen().forEach(zeile -> {
            String artikelnummer = zeile.stringIn("A");
            String erf\u00fcllungsweg = zeile.stringIn("B");
            String bezeichnungDeutsch = zeile.stringIn("C");
            if (artikelnummer.isBlank() || artikeldefinitions\u00fcberschriften.get(0).equals(artikelnummer)) {
                return;
            }
            if (erf\u00fcllungsweg.isBlank()) {
                erf\u00fcllungsweg = "Erf\u00fcllungsweg_EB_10";
            }
            Einzelteil neu = new Einzelteil(new Artikelnummer(artikelnummer), bezeichnungDeutsch, Artikelrevision.erste, erf\u00fcllungsweg);
            result.add(neu);
        });
        return new UpcastingIterable(result);
    }

    public Iterable<Artikel<?>> ausBaugruppendefinitionsdatei(Exceldatei spezifikation) {
        ArrayList<DatenblockbasierteKomponentendefinition> komponenten = new ArrayList<DatenblockbasierteKomponentendefinition>();
        for (Exceldatei.Exceltabelle each : spezifikation.alleTabellen()) {
            each.gr\u00f6\u00dfe().alleZellen().forEach(zelle -> DatenblockbasierteKomponentendefinition.gefundenBei(zelle, each).ifPresent(komponenten::add));
        }
        System.out.println(IterableUtil.getSizeFor(komponenten) + " Komponenten insgesamt");
        System.out.println();
        System.out.println("Details:");
        System.out.println();
        HashSet<String> bekannteKomponenten = new HashSet<String>();
        for (DatenblockbasierteKomponentendefinition each : komponenten) {
            bekannteKomponenten.add(each.zeichnungsnummer());
        }
        for (DatenblockbasierteKomponentendefinition each : komponenten) {
            System.out.println(each.zeichnungsnummer() + ":");
            each.st\u00fcckliste().forEach(se -> {
                String prefix = bekannteKomponenten.contains(se.artikelnummer()) ? "-" : "#";
                System.out.println(prefix + " " + se.artikelanzahl() + "x " + se.artikelnummer());
            });
            System.out.println("----");
        }
        return this.alsArtikel(komponenten);
    }

    protected Iterable<Artikel<?>> alsArtikel(Iterable<DatenblockbasierteKomponentendefinition> komponenten) {
        ArrayList result = new ArrayList();
        for (DatenblockbasierteKomponentendefinition each : komponenten) {
            this.alsArtikel(each).forEach(result::add);
        }
        return result;
    }

    protected Iterable<Artikel<?>> alsArtikel(DatenblockbasierteKomponentendefinition komponente) {
        ArrayList result = new ArrayList();
        Baugruppe baugruppe = new Baugruppe(new Artikelnummer(komponente.zeichnungsnummer()), komponente.zeichnungsnummer(), Artikelrevision.erste, komponente.erf\u00fcllungsweg());
        Iterable<DatenblockbasierteKomponentendefinition.St\u00fccklisteneintrag> eintr\u00e4ge = komponente.st\u00fcckliste();
        int position = 1;
        for (DatenblockbasierteKomponentendefinition.St\u00fccklisteneintrag each : eintr\u00e4ge) {
            Einzelteil teil = new Einzelteil(new Artikelnummer(each.artikelnummer()), each.artikelnummer(), Artikelrevision.erste, "Erf\u00fcllungsweg_EB_10");
            baugruppe.f\u00fcgeInSt\u00fccklisteEin(position, each.artikelanzahl(), (Artikel)teil);
            result.add((Artikel<?>)teil);
            ++position;
        }
        result.add((Artikel<?>)baugruppe);
        return result;
    }

    protected static class DatenblockbasierteKomponentendefinition {
        private static final String zeichnungsnummer = "Zeichnungsnummer";
        private static final String anzahl = "Anzahl";
        private static final String artikel = "Artikel";
        private static final String unterbaugruppe = "Unterbaugruppe";
        private static final Iterable<Iterable<String>> \u00fcberschriften = List.of(List.of("Zeichnungsnummer"), List.of("Anzahl"), List.of("Artikel", "Unterbaugruppe"));
        private final Datenblock daten;

        public static Optional<DatenblockbasierteKomponentendefinition> gefundenBei(Exceldatei.Zellenkoordinate position, Exceldatei.Exceltabelle daten) {
            if (!DatenblockbasierteKomponentendefinition.\u00fcberschriftenPassen(position, daten)) {
                return Optional.empty();
            }
            DatenblockbasierteKomponentendefinition result = new DatenblockbasierteKomponentendefinition(new Datenblock(daten, position.darunter(), IterableUtil.getSizeFor(\u00fcberschriften)));
            return Optional.of(result);
        }

        protected static boolean \u00fcberschriftenPassen(Exceldatei.Zellenkoordinate position, Exceldatei.Exceltabelle daten) {
            Exceldatei.Zellenkoordinate aktuell = position;
            for (Iterable<String> each : \u00fcberschriften) {
                boolean isMatch = false;
                for (String m\u00f6glichkeit : each) {
                    if (!daten.zellentextIst(m\u00f6glichkeit, aktuell)) continue;
                    isMatch = true;
                }
                if (isMatch) {
                    aktuell = aktuell.rechtsDaneben();
                    continue;
                }
                return false;
            }
            return true;
        }

        protected DatenblockbasierteKomponentendefinition(Datenblock daten) {
            this.daten = daten;
        }

        public String zeichnungsnummer() {
            return this.daten.textIn(Exceldatei.Zellenkoordinate.linksOben);
        }

        public String erf\u00fcllungsweg() {
            return this.daten.textIn(Exceldatei.Zellenkoordinate.linksOben.darunter());
        }

        public Iterable<St\u00fccklisteneintrag> st\u00fcckliste() {
            ArrayList<St\u00fccklisteneintrag> result = new ArrayList<St\u00fccklisteneintrag>();
            this.daten.zeilen().forEach(zeile -> {
                if (!zeile.stringIn(1).isBlank()) {
                    St\u00fccklisteneintrag eintrag = new St\u00fccklisteneintrag(zeile.intIn(1), zeile.stringIn(2));
                    result.add(eintrag);
                }
            });
            return result;
        }

        public record St\u00fccklisteneintrag(int artikelanzahl, String artikelnummer) {
        }
    }

    protected static class Datenblock {
        private final Exceldatei.Exceltabelle daten;
        private final Exceldatei.Zellenkoordinate obenLinks;
        private final int breite;

        public Datenblock(Exceldatei.Exceltabelle daten, Exceldatei.Zellenkoordinate obenLinks, int breite) {
            this.daten = daten;
            this.obenLinks = obenLinks;
            this.breite = breite;
        }

        public String textIn(Exceldatei.Zellenkoordinate relativ) {
            DatenblockExcelzeile zeile = new DatenblockExcelzeile(this.daten.name(), this.obenLinks.vertikalVersetzt(relativ.zeile()));
            return zeile.stringIn(relativ.spalte());
        }

        public Iterable<Exceldatei.Excelzeile> zeilen() {
            ArrayList<Exceldatei.Excelzeile> result = new ArrayList<Exceldatei.Excelzeile>();
            Exceldatei.Zellenkoordinate aktuell = this.obenLinks;
            boolean ohneL\u00fccke = true;
            while (ohneL\u00fccke) {
                if (this.hatInhaltIn(aktuell)) {
                    result.add(new DatenblockExcelzeile(this.daten.name(), aktuell));
                    aktuell = aktuell.darunter();
                    continue;
                }
                ohneL\u00fccke = false;
            }
            return result;
        }

        protected boolean hatInhaltIn(Exceldatei.Zellenkoordinate zeilenbeginn) {
            for (int i = 0; i < this.breite; ++i) {
                Exceldatei.Zellenkoordinate cursor = zeilenbeginn.horizontalVersetzt(i);
                if (this.daten.zelleIstLeer(cursor)) continue;
                return true;
            }
            return false;
        }

        protected class DatenblockExcelzeile
        implements Exceldatei.Excelzeile {
            private final Exceldatei.Zellenkoordinate zeilenbeginn;
            private final String tabellenname;

            public DatenblockExcelzeile(String tabellenname, Exceldatei.Zellenkoordinate zeilenbeginn) {
                this.tabellenname = tabellenname;
                this.zeilenbeginn = zeilenbeginn;
            }

            public int spalten() {
                return 100;
            }

            public String tabellenname() {
                return this.tabellenname;
            }

            public String name() {
                return String.valueOf(this.zeilenbeginn.zeile());
            }

            public String stringIn(int spalte) {
                if (spalte > Datenblock.this.breite) {
                    return "";
                }
                Exceldatei.Zellenkoordinate auslesen = this.zeilenbeginn.horizontalVersetzt(spalte);
                String result = Datenblock.this.daten.zellentextOderLeer(auslesen);
                return result;
            }
        }
    }
}

