/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.periphery.dokumenterstellung;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.publishing.Report;
import java.awt.Desktop;
import java.io.IOException;
import java.io.OutputStream;

public interface Dokumenterstellung {
    public Dokumenterstellung to(OutputStream var1);

    public void given(Report var1) throws IOException;

    public static Dokumentanzeige speichere(Report dokument, String verzeichnis, String dateiname, Dokumenterstellung erstellung) {
        try {
            LocalVirtualFile berichte = LocalVirtualFile.directoryAt((String)verzeichnis);
            VirtualFile pdfDatei = berichte.getChild(dateiname);
            Dokumentanzeige result = Dokumenterstellung.speichereIn(dokument, pdfDatei, erstellung);
            return result;
        }
        catch (IOException e) {
            LoggedObject.getStaticLogger().error((Object)"Kann das PDF-Verzeichnis nicht erstellen.", (Throwable)e);
            return () -> {};
        }
    }

    public static Dokumentanzeige speichereIn(Report dokument, VirtualFile pdfDatei, Dokumenterstellung erstellung) {
        Systemdokumentanzeige systemdokumentanzeige;
        block8: {
            OutputStream output = pdfDatei.getOutputStream();
            try {
                erstellung.to(output).given(dokument);
                systemdokumentanzeige = new Systemdokumentanzeige(pdfDatei);
                if (output == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LoggedObject.getStaticLogger().error((Object)("Fehler beim Speichern der PDF-Datei: " + pdfDatei.getName()), (Throwable)e);
                    return () -> {};
                }
            }
            output.close();
        }
        return systemdokumentanzeige;
    }

    public static interface Dokumentanzeige {
        public void show();
    }

    public static class Systemdokumentanzeige
    extends LoggedObject
    implements Dokumentanzeige {
        private final VirtualFile datei;

        public Systemdokumentanzeige(VirtualFile datei) {
            this.datei = datei;
        }

        @Override
        public void show() {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(this.datei.getLocalFile());
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("Fehler bei der PDF-Anzeige von " + String.valueOf(this.datei)), (Throwable)e);
                }
            }
        }
    }
}

