/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.right;

import com.schneide.base.application.usermanagement.model.Right;
import java.util.ArrayList;
import java.util.List;

public class GenericRight
implements Right {
    private boolean isInternal;
    private final String identifier;
    private final List<Right> childrenList;
    private final String denotation;
    private Right parent = null;
    private String parentRightIdentifier = null;

    public GenericRight(String identifier, String denotation) {
        this.denotation = denotation;
        this.identifier = identifier;
        this.isInternal = false;
        this.childrenList = new ArrayList<Right>();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getDenotation() {
        return this.denotation;
    }

    public void setParentRightIdentifier(String parentRightIdentifier) {
        this.parentRightIdentifier = parentRightIdentifier;
    }

    @Override
    public String getParentRightIdentifier() {
        return this.parentRightIdentifier;
    }

    @Override
    public Right getParentRight() {
        return this.parent;
    }

    @Override
    public boolean hasParentRight() {
        return this.getParentRight() != null;
    }

    @Override
    public void setParentRight(Right newParent) {
        this.parent = newParent;
        this.parentRightIdentifier = null;
        if (newParent != null) {
            this.parentRightIdentifier = newParent.getIdentifier();
            this.parent.addChildRight(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildRight(Right right) {
        if (right != null) {
            List<Right> list = this.childrenList;
            synchronized (list) {
                this.childrenList.add(right);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildAccess(Right accessControl) {
        List<Right> list = this.childrenList;
        synchronized (list) {
            this.childrenList.remove(accessControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Right[] getChildren() {
        List<Right> list = this.childrenList;
        synchronized (list) {
            return this.childrenList.toArray(new Right[this.childrenList.size()]);
        }
    }

    @Override
    public boolean getIsInternal() {
        return this.isInternal;
    }

    @Override
    public void setIsInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public String toString() {
        return this.getDenotation();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Right) {
            Right reference = (Right)obj;
            return this.getIdentifier().equals(reference.getIdentifier());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }
}

