/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.table;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;

public class TextAreaCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -7259425261385372756L;
    private final JTextArea textArea = new JTextArea();
    private final JScrollPane scrollPane;

    public TextAreaCellEditor() {
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea, 20, 31);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.getTextArea().setBackground(table.getBackground());
        this.getTextArea().setForeground(table.getForeground());
        this.getTextArea().setFont(table.getFont());
        this.getTextArea().setText(this.getTextualValue(value));
        return this.getScrollPane();
    }

    protected String getTextualValue(Object value) {
        if (null == value) {
            return "";
        }
        return String.valueOf(value);
    }

    private JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private JTextArea getTextArea() {
        return this.textArea;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getTextArea().getText();
    }
}

