/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.table;

import com.schneide.base.application.usermanagement.dialog.table.ColumnValueHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class EntryHolder<T> {
    private ColumnValueHandler<T, ?> sortColumn = null;
    private boolean ascending = true;

    protected abstract List<T> getAllEntries();

    protected abstract void insertEntry(T var1);

    protected abstract void deleteEntries(List<T> var1);

    public void setSortInformation(ColumnValueHandler<T, ?> newSortColumn, boolean isAscending) {
        this.sortColumn = newSortColumn;
        this.ascending = isAscending;
    }

    protected T getEntryAt(int index) {
        List<T> sortedEntries = this.getSortedEntries();
        return sortedEntries.get(index);
    }

    private List<T> getSortedEntries() {
        List<T> entries = this.getAllEntries();
        if (this.sortColumn != null) {
            Collections.sort(entries, new ColumnSortComparator<T>(this, this.sortColumn, this.ascending));
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        EntryHolder entryHolder = this;
        synchronized (entryHolder) {
            return this.getAllEntries().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(T entry) {
        if (entry != null) {
            EntryHolder entryHolder = this;
            synchronized (entryHolder) {
                this.insertEntry(entry);
            }
        }
    }

    public void removeEntriesAt(int[] selectedIndices) {
        List<T> enties = this.getSortedEntries();
        ArrayList<T> entriesToRemove = new ArrayList<T>();
        for (int index : selectedIndices) {
            entriesToRemove.add(enties.get(index));
        }
        this.deleteEntries(entriesToRemove);
    }

    private class ColumnSortComparator<D>
    implements Comparator<D> {
        private final ColumnValueHandler<D, ?> columnHandler;
        private final int sortDirection;

        public ColumnSortComparator(EntryHolder entryHolder, ColumnValueHandler<D, ?> columnHandler, boolean ascending) {
            this.columnHandler = columnHandler;
            this.sortDirection = this.calculateSortDirection(ascending);
        }

        private int calculateSortDirection(boolean isAscending) {
            if (isAscending) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(D entry1, D entry2) {
            return this.getSortDirection() * this.columnHandler.getValue(entry1).compareTo(this.columnHandler.getValue(entry2));
        }

        private int getSortDirection() {
            return this.sortDirection;
        }
    }
}

