/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.listener.ListenerContainer;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RightTreeModel
implements TreeModel {
    private final RightHandler rightHandler;
    private final ListenerContainer<TreeModelListener> listenerContainer;
    private final boolean showInternal;

    public RightTreeModel(RightHandler rightHandler, boolean showInternal) {
        this.rightHandler = rightHandler;
        this.listenerContainer = new ListenerContainer();
        this.showInternal = showInternal;
    }

    @Override
    public Object getRoot() {
        return this.rightHandler.getRootRight();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof Right) {
            Right parentRight = (Right)parent;
            return this.getVisibleChildren(parentRight)[index];
        }
        return null;
    }

    private boolean showInternal() {
        return this.showInternal;
    }

    private Right[] getVisibleChildren(Right parentRight) {
        Right[] rights;
        ArrayList<Right> visibleRightList = new ArrayList<Right>();
        for (Right right : rights = parentRight.getChildren()) {
            if (!this.isRightVisible(right)) continue;
            visibleRightList.add(right);
        }
        return visibleRightList.toArray(new Right[visibleRightList.size()]);
    }

    private boolean isRightVisible(Right right) {
        return this.showInternal() || !right.getIsInternal();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Right) {
            Right parentRight = (Right)parent;
            return this.getVisibleChildren(parentRight).length;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object parent) {
        return this.getChildCount(parent) <= 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Right && child instanceof Right) {
            Right parentRight = (Right)parent;
            Right childRight = (Right)child;
            Right[] childrenControls = this.getVisibleChildren(parentRight);
            for (int i = 0; i < childrenControls.length; ++i) {
                if (!childRight.equals(childrenControls[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        for (TreeModelListener listener : this.listenerContainer.getListeners()) {
            listener.treeNodesChanged(new TreeModelEvent((Object)this, path));
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerContainer.addListener((Object)l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerContainer.removeListener((Object)l);
    }
}

