/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.gui.dialog.button.GenericValidatingDialogButtonHandler;
import com.schneide.base.gui.dialog.button.HandledDialogButton;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.inputs.PasswordInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.StringValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DefaultI18NValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.system.Base;
import java.util.Optional;
import javax.swing.JButton;

public class PasswordChangeDialog
extends AbstractSchneideDialog<String> {
    private final StringValue passwordValue = new StringValue((ValueInformation)new DefaultI18NValueInformation((I18NResolvable)this.getFullKey("input.password")));
    private final StringValue passwordCheckValue = new StringValue((ValueInformation)new DefaultI18NValueInformation((I18NResolvable)this.getFullKey("input.password.check")));

    public PasswordChangeDialog(WindowStack viewStack) {
        super(viewStack, (I18NKeyed)new I18NKey("PasswordChangeDialog"));
    }

    protected void buildUI() {
        PasswordInput passwordInput = new PasswordInput((Value)this.passwordValue);
        PasswordInput passwordCheckInput = new PasswordInput((Value)this.passwordCheckValue);
        this.buildInputDialog(Base.getTextContent().getText(this.getFullKey("message.get.password").getKey()), new Input[]{passwordInput, passwordCheckInput}, (DialogButton)new HandledDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)this.getFullKey("button.check.password")), (DialogButtonHandler)new GenericValidatingDialogButtonHandler(this){

            protected boolean handleDialogButtonAfterValidation(JButton button) {
                return PasswordChangeDialog.this.validatePassword();
            }
        }));
    }

    protected boolean validatePassword() {
        boolean samePassword = this.passwordValue.getValue().equals(this.passwordCheckValue.getValue());
        if (!samePassword) {
            DefaultDialog.showInformationDialog((WindowStack)this.getWindowStack(), (I18NKey)this.getFullKey("error.not.same.password"), (Object[])new Object[0]);
        }
        return samePassword;
    }

    protected Optional<String> giveAnswer() {
        return Optional.ofNullable(this.getPassword());
    }

    public String getPassword() {
        return this.passwordValue.getValue();
    }
}

