/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.SchneideCredentialSelectionDialog;
import com.schneide.base.application.usermanagement.dialog.helper.CredentialTableModel;
import com.schneide.base.application.usermanagement.dialog.table.CheckBoxTableCellEditor;
import com.schneide.base.application.usermanagement.dialog.table.CheckBoxTableCellRenderer;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.gui.component.SchneideTable;
import com.schneide.base.gui.dialog.button.NonvalidatingDialogButton;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.i18n.I18NContext;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.types.i18n.DefaultI18NValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CredentialGUIBuilder
extends I18NContext {
    private final RightHandler rightHandler;
    private final CredentialTableModel credentialModel;
    private final SchneideTable credentialTable;
    private final boolean showInternalInformation;
    private JPanel changeCredentialPanel;
    private final WindowStack session;

    public CredentialGUIBuilder(WindowStack session, Iterable<SchneideCredential> credentials, boolean showInternalInformation, RightHandler rightHandler) {
        super((I18NKeyed)new I18NKey("CredentialPanel"));
        this.session = session;
        this.showInternalInformation = showInternalInformation;
        this.rightHandler = rightHandler;
        this.credentialModel = new CredentialTableModel(credentials, this.showInternalInformation);
        this.credentialTable = new SchneideTable((TableModel)this.getCredentialModel());
    }

    protected void buildUI() {
        this.getCredentialTable().setSelectionMode(2);
        TableColumn permissionColumn = this.getCredentialTable().getColumn((Object)this.credentialModel.getPermissionColumnIdentifier());
        permissionColumn.setCellRenderer(new CheckBoxTableCellRenderer());
        permissionColumn.setCellEditor(new CheckBoxTableCellEditor());
        NonvalidatingDialogButton addCredentialButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)this.getFullKey("button.add.credential")));
        addCredentialButton.addActionListener(e -> new Thread(() -> {
            SchneideCredentialSelectionDialog selectionDialog = new SchneideCredentialSelectionDialog(this.session, this.getRightHandler(), this.showInternalInformation);
            Optional maybeCredentials = selectionDialog.showDialog();
            maybeCredentials.ifPresent(credentials -> {
                for (SchneideCredential schneideCredential : credentials) {
                    this.getCredentialModel().addEntry(schneideCredential);
                }
            });
        }).start());
        NonvalidatingDialogButton removeCredentialButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)this.getFullKey("button.remove.credential")));
        removeCredentialButton.setEnabled(false);
        removeCredentialButton.addActionListener(e -> new Thread(() -> {
            if (!this.getCredentialTable().getSelectionModel().isSelectionEmpty()) {
                this.getCredentialModel().removeEntriesAt(this.getCredentialTable().getSelectedIndices());
            }
        }).start());
        this.getCredentialTable().getSelectionModel().addListSelectionListener(arg_0 -> this.lambda$buildUI$5((JButton)removeCredentialButton, arg_0));
        this.changeCredentialPanel = new JPanel((LayoutManager)new StringGridBagLayout());
        this.changeCredentialPanel.add("anchor=SOUTH,gridx=0,gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", (Component)addCredentialButton);
        this.changeCredentialPanel.add("anchor=NORTH,gridx=0,gridy=1,fill=HORIZONTAL,insets=[5,5,5,5]", (Component)removeCredentialButton);
    }

    public SchneideTable getCredentialTable() {
        return this.credentialTable;
    }

    private RightHandler getRightHandler() {
        return this.rightHandler;
    }

    private CredentialTableModel getCredentialModel() {
        return this.credentialModel;
    }

    public JPanel getChangeCredentialPanel() {
        return this.changeCredentialPanel;
    }

    public ValueInformation getDisplayInformation() {
        return new DefaultI18NValueInformation((I18NResolvable)this.getFullKey("input.credential.table"));
    }

    public Iterable<SchneideCredential> getCredentials() {
        return this.getCredentialModel().getCredentials();
    }

    private /* synthetic */ void lambda$buildUI$5(JButton removeCredentialButton, ListSelectionEvent e) {
        boolean isSelection = !this.getCredentialTable().getSelectionModel().isSelectionEmpty();
        removeCredentialButton.setEnabled(isSelection);
    }
}

