/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.data.BasicSchneideUserGroup;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.logging.LoggedObject;

public abstract class BaseAdditionalInputHandler<U extends SchneideUser>
extends LoggedObject
implements AdditionalInputHandler<U> {
    private final EventBus eventBus;

    public BaseAdditionalInputHandler(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    protected EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public Iterable<Input> getAdditionalSchneideUserInputs() {
        return new EmptyIterable();
    }

    @Override
    public U createSchneideUser(String login, String forename, String surname, String password, boolean isInternal, Iterable<SchneideUserGroup> userGroups, Iterable<SchneideCredential> credentials, UserGroupHandler userGroupHandler, Iterable<Input> additionalInputValues) {
        U result = this.createUserInstance(login, forename, surname, password, isInternal, userGroupHandler, additionalInputValues);
        this.removeAllCredentialsOf(result);
        for (SchneideCredential credential : credentials) {
            result.addCredential(credential);
        }
        this.removeAllUserGroupsOf(result);
        for (SchneideUserGroup group : userGroups) {
            result.addUserGroup(group);
        }
        return result;
    }

    private void removeAllUserGroupsOf(U user) {
        for (SchneideUserGroup group : user.getUserGroups()) {
            user.removeUserGroup(group);
        }
    }

    private void removeAllCredentialsOf(U user) {
        for (SchneideCredential credential : user.getCredentials()) {
            user.removeCredential(credential);
        }
    }

    protected abstract U createUserInstance(String var1, String var2, String var3, String var4, boolean var5, UserGroupHandler var6, Iterable<Input> var7);

    @Override
    public void updateAdditionalSchneideUserInputs() {
    }

    @Override
    public Iterable<Input> getAdditionalSchneideUserGroupInputs() {
        return new EmptyIterable();
    }

    @Override
    public SchneideUserGroup createSchneideUserGroup(String name, SchneideUserGroup parentGroup, boolean isInternal, Iterable<SchneideCredential> credentials, Iterable<Input> inputs) {
        BasicSchneideUserGroup schneideUserGroup = this.createGenericUserGroup(name, parentGroup, isInternal);
        schneideUserGroup.setCredentials(credentials);
        return schneideUserGroup;
    }

    protected BasicSchneideUserGroup createGenericUserGroup(String name, SchneideUserGroup parentGroup, boolean isInternal) {
        return new BasicSchneideUserGroup(name, parentGroup, isInternal, this.eventBus);
    }

    @Override
    public void updateAdditionalSchneideUserGroupInputs() {
    }
}

